package com.biz.crm.member.business.member.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.dto.AnswerRecordPaginationDto;
import com.biz.crm.member.business.member.sdk.dto.QuestionDto;
import com.biz.crm.member.business.member.sdk.dto.QuestionnaireDto;
import com.biz.crm.member.business.member.sdk.dto.QuestionnairePaginationDto;
import com.biz.crm.member.business.member.sdk.dto.QuestionnaireSubmitDto;
import com.biz.crm.member.business.member.sdk.enums.QuestionnaireStatusEnum;
import com.biz.crm.member.business.member.sdk.vo.AnswerRecordVo;
import com.biz.crm.member.business.member.sdk.vo.QuestionAnswerVo;
import com.biz.crm.member.business.member.sdk.vo.QuestionnaireAnalyzeVo;
import com.biz.crm.member.business.member.sdk.vo.QuestionnaireDetailVo;
import com.biz.crm.member.business.member.sdk.vo.QuestionnaireVo;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.data.domain.Pageable;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/20 14:48
 * @description 问卷管理
 */
public interface QuestionnaireService {

  /**
   * 新增一个发布状态的问卷
   *
   * @param dto
   * @return
   */
  QuestionnaireVo createQuestionnairePublish(QuestionDto dto);

  /**
   * 新增一个问卷
   *
   * @param dto
   * @param statusEnum
   * @return
   */
  QuestionnaireVo createQuestionnaire(QuestionDto dto, QuestionnaireStatusEnum statusEnum);

  /**
   * 分页获取问卷信息
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<QuestionnaireVo> pageResult(Pageable pageable, QuestionnairePaginationDto dto);

  /**
   * 批量逻辑删除问卷
   *
   * @param ids
   */
  void logicDelete(List<String> ids);

  /**
   * 启用
   *
   * @param ids
   */
  void turnOnQuestionnaire(List<String> ids);

  /**
   * 禁用
   *
   * @param ids
   */
  void turnOffQuestionnaire(List<String> ids);

  /**
   * 发布问卷
   *
   * @param questionnaireCode
   */
  void publishQuestionnaire(String questionnaireCode);

  /**
   * 结束问卷
   *
   * @param questionnaireCode
   */
  void finishQuestionnaire(String questionnaireCode);

  /**
   * 根据问卷编码获取问卷详情 详情包括：问卷基本信息和问卷配置题目信息
   *
   * @param questionnaireCode
   * @return
   */
  QuestionnaireDetailVo getQuestionnaireDetailByCode(String questionnaireCode);

  /**
   * 修改问卷信息
   *
   * @param dto
   * @return
   */
  QuestionnaireVo modifyQuestionnaire(QuestionDto dto);

  /**
   * 复制一个问卷
   *
   * @param questionnaireCode
   * @return
   */
  QuestionnaireVo copyQuestionnaireByCode(String questionnaireCode);

  /**
   * 问卷分析
   *
   * @param questionnaireCode
   * @return
   */
  List<QuestionnaireAnalyzeVo> getQuestionnaireAnalyze(String questionnaireCode);

  /**
   * 分页获取题目详情信息
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<AnswerRecordVo> pageQuestionDetail(Pageable pageable, AnswerRecordPaginationDto dto);

  /**
   * 获取指定用户的问卷答案
   *
   * @param questionnaireCode
   * @param targetAccount
   * @return
   */
  List<QuestionAnswerVo> getQuestionAnswer(String questionnaireCode, String targetAccount);

  /**
   * 小程序分页获取调查问卷
   * rangeStatus 该属性值从mms_app_questionnaire中获取
   * 其中: all对应获取全部问卷
   *       allow_join对应获取可参与的问卷
   *       submitted对应获取已提交的问卷
   *
   * @param pageable
   * @return
   */
  Page<QuestionnaireVo> pageQuestionnaireWithStatus(Pageable pageable, String rangeStatus);

  /**
   * 小程序分页获取可参与调查问卷
   *
   * @param pageable
   * @return
   */
  Page<QuestionnaireVo> pageQuestionnaireAllowJoin(Pageable pageable);

  /**
   * 小程序分页获取已提交的调查问卷
   *
   * @param pageable
   * @return
   */
  Page<QuestionnaireVo> pageQuestionnaireBySubmitted(Pageable pageable);

  /**
   * 小程序问卷提交
   *
   * @param dtoList
   */
  QuestionnaireVo submitQuestionnaire(List<QuestionnaireSubmitDto> dtoList);

  /**
   * 小程序获取当前用户已提交的调查问卷
   *
   * @param questionnaireCode
   * @return
   */
  List<QuestionAnswerVo> getQuestionnaireDetailBySubmit(String questionnaireCode);
}
