package com.biz.crm.member.business.member.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.dto.RaffleManageDto;
import com.biz.crm.member.business.member.sdk.dto.RaffleManagePageDto;
import com.biz.crm.member.business.member.sdk.vo.RaffleManagePageVo;
import com.biz.crm.member.business.member.sdk.vo.RaffleManageVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * TODO
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/19 16:01
 **/
public interface RaffleManageService {

    /**
     * 大转盘分页查询
     * @param pageable
     * @param pageDto
     * @return
     */
    Page<RaffleManagePageVo> findByConditions(Pageable pageable, RaffleManagePageDto pageDto);

    /**
     * 大转盘活动配置详情
     * @param id
     * @return
     */
    RaffleManageVo findDetailById(String id,String code);

    /**
     * 创建
     * @param raffleManageDto
     * @return
     */
    RaffleManageVo create(RaffleManageDto raffleManageDto);


    /**
     * 修改
     * @param raffleManageDto
     * @return
     */
    RaffleManageVo update(RaffleManageDto raffleManageDto);

    /**
     * 启用
     * @param ids
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param ids
     */
    void disableBatch(List<String> ids);


    /**
     * 删除
     * @param ids
     */
    void deleteBatch(List<String> ids);

    /**
     * 根据活动编码查询活动详情
     * @param activityCode
     * @return
     */
    RaffleManageVo findByActivityCode(String activityCode);
}
