package com.biz.crm.member.business.member.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.dto.RafflePrizeRecordDto;
import com.biz.crm.member.business.member.sdk.vo.PrizeVo;
import com.biz.crm.member.business.member.sdk.vo.RafflePrizeRecordVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * TODO
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/20 14:06
 **/
public interface RafflePrizeRecordService {

    /**
     * 中奖记录分页查询
     * @param pageable
     * @param pageDto
     * @return
     */
    Page<RafflePrizeRecordVo> findByConditions(Pageable pageable, RafflePrizeRecordDto pageDto);

    Page<RafflePrizeRecordVo> findByConditionsByApplet(Pageable pageable, RafflePrizeRecordDto pageDto);

    RafflePrizeRecordVo findDetailById(String id,String code);

    RafflePrizeRecordVo create(RafflePrizeRecordDto rafflePrizeRecordDto);

    RafflePrizeRecordVo update(RafflePrizeRecordDto rafflePrizeRecordDto);

    void enableBatch(List<String> ids);

    void disableBatch(List<String> ids);

    void deleteBatch(List<String> ids);

    /**
     * 统计奖品中奖数量
     * @param prizeCode
     * @return
     */
    PrizeVo statisticsPrize(String prizeCode);

    void updateClaimStatus(String code, String claimStatus);
}
