package com.biz.crm.member.business.member.local.service;

import com.biz.crm.member.business.member.sdk.dto.RafflePrizeDto;
import com.biz.crm.member.business.member.sdk.vo.PrizeVo;
import com.biz.crm.member.business.member.sdk.vo.RafflePrizeVo;

import java.math.BigDecimal;
import java.util.List;

/**
 * TODO
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/19 17:50
 **/
public interface RafflePrizeService {

    /**
     * 根据大转盘活动编码查询
     *
     * @param tenantCode
     * @param raffleCode
     * @return
     */
    List<RafflePrizeVo> findByRaffleCode(String tenantCode, String raffleCode);

    /**
     * @param rafflePrizes
     */
    void saveBatch(List<RafflePrizeDto> rafflePrizes);

    void deleteBatch(List<String> codeList);

    void updateBatch(List<RafflePrizeDto> rafflePrizes, String code);

    /**
     * 调整库存数量
     *
     * @param detailId
     * @param number
     */
    void adjust(String detailId, BigDecimal number);


    void delete(String id);

    /**
     * 根据编码获取奖品配置信息
     *
     * @param rafflePrizeCode
     * @param tenantCode
     */
    RafflePrizeVo findByCode(String rafflePrizeCode, String tenantCode);


    RafflePrizeVo findByCodeAndLevel(String rafflePrizeCode, String tenantCode, String level);
}
