package com.biz.crm.member.business.member.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.member.business.member.sdk.dto.AppOrderPaginationDto;
import com.biz.crm.member.business.member.sdk.dto.DispatchSalesmanDto;
import com.biz.crm.member.business.member.sdk.dto.RealAndDummyOrderPaginationDto;
import com.biz.crm.member.business.member.sdk.dto.RealOrderDto;
import com.biz.crm.member.business.member.sdk.dto.VerificationRealOrderDto;
import com.biz.crm.member.business.member.sdk.vo.RealAndDummyOrderVo;
import com.biz.crm.member.business.member.sdk.vo.RealOrderDistributeVo;
import com.biz.crm.member.business.member.sdk.vo.RealOrderVo;
import com.biz.crm.member.business.member.sdk.dto.RealOrderPaginationDto;
import java.util.List;
import org.springframework.data.domain.Pageable;

/**
 * 实物订单(RealOrder)表服务接口
 *
 * @author zouhs
 * @date 2023-06-14 14:53:17
 */
public interface RealOrderService {

  /**
   * 分页条件查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<RealOrderVo> findByConditions(Pageable pageable, RealOrderPaginationDto dto);

  /**
   * 按id查询详情
   *
   * @param id
   * @return
   */
  RealOrderVo findDetailById(String id);

  /**
   * 创建
   *
   * @param realOrderVo
   * @return
   */
  RealOrderVo create(RealOrderVo realOrderVo);

  /**
   * 更新
   *
   * @param realOrderVo
   * @return
   */
  RealOrderVo update(RealOrderVo realOrderVo);

  /**
   * 按id集合启用
   *
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 按id集合禁用
   *
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 逻辑删除
   *
   * @param ids
   */
  void updateDelFlagByIds(List<String> ids);

  /**
   * 市场配送订单转总部订单
   * @param ids
   */
  void changeTotalOrder(List<String> ids);

  /**
   * 总部订单转市场配送订单
   * @param ids
   */
  void changeMarketOrder(List<String> ids);

  /**
   * 分发
   * @param realOrderDistributeVo
   */
  void changeDistribute(RealOrderDistributeVo realOrderDistributeVo);

  /**
   * 发货
   * @param realOrderVo
   */
  void shipOrderById(RealOrderVo realOrderVo);

  /**
   * 取消发货
   * @param realOrderVo
   */
  void cancelShipOrderById(RealOrderVo realOrderVo);

  /**
   * 更新快递物流单号
   * @param realOrderVo
   */
  void realOrderImportExpressNum(RealOrderVo realOrderVo);

  /**
   * 结算-提交工作流
   * @param realOrderVo
   */
  void settleSubmit(RealOrderVo realOrderVo);

  /**
   * 小程序个人中心分页获取实物订单
   * @param pageable
   * @param dto
   * @return
   */
  Page<RealOrderVo> appPageRealOrder(Pageable pageable, AppOrderPaginationDto dto);

  /**
   * 小程序分页获取业务员为当前登录用户的订单信息，根据订单状态获取
   * @return
   */
  Page<RealOrderVo> appPageDeliveryOrder(Pageable pageable, String orderStatus);

  /**
   * 小程序分页获取当前登录用户分发订单
   * @param pageable
   * @param orderStatus
   * @return
   */
  Page<RealOrderVo> appPageDispatchOrder(Pageable pageable, String orderStatus);

  /**
   * 虚拟和实物订单
   * @param pageable
   * @param paginationDto
   * @return
   */
  Page<RealAndDummyOrderVo> findByConditionsRealAndOrder(Pageable pageable, RealAndDummyOrderPaginationDto paginationDto);

  /**
   * 查询订单
   * @param orderCode
   * @return
   */
  RealOrderVo findDetailByOrderCode(String orderCode);

  /**
   * 小程序为指定实物订单分发业务员
   * @param dto
   */
  void appDispatchSalesmanForOrder(DispatchSalesmanDto dto);

  /**
   * 小程序核销实物订单
   * @param dto
   */
  void appWriteOrderById(VerificationRealOrderDto dto);

  /**
   * 小程序配送订单
   * @param orderId
   */
  void appDeliveryOrderById(String orderId);

  /**
   * 小程序根据组织获取经销商
   * @return
   */
  List<CustomerVo> appListAgentCustomer();
}
