package com.biz.crm.member.business.member.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.dto.LotteryDto;
import com.biz.crm.member.business.member.sdk.dto.RafflePrizeRecordDto;
import com.biz.crm.member.business.member.sdk.vo.LotteryVo;
import com.biz.crm.member.business.member.sdk.vo.RafflePrizeDetailsVo;
import com.biz.crm.member.business.member.sdk.vo.RafflePrizeRecordVo;
import org.springframework.data.domain.Pageable;

/**
 * 大转盘抽奖接口
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/28 15:10
 **/
public interface RewardActivityLotteryService {


    /**
     * 查询当前登录人的中奖记录
     * @param pageable
     * @param rafflePrizeRecordDto
     * @return
     */
    Page<RafflePrizeRecordVo> findByConditions(Pageable pageable,RafflePrizeRecordDto rafflePrizeRecordDto);

    /**
     * 活动规则
     * @param activityCode
     * @return
     */
    String getRuleDes(String activityCode);

    /**
     * 查询大转盘信息，抽奖剩余次数，每次消耗积分
     * @return
     */
    LotteryVo rewardInfo(String activityCode);


    /**
     * 抽奖
     * @param lotteryDto
     * @return
     */
    RafflePrizeDetailsVo lottery(LotteryDto lotteryDto);

}
