package com.biz.crm.member.business.member.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.dto.BenefitsManagePaginationDto;
import com.biz.crm.member.business.member.sdk.dto.ScenicAreaManagementPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.BenefitsManageVo;
import com.biz.crm.member.business.member.sdk.vo.ScenicAreaManagementVo;
import java.util.List;
import org.springframework.data.domain.Pageable;

/**
 * 景点管理(ScenicAreaManagement)表服务接口
 *
 * @author hupan
 * @date 2023/6/20 10:50
 */
public interface ScenicAreaManagementService {

  /**
   * 分页条件查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<ScenicAreaManagementVo> findByConditions(Pageable pageable, ScenicAreaManagementPaginationDto dto);

  /**
   * 创建
   *
   * @param scenicAreaManagementVo
   * @return
   */
  ScenicAreaManagementVo create(ScenicAreaManagementVo scenicAreaManagementVo);

  /**
   * 按id查询详情
   *
   * @param id
   * @return
   */
  ScenicAreaManagementVo findDetailById(String id);

  /**
   * 更新
   *
   * @param scenicAreaManagementVo
   * @return
   */
  ScenicAreaManagementVo update(ScenicAreaManagementVo scenicAreaManagementVo);

  /**
   * 按id集合启用
   *
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 按id集合禁用
   *
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 逻辑删除
   *
   * @param ids
   */
  void updateDelFlagByIds(List<String> ids);
}
