package com.biz.crm.member.business.member.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.vo.SignInRuleDetailVo;
import com.biz.crm.member.business.member.sdk.dto.SignInRuleDetailPaginationDto;
import java.util.List;
import org.springframework.data.domain.Pageable;

/**
 * 签到规则明细(SignInRuleDetail)表服务接口
 *
 * @author zouhs
 * @date 2023-06-15 16:47:45
 */
public interface SignInRuleDetailService {

  /**
   * 分页条件查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<SignInRuleDetailVo> findByConditions(Pageable pageable, SignInRuleDetailPaginationDto dto);

  /**
   * 按id查询详情
   *
   * @param id
   * @return
   */
  SignInRuleDetailVo findDetailById(String id);

  /**
   * 创建
   *
   * @param signInRuleDetailVo
   * @return
   */
  SignInRuleDetailVo create(SignInRuleDetailVo signInRuleDetailVo);

  /**
   * 更新
   *
   * @param signInRuleDetailVo
   * @return
   */
  SignInRuleDetailVo update(SignInRuleDetailVo signInRuleDetailVo);

  /**
   * 按id集合启用
   *
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 按id集合禁用
   *
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 逻辑删除
   *
   * @param ids
   */
  void updateDelFlagByIds(List<String> ids);

  /**
   * 批量处理
   * @param list
   */
  void batchSaveOrUpdate(List<SignInRuleDetailVo> list);

  /**
   * 查询list
   * @param id
   * @return
   */
  List<SignInRuleDetailVo> findListDetailById(String id);
}
