package com.biz.crm.member.business.member.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.vo.SignInRuleVo;
import com.biz.crm.member.business.member.sdk.dto.SignInRulePaginationDto;
import java.util.List;
import org.springframework.data.domain.Pageable;

/**
 * 签到规则(SignInRule)表服务接口
 *
 * @author zouhs
 * @date 2023-06-15 16:47:20
 */
public interface SignInRuleService {

  /**
   * 分页条件查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<SignInRuleVo> findByConditions(Pageable pageable, SignInRulePaginationDto dto);

  /**
   * 按id查询详情
   *
   * @param id
   * @return
   */
  SignInRuleVo findDetailById(String id);

  /**
   * 创建
   *
   * @param signInRuleVo
   * @return
   */
  SignInRuleVo create(SignInRuleVo signInRuleVo);

  /**
   * 更新
   *
   * @param signInRuleVo
   * @return
   */
  SignInRuleVo update(SignInRuleVo signInRuleVo);

  /**
   * 按id集合启用
   *
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 按id集合禁用
   *
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 逻辑删除
   *
   * @param ids
   */
  void updateDelFlagByIds(List<String> ids);

  /**
   * 默认第一条签到规则
   * @return
   */
  SignInRuleVo findDetail();
}
