package com.biz.crm.member.business.member.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.dto.TastingConsultantDto;
import com.biz.crm.member.business.member.sdk.dto.TastingConsultantPageDto;
import com.biz.crm.member.business.member.sdk.vo.TastingConsultantPageVo;
import com.biz.crm.member.business.member.sdk.vo.TastingConsultantVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * TODO
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/13 10:57
 **/
public interface TastingConsultantService {

    /**
     * 分页查询
     * @param pageable
     * @param pageDto
     * @return
     */
    Page<TastingConsultantPageVo> findByConditions(Pageable pageable, TastingConsultantPageDto pageDto);

    /**
     * 根据id查询详情
     * @param id
     * @return
     */
    TastingConsultantVo findDetailById(String id);

    /**
     * 创建
     * @param tastingConsultantDto
     * @return
     */
    TastingConsultantVo create(TastingConsultantDto tastingConsultantDto);

    /**
     * 修改
     * @param tastingConsultantDto
     * @return
     */
    TastingConsultantVo update(TastingConsultantDto tastingConsultantDto);

    /**
     * 启用
     * @param ids
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param ids
     */
    void disableBatch(List<String> ids);

    /**
     * 批量删除
     * @param ids
     */
    void deleteBatch(List<String> ids);

    /**
     * 根据手机号查询当前会员是否是品鉴顾问
     * @param memberPhone
     * @return
     */
    TastingConsultantVo queryFlagTastingByPhone(String memberPhone);
}
