package com.biz.crm.member.business.member.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.dto.VerificationUserDto;
import com.biz.crm.member.business.member.sdk.vo.VerificationUserVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * TODO
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/26 16:47
 **/
public interface VerificationUserService {

    /**
     * 分页查询
     * @param pageable
     * @param pageDto
     * @return
     */
    Page<VerificationUserVo> findByConditions(Pageable pageable, VerificationUserDto pageDto);

    /**
     * 详情
     * @param id
     * @return
     */
    VerificationUserVo findDetailById(String id);

    /**
     * 创建
     * @param verificationUserDto
     * @return
     */
    VerificationUserVo create(VerificationUserDto verificationUserDto);

    /**
     * 修改
     * @param verificationUserDto
     * @return
     */
    VerificationUserVo update(VerificationUserDto verificationUserDto);

    /**
     * 启用
     * @param ids
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param ids
     */
    void disableBatch(List<String> ids);

    /**
     * 删除
     * @param ids
     */
    void deleteBatch(List<String> ids);

    /**
     * 小程序根据组织获取分发业务员
     * @Author 吴平
     * @return
     */
    List<VerificationUserVo> listDispatchSalesman();
}
