package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.local.entity.AddressManage;
import com.biz.crm.member.business.member.local.entity.BenefitsManageOrg;
import com.biz.crm.member.business.member.local.helper.UserSearchHelper;
import com.biz.crm.member.business.member.local.mapper.AddressManageMapper;
import com.biz.crm.member.business.member.local.repository.AddressManageRepository;
import com.biz.crm.member.business.member.local.service.AddressManageService;
import com.biz.crm.member.business.member.sdk.dto.AddressManagePaginationDto;
import com.biz.crm.member.business.member.sdk.dto.BenefitsManageOrgPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.AddressManageVo;
import com.biz.crm.member.business.member.sdk.vo.BenefitsManageOrgVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import liquibase.pro.packaged.A;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author hupan
 * @date 2023/6/30 13:34
 */
@Slf4j
@Service("addressManageServiceImpl")
public class AddressManageServiceImpl implements AddressManageService {

  @Autowired
  private AddressManageRepository addressManageRepository;
  @Autowired
  private UserSearchHelper userSearchHelper;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public Page<AddressManageVo> findByConditions(Pageable pageable, AddressManagePaginationDto dto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    dto = Optional.ofNullable(dto).orElse(new AddressManagePaginationDto());
    Page<AddressManageVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    //如果是小程序端,需要获取memberCode
    if (StringUtils.isBlank(dto.getMemberCode())) {
      String memberCode = userSearchHelper.getMemberLogin().getMemberCode();
      dto.setMemberCode(memberCode);
    }
    return this.addressManageRepository.findByConditions(page, dto);
  }

  @Override
  public AddressManageVo create(AddressManageVo addressManageVo) {
    String memberCode = userSearchHelper.getMemberLogin().getMemberCode();
    AddressManage addressManage = this.nebulaToolkitService.copyObjectByWhiteList(addressManageVo, AddressManage.class, HashSet.class, LinkedList.class);
    addressManage.setTenantCode(TenantUtils.getTenantCode());
    addressManage.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    addressManage.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    //如果是小程序端,需要获取memberCode
    if (StringUtils.isBlank(addressManageVo.getMemberCode())) {
      addressManage.setMemberCode(memberCode);
    }
    this.createValidation(addressManageVo);
    this.addressManageRepository.saveOrUpdate(addressManage);
    if ("1".equals(addressManageVo.getFlagDefaultAddress())){
      setDefault(addressManage.getId());
    }
    return addressManageVo;
  }

  @Override
  @Transactional
  public AddressManageVo update(AddressManageVo addressManageVo) {
    this.updateValidation(addressManageVo);
    String currentId = addressManageVo.getId();
    AddressManage current = addressManageRepository.lambdaQuery().eq(AddressManage::getId,currentId).one();
    current = Validate.notNull(current, "修改信息不存在");
    current = this.nebulaToolkitService.copyObjectByWhiteList(addressManageVo, AddressManage.class, HashSet.class, LinkedList.class);
    this.addressManageRepository.saveOrUpdate(current);
    //如果直接添加为默认地址,则需要修改其他地址的信息
    if ("1".equals(addressManageVo.getFlagDefaultAddress())){
      setDefault(current.getId());
    }
    return addressManageVo;
  }

  @Override
  public AddressManageVo findDetailById(String id) {
    Validate.notNull(id,"id不能为空");
    AddressManage addressManage = addressManageRepository.lambdaQuery()
        .eq(AddressManage::getId, id)
        .one();
    AddressManageVo addressManageVo = nebulaToolkitService
        .copyObjectByWhiteList(addressManage, AddressManageVo.class,
            HashSet.class, LinkedList.class);
    Validate.notNull(addressManageVo,"地址信息不存在");
    return addressManageVo;
  }

  @Override
  @Transactional
  public void setDefault(String id) {
    String memberCode = userSearchHelper.getMemberLogin().getMemberCode();
    this.addressManageRepository.lambdaUpdate()
        .eq(AddressManage::getMemberCode,memberCode)
        .set(AddressManage::getFlagDefaultAddress,"0")
        .update();
    this.addressManageRepository.lambdaUpdate()
        .eq(AddressManage::getId,id)
        .set(AddressManage::getFlagDefaultAddress,"1")
        .update();
  }

  @Override
  @Transactional
  public void updateDelFlagByIds(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.addressManageRepository.lambdaUpdate()
        .in(AddressManage::getId,ids)
        .set(AddressManage::getDelFlag,DelFlagStatusEnum.DELETE.getCode())
        .update();
  }

  @Override
  public void updateDelFlagById(String id) {
    Validate.isTrue(StringUtils.isNotEmpty(id), "id不能为空");
    this.addressManageRepository.lambdaUpdate()
        .eq(AddressManage::getId,id)
        .set(AddressManage::getDelFlag,DelFlagStatusEnum.DELETE.getCode())
        .update();
  }

  private void createValidation(AddressManageVo addressManageVo) {
    this.validation(addressManageVo);
  }

  private void updateValidation(AddressManageVo addressManageVo) {
    this.validation(addressManageVo);
  }

  private void validation(AddressManageVo addressManageVo) {
    Validate.notBlank(addressManageVo.getMemberPhone(),"会员手机号不能为空");
    Validate.notBlank(addressManageVo.getMemberName(),"会员姓名不能为空");
    Validate.notBlank(addressManageVo.getProvinceName(),"省不能为空");
    Validate.notBlank(addressManageVo.getProvinceCode(),"省编码不能为空");
    Validate.notBlank(addressManageVo.getCityName(),"市不能为空");
    Validate.notBlank(addressManageVo.getCityCode(),"市编码不能为空");
    Validate.notBlank(addressManageVo.getDistrictName(),"区不能为空");
    Validate.notBlank(addressManageVo.getDistrictCode(),"区编码不能为空");
    Validate.notBlank(addressManageVo.getDetailAddress(),"详细地址不能为空");
  }
}
