package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.local.entity.AnswerRecord;
import com.biz.crm.member.business.member.local.entity.AnswerUser;
import com.biz.crm.member.business.member.local.entity.QuestionnaireQuestion;
import com.biz.crm.member.business.member.local.repository.AnswerRecordRepository;
import com.biz.crm.member.business.member.local.repository.AnswerUserRepository;
import com.biz.crm.member.business.member.local.repository.QuestionnaireQuestionRepository;
import com.biz.crm.member.business.member.local.service.AnswerRecordService;
import com.biz.crm.member.business.member.sdk.dto.AnswerRecordPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.AnswerRecordVo;
import com.biz.crm.member.business.member.sdk.vo.QuestionCountVo;
import com.biz.crm.member.business.member.sdk.vo.QuestionStatisticVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/21 15:17
 * @description 用户答题记录管理
 */
@Service
public class AnswerRecordServiceImpl implements AnswerRecordService {

  @Autowired
  private AnswerRecordRepository answerRecordRepository;

  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Autowired
  private AnswerUserRepository answerUserRepository;

  @Autowired
  private QuestionnaireQuestionRepository questionnaireQuestionRepository;

  /**
   * 统计题目答案个数
   *
   * @param questionCodes
   * @return
   */
  @Override
  public List<QuestionStatisticVo> statisticQuestion(List<String> questionCodes) {
    if (CollectionUtils.isEmpty(questionCodes)) {
      return Collections.EMPTY_LIST;
    }
    return this.answerRecordRepository.statisticQuestion(questionCodes);
  }

  /**
   * 根据题目编码分页获取答题记录
   * @param pageable
   * @param dto
   * @return
   */
  @Override
  public Page<AnswerRecordVo> pageAnswerRecord(Pageable pageable, AnswerRecordPaginationDto dto) {
    Validate.notBlank(dto.getQuestionCode(), "题目编码不能为空");
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    dto = Optional.ofNullable(dto).orElse(new AnswerRecordPaginationDto());
    Page<AnswerRecordVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<AnswerRecordVo> result = this.answerRecordRepository.pageAnswerRecord(page, dto);
    return result;
  }

  /**
   * 根据题目编号和目标用户账号获取答题记录
   * @param questionCodes
   * @return
   */
  @Override
  public List<AnswerRecordVo> getByQuestionCodes(List<String> questionCodes, String memberCode) {
    Validate.isTrue(CollectionUtils.isNotEmpty(questionCodes), "题目编码不能为空");
    Validate.notBlank(memberCode, "目标用户账号不能为空");
    LambdaQueryWrapper<AnswerRecord> queryWrapper = new LambdaQueryWrapper<>();
    queryWrapper.eq(AnswerRecord::getMemberCode ,memberCode)
        .in(AnswerRecord::getQuestionCode, questionCodes);
    List<AnswerRecord> answerRecords = this.answerRecordRepository.list(queryWrapper);
    Collection<AnswerRecordVo> result = this.nebulaToolkitService
        .copyCollectionByWhiteList(answerRecords, AnswerRecord.class, AnswerRecordVo.class,
            HashSet.class, LinkedList.class);
    return (List<AnswerRecordVo>) result;
  }


  /**
   * 根据题目编码获取答题记录
   * @param questionCodes
   * @return
   */
  @Override
  public List<AnswerRecord> listAnswerRecord(List<String> questionCodes) {
    if (CollectionUtils.isEmpty(questionCodes)){
      return Collections.EMPTY_LIST;
    }
    LambdaQueryWrapper<AnswerRecord> queryWrapper = new LambdaQueryWrapper<>();
    queryWrapper.in(AnswerRecord::getQuestionCode, questionCodes);
    List<AnswerRecord> result = this.answerRecordRepository.list(queryWrapper);
    return result;
  }

  /**
   * 批量新增答题记录
   * @param answerRecords
   */
  @Transactional
  @Override
  public void batchSave(List<AnswerRecord> answerRecords) {
    this.answerRecordRepository.saveBatch(answerRecords);
  }
}
