package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.member.business.member.local.entity.AppPointExchangeEntity;
import com.biz.crm.member.business.member.local.entity.ProductExchangeRule;
import com.biz.crm.member.business.member.local.entity.ProductFile;
import com.biz.crm.member.business.member.local.repository.ActivityManageRepository;
import com.biz.crm.member.business.member.local.repository.ProductExchangeRuleRepository;
import com.biz.crm.member.business.member.local.repository.ProductFileRepository;
import com.biz.crm.member.business.member.local.repository.ProductRepository;
import com.biz.crm.member.business.member.local.service.AppPointStoreService;
import com.biz.crm.member.business.member.local.service.LevelManageService;
import com.biz.crm.member.business.member.sdk.dto.AppPointStoreDto;
import com.biz.crm.member.business.member.sdk.dto.AppPointStorePeopleDto;
import com.biz.crm.member.business.member.sdk.dto.ProductPageDto;
import com.biz.crm.member.business.member.sdk.enums.ProductTypeEnum;
import com.biz.crm.member.business.member.sdk.vo.ProductFileVo;
import com.biz.crm.member.business.member.sdk.vo.ProductPageVo;
import com.biz.crm.member.business.member.sdk.vo.ProductVo;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletLevelManageVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

@Component
public class AppPointStoreServiceImpl implements AppPointStoreService {

  @Autowired
  private ProductRepository productRepository;

  @Autowired
  ActivityManageRepository activityManageRepository;

  @Autowired
  private LoginUserService loginUserService;

  @Autowired
  private ProductFileRepository productFileRepository;

  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Autowired
  private LevelManageService levelManageService;

  @Autowired
  private GenerateCodeService generateCodeService;

  @Autowired
  private RedisMutexService redisMutexService;

  @Autowired
  private ProductExchangeRuleRepository productExchangeRuleRepository;

  @Override//todo 目前查询的商品未过滤上下架状态
  public Page<ProductPageVo> findByConditions(Pageable pageable, ProductPageDto pageDto) {
    if (Objects.isNull(pageDto)) {
      pageDto = new ProductPageDto();
    }
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    Page<ProductPageVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    FacturerUserDetails loginDetails = this.loginUserService.getLoginDetails(FacturerUserDetails.class);
    pageDto.setUserName(loginDetails.getAccount());
    //查询当前会员等级及其下的会员等级编码
    if ("1".equals(pageDto.getAvailable())){
      Validate.isTrue(StringUtils.isNotEmpty(pageDto.getLevelCode()),"查询可兑商品时，当前会员编码不能为空！");
      List<AppletLevelManageVo> childrenIncludeMe = this.levelManageService.getAllChildrenIncludeMe(pageDto.getLevelCode());
      pageDto.setBelowMemberCodes(childrenIncludeMe.stream().map(AppletLevelManageVo::getLevelCode).collect(Collectors.toList()));
    }
    Page<ProductPageVo> voPage = productRepository.findByConditionsByApplet(page, pageDto);
    List<ProductPageVo> products = voPage.getRecords();
    //查询商品上架时的图片信息
    List<ProductFile> productFiles = this.productFileRepository.lambdaQuery().in(ProductFile::getShelfCode, products.stream()
                                                                              .map(ProductPageVo::getCode).collect(Collectors.toList())).list();
    List<ProductFileVo> productFileVos = (List<ProductFileVo>) this.nebulaToolkitService
                              .copyCollectionByWhiteList(productFiles, ProductFile.class, ProductFileVo.class, HashSet.class, LinkedList.class);
    //赋值商品列表图片（取缩略图）
    Map<String, ProductFileVo> shelfCodeToFileVo = productFileVos.stream().filter(x -> "3".equals(x.getType()))
                                                                    .collect(Collectors.toMap(ProductFileVo::getShelfCode, Function.identity()));
    products.forEach(y->y.setSmallFile(shelfCodeToFileVo.get(y.getCode())));
    return voPage;
  }

  @Override
  public ProductVo findDetailById(String id) {
    Validate.isTrue(StringUtils.isNotEmpty(id),"id异常！");
    ProductVo productVo = this.productRepository.findAppletDetailById(id);
    if (ProductTypeEnum.VIRTUAL.getCode().equals(productVo.getProductType())){
      //虚拟货物进行过期提醒
      productVo.setValidateUse("兑换后请在"+productVo.getValidateUse()+"天内使用，逾期视作放弃权益！");
    }else {
      productVo.setValidateUse(null);
    }
    return productVo;
  }

  @Override
  @Transactional
  public void exchangeVirtual(AppPointStoreDto dto) {
    //基本校验
    List<String> orderCode = exchangeValidate(dto);
    //库存合理校验
    boolean locked = false;
    try {
      locked = redisMutexService.tryLock(dto.getCode(), TimeUnit.SECONDS, 5);
      ProductExchangeRule exchangeRule = this.productExchangeRuleRepository.lambdaQuery().eq(ProductExchangeRule::getShelfCode, dto.getCode()).one();
      Validate.isTrue(exchangeRule.getInventoryQuantity().compareTo(new BigDecimal(dto.getExchangeCount())) >= 0,"该积分商品已被兑完！");
      //


    } catch (RuntimeException e) {
      throw new  RuntimeException(e);
    }finally {
      if (locked) {
        redisMutexService.unlock(dto.getCode());
      }
    }




  }

  //积分兑换虚拟商品校验
  private List<String> exchangeValidate(AppPointStoreDto dto){
      Validate.isTrue(StringUtils.isNoneEmpty(dto.getProductCode(),
                              dto.getCode(),dto.getExchangeCount(),dto.getProductType(),"商品编码、商品类型(1实物2虚拟)、上架编码、兑换数量不能为空！"));
      Validate.isTrue(ProductTypeEnum.VIRTUAL.getCode().equals(dto.getProductType()),"兑换商品类型异常！");
      Validate.isTrue(dto.getContacts().size()>=1,"缺失兑换人信息！");
      Validate.isTrue(dto.getContacts().size() == Integer.parseInt(dto.getExchangeCount()),"兑换物品数量与联系人的数量需保持一致！");
      Map<String, List<AppPointStorePeopleDto>> groupByPhone = dto.getContacts().stream().collect(Collectors.groupingBy(AppPointStorePeopleDto::getContactPhone));
      for (String key :groupByPhone.keySet()) {
        List<AppPointStorePeopleDto> contact = groupByPhone.get(key);
        contact.forEach(x-> Validate.isTrue(StringUtils.isNoneEmpty(x.getContactName(),x.getContactName()),"联系人姓名与电话均不能为空！"));
        Validate.isTrue(groupByPhone.get(key).size()==1,"联系人的电话不能重复!");
    }
    FacturerUserDetails loginDetails = this.loginUserService.getLoginDetails(FacturerUserDetails.class);
    dto.setUserName(loginDetails.getAccount());
    AppPointExchangeEntity ruleVo = this.productRepository.findAvailableCount(dto);
    Validate.isTrue(ObjectUtils.isNotEmpty(ruleVo),"商品上架信息异常！");
    String message = "超过兑换次数限制！";
    if ("每日".equals(ruleVo.getExchangePeriodName())){
      Validate.isTrue(ruleVo.getQuantity()-ObjectUtils.defaultIfNull(ruleVo.getCurrentDay(),0) >=0 ,message);
    }else if ("每月".equals(ruleVo.getExchangePeriodName())){
      Validate.isTrue(ruleVo.getQuantity()-ObjectUtils.defaultIfNull(ruleVo.getCurrentMonth(),0) >=0 ,message);
    }else if ("每年".equals(ruleVo.getExchangePeriodName())){
      Validate.isTrue(ruleVo.getQuantity()-ObjectUtils.defaultIfNull(ruleVo.getCurrentYear(),0) >=0 ,message);
    }else if ("每个用户".equals(ruleVo.getExchangePeriodName())){
      Validate.isTrue(ruleVo.getQuantity()-ObjectUtils.defaultIfNull(ruleVo.getAccountExchange(),0) >=0 ,message);
    }
    //编码生成
    return this.generateCodeService.generateCode("POINT-XN" + "-", dto.getContacts().size(), 4, 2, TimeUnit.DAYS);
  }

  //  private List<String> getStartAndEndTime(Date date) {
//    LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
//    LocalDate startOfWeek = localDate.with(DayOfWeek.MONDAY);
//    LocalDate endOfWeek = localDate.with(DayOfWeek.SUNDAY);
//    LocalDate startOfMonth = localDate.withDayOfMonth(1);
//    LocalDate endOfMonth = localDate.withDayOfMonth(localDate.lengthOfMonth());
//    LocalDateTime startOfWeekDateTime = startOfWeek.atStartOfDay();
//    LocalDateTime endOfWeekDateTime = endOfWeek.atTime(LocalTime.MAX);
//    LocalDateTime startOfMonthDateTime = startOfMonth.atStartOfDay();
//    LocalDateTime endOfMonthDateTime = endOfMonth.atTime(LocalTime.MAX);
//    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
//    return Arrays.asList(startOfWeekDateTime.format(formatter),endOfWeekDateTime.format(formatter),startOfMonthDateTime.format(formatter),endOfMonthDateTime.format(formatter));
//  }
}
