package com.biz.crm.member.business.member.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.local.entity.AppletPopupNotify;
import com.biz.crm.member.business.member.local.entity.HolidayEntity;
import com.biz.crm.member.business.member.local.entity.MessageManage;
import com.biz.crm.member.business.member.local.entity.PopupNotify;
import com.biz.crm.member.business.member.local.helper.UserSearchHelper;
import com.biz.crm.member.business.member.local.repository.AppletPopupNotifyRepository;
import com.biz.crm.member.business.member.local.repository.MessageManageRepository;
import com.biz.crm.member.business.member.local.repository.PopupNotifyRepository;
import com.biz.crm.member.business.member.local.service.AppletPopupNotifyService;
import com.biz.crm.member.business.member.sdk.enums.TriggerConditionEnum;
import com.biz.crm.member.business.member.sdk.enums.TriggerTypeEnum;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletPopupNotifyVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author hupan
 * @date 2023/7/4 11:29
 */
@Service("appletPopupNotifyServiceImpl")
public class AppletPopupNotifyServiceImpl implements AppletPopupNotifyService {

  @Autowired
  private UserSearchHelper userSearchHelper;
  @Autowired
  private AppletPopupNotifyRepository appletPopupNotifyRepository;
  @Autowired
  private MessageManageRepository messageManageRepository;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;
  @Autowired
  private PopupNotifyRepository popupNotifyRepository;

  @Override
  public AppletPopupNotifyVo selectOne() {
    String memberCode = userSearchHelper.getMemberLogin().getMemberCode();
    //先走一次删除逻辑在查询
    deleteExpire();
    //查询表,然后根据权重排序
    List<AppletPopupNotify> list = appletPopupNotifyRepository.lambdaQuery()
        .eq(AppletPopupNotify::getMemberCode, memberCode)
        .orderByDesc(AppletPopupNotify::getTriggerWeight)
        .eq(AppletPopupNotify::getTriggerFlag,"0")
        .list();
    if (CollectionUtils.isEmpty(list)){
      return null;
    }
    AppletPopupNotify appletPopupNotify = list.get(0);
    //如果类型为等级/积分,触发之后就删除,否则就是将标记置为1
    AppletPopupNotifyVo appletPopupNotifyVo;
    if (appletPopupNotify.getTriggerType().equals(TriggerTypeEnum.LEVEL.getCode()) || appletPopupNotify.getTriggerType().equals(TriggerTypeEnum.INTEGRAL.getCode())){
      appletPopupNotifyRepository.lambdaUpdate()
          .eq(AppletPopupNotify::getId, appletPopupNotify.getId())
          .remove();
      appletPopupNotifyVo = nebulaToolkitService
          .copyObjectByWhiteList(appletPopupNotify, AppletPopupNotifyVo.class, HashSet.class,
              LinkedList.class);
    }else {
      appletPopupNotifyRepository.lambdaUpdate()
          .eq(AppletPopupNotify::getId, appletPopupNotify.getId())
          .set(AppletPopupNotify::getTriggerFlag, "1")
          .update();
      appletPopupNotifyVo = nebulaToolkitService
          .copyObjectByWhiteList(appletPopupNotify, AppletPopupNotifyVo.class, HashSet.class,
              LinkedList.class);
    }
    return appletPopupNotifyVo;
  }

  @Override
  public void addOne(AppletPopupNotifyVo appletPopupNotifyVo) {
    this.validate(appletPopupNotifyVo);
    MessageManage enable = messageManageRepository.lambdaQuery()
        .eq(MessageManage::getTriggerCondition, appletPopupNotifyVo.getTriggerConditions())
        .one();
    if (enable==null){
      return;
    }
    PopupNotify popupNotify = popupNotifyRepository.lambdaQuery()
        .eq(PopupNotify::getMessageCode, enable.getCode())
        .one();
    //判断当前时间可不可以添加
    Date date = new Date();
    if (popupNotify.getStartDate()==null){
      return;
    }
    if (popupNotify.getEndDate()==null){
      return;
    }
    if (date.after(popupNotify.getStartDate())){
      if (date.before(popupNotify.getEndDate())){
        //如果没有开启弹窗,则不添加到对应的表
        if (enable.getPopupNotify()){
          AppletPopupNotify appletPopupNotify = nebulaToolkitService
              .copyObjectByWhiteList(appletPopupNotifyVo, AppletPopupNotify.class, HashSet.class,
                  LinkedList.class);
          appletPopupNotify.setFileId(popupNotify.getFileId());
          appletPopupNotify.setSkipUrl(popupNotify.getSkipUrl());
          appletPopupNotify.setAppId(popupNotify.getAppId());
          appletPopupNotify.setTriggerFlag("0");
          appletPopupNotify.setEndTime(appletPopupNotifyVo.getEndTime());
          appletPopupNotify.setStartTime(appletPopupNotify.getStartTime());
          appletPopupNotify.setTriggerType(enable.getTriggerType());
          appletPopupNotify.setTriggerWeight(enable.getTriggerWeight());
          appletPopupNotify.setTenantCode(TenantUtils.getTenantCode());
          appletPopupNotify.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
          appletPopupNotify.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
          appletPopupNotifyRepository.saveOrUpdate(appletPopupNotify);
        }
      }
    }
  }

  @Override
  @DynamicTaskService(cornExpression = "0 55 23 1/1 * ?", taskDesc = "每天23:59:00定期删除弹窗表里面过期的数据,以及查询被关闭弹窗的类型")
  public void deleteExpire() {
    //删除过期的
    appletPopupNotifyRepository.lambdaUpdate()
        .eq(AppletPopupNotify::getMemberCode,userSearchHelper.getMemberLogin().getMemberCode())
        .lt(AppletPopupNotify::getEndTime,new Date())
        .remove();
    //删除已经被配置关闭的弹窗
    List<MessageManage> list = messageManageRepository.lambdaQuery()
        .eq(MessageManage::getPopupNotify, false)
        .list();
    if (CollectionUtils.isNotEmpty(list)){
      for (MessageManage messageManage : list) {
        appletPopupNotifyRepository.lambdaUpdate()
            .eq(AppletPopupNotify::getTriggerConditions,messageManage.getTriggerCondition())
            .eq(AppletPopupNotify::getMemberCode,userSearchHelper.getMemberLogin().getMemberCode())
            .remove();
      }
    }
  }

  private void validate(AppletPopupNotifyVo appletPopupNotifyVo){
    Validate.notBlank(appletPopupNotifyVo.getMemberCode(),"会员编码不能为空");
    Validate.notBlank(appletPopupNotifyVo.getTriggerType(),"触发类型不能为空");
    Validate.notBlank(appletPopupNotifyVo.getTriggerConditions(),"触发条件不能为空");
  }
}
