package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.sdk.vo.BenefitsManageOrgVo;
import com.biz.crm.member.business.member.local.entity.BenefitsManageOrg;
import com.biz.crm.member.business.member.local.repository.BenefitsManageOrgRepository;
import com.biz.crm.member.business.member.local.service.BenefitsManageOrgService;
import com.biz.crm.member.business.member.sdk.dto.BenefitsManageOrgPaginationDto;
import com.biz.crm.member.business.member.sdk.event.BenefitsManageOrgEventListener;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 权益管理-区域有效期配置(BenefitsManageOrg)表服务实现类
 *
 * @author zouhs
 * @date 2023-06-12 12:41:25
 */
@Slf4j
@Service("benefitsManageOrgService")
public class BenefitsManageOrgServiceImpl implements BenefitsManageOrgService {
  
  @Autowired(required = false)
  private BenefitsManageOrgRepository benefitsManageOrgRepository;

  @Autowired(required = false)
  private List<BenefitsManageOrgEventListener> eventListeners;

  @Autowired(required = false)
  private GenerateCodeService generateCodeService;

  @Autowired
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public Page<BenefitsManageOrgVo> findByConditions(Pageable pageable, BenefitsManageOrgPaginationDto dto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    dto = Optional.ofNullable(dto).orElse(new BenefitsManageOrgPaginationDto());
    Page<BenefitsManageOrgVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.benefitsManageOrgRepository.findByConditions(page, dto);
  }

  @Override
  public BenefitsManageOrgVo findDetailById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    BenefitsManageOrg benefitsManageOrg = this.benefitsManageOrgRepository.findById(id);
    BenefitsManageOrgVo benefitsManageOrgVo = this.nebulaToolkitService.copyObjectByWhiteList(benefitsManageOrg, BenefitsManageOrgVo.class, HashSet.class, LinkedList.class);
    return benefitsManageOrgVo;
  }
  
  @Override
  @Transactional
  public BenefitsManageOrgVo create(BenefitsManageOrgVo benefitsManageOrgVo) {
    this.createValidation(benefitsManageOrgVo);
    BenefitsManageOrg benefitsManageOrg = this.nebulaToolkitService.copyObjectByWhiteList(benefitsManageOrgVo, BenefitsManageOrg.class, HashSet.class, LinkedList.class);
    benefitsManageOrg.setTenantCode(TenantUtils.getTenantCode());
    benefitsManageOrg.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    benefitsManageOrg.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    this.benefitsManageOrgRepository.saveOrUpdate(benefitsManageOrg);
    return benefitsManageOrgVo;
  }

  @Override
  @Transactional
  public BenefitsManageOrgVo update(BenefitsManageOrgVo benefitsManageOrgVo) {
    this.updateValidation(benefitsManageOrgVo);
    String currentId = benefitsManageOrgVo.getId();
    BenefitsManageOrg current = benefitsManageOrgRepository.findById(currentId);
    current = Validate.notNull(current, "修改信息不存在");
    current = this.nebulaToolkitService.copyObjectByWhiteList(benefitsManageOrgVo, BenefitsManageOrg.class, HashSet.class, LinkedList.class);
    this.benefitsManageOrgRepository.saveOrUpdate(current);
    return benefitsManageOrgVo;
  }

  @Override
  @Transactional
  public void enableBatch(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.benefitsManageOrgRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
  }

  @Override
  @Transactional
  public void disableBatch(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.benefitsManageOrgRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
  }
  
  @Override
  @Transactional
  public void updateDelFlagByIds(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.benefitsManageOrgRepository.updateDelFlagByIds(ids);
  }

  @Override
  @Transactional
  public void saveBatch(List<BenefitsManageOrgVo> list) {
    List<BenefitsManageOrg> saveList = Lists.newArrayList();
    for (BenefitsManageOrgVo benefitsManageOrgVo : list) {
      this.createValidation(benefitsManageOrgVo);
      BenefitsManageOrg benefitsManageOrg = this.nebulaToolkitService.copyObjectByWhiteList(benefitsManageOrgVo, BenefitsManageOrg.class, HashSet.class, LinkedList.class);
      benefitsManageOrg.setTenantCode(TenantUtils.getTenantCode());
      benefitsManageOrg.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
      benefitsManageOrg.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
      saveList.add(benefitsManageOrg);
    }
    this.benefitsManageOrgRepository.saveBatch(saveList);
  }

  @Override
  public List<BenefitsManageOrg> findListByBenefitsManageId(String id) {
    Validate.notBlank(id,"权益管理ID不能为空");
    return this.benefitsManageOrgRepository.lambdaQuery().eq(BenefitsManageOrg::getBenefitsManageId,id).list();
  }

  @Override
  public List<BenefitsManageOrgVo> findListVoByBenefitsManageId(String id) {
    Validate.notBlank(id,"权益管理ID不能为空");
    return (List<BenefitsManageOrgVo>) this.nebulaToolkitService.copyCollectionByWhiteList(this.findListByBenefitsManageId(id), BenefitsManageOrg.class, BenefitsManageOrgVo.class, HashSet.class, ArrayList.class);
  }

  private void createValidation(BenefitsManageOrgVo benefitsManageOrgVo) {
    this.validation(benefitsManageOrgVo);
  }

  private void updateValidation(BenefitsManageOrgVo benefitsManageOrgVo) {
    this.validation(benefitsManageOrgVo);
  }

  private void validation(BenefitsManageOrgVo benefitsManageOrgVo) {
    Validate.notBlank(benefitsManageOrgVo.getBenefitsManageId(),"权益管理ID不能为空");
    Validate.notBlank(benefitsManageOrgVo.getBenefitsManageCode(),"权益管理编码不能为空");
    Validate.notBlank(benefitsManageOrgVo.getOrgCode(),"区域组织编码不能为空");
    Validate.notBlank(benefitsManageOrgVo.getOrgName(),"区域组织名称不能为空");
    Validate.notNull(benefitsManageOrgVo.getExchangeValidPeriod(),"兑换有效期(月)不能为空");
    Validate.notNull(benefitsManageOrgVo.getUseValidPeriod(),"使用有效期(天)不能为空");
  }
}
