package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.local.entity.BenefitsManageOrg;
import com.biz.crm.member.business.member.local.entity.LevelManageBenefitsDetail;
import com.biz.crm.member.business.member.local.repository.BenefitsManageOrgRepository;
import com.biz.crm.member.business.member.local.service.BenefitsManageOrgService;
import com.biz.crm.member.business.member.sdk.vo.BenefitsManageOrgVo;
import com.biz.crm.member.business.member.sdk.vo.BenefitsManageVo;
import com.biz.crm.member.business.member.local.entity.BenefitsManage;
import com.biz.crm.member.business.member.local.repository.BenefitsManageRepository;
import com.biz.crm.member.business.member.local.service.BenefitsManageService;
import com.biz.crm.member.business.member.sdk.dto.BenefitsManagePaginationDto;
import com.biz.crm.member.business.member.sdk.event.BenefitsManageEventListener;
import com.biz.crm.member.business.member.sdk.vo.LevelManageBenefitsDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 权益管理(BenefitsManage)表服务实现类
 *
 * @author zouhs
 * @date 2023-06-12 12:29:46
 */
@Slf4j
@Service("benefitsManageService")
public class BenefitsManageServiceImpl implements BenefitsManageService {
  
  @Autowired(required = false)
  private BenefitsManageRepository benefitsManageRepository;

  @Autowired(required = false)
  private BenefitsManageOrgService benefitsManageOrgService;

  @Autowired(required = false)
  private List<BenefitsManageEventListener> eventListeners;

  @Autowired(required = false)
  private GenerateCodeService generateCodeService;

  @Autowired
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public Page<BenefitsManageVo> findByConditions(Pageable pageable, BenefitsManagePaginationDto dto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    dto = Optional.ofNullable(dto).orElse(new BenefitsManagePaginationDto());
    Page<BenefitsManageVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.benefitsManageRepository.findByConditions(page, dto);
  }

  @Override
  public BenefitsManageVo findDetailById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    BenefitsManage benefitsManage = this.benefitsManageRepository.findById(id);
    Validate.notNull(benefitsManage,"权益未找到");
    BenefitsManageVo benefitsManageVo = this.nebulaToolkitService.copyObjectByWhiteList(benefitsManage, BenefitsManageVo.class, HashSet.class, LinkedList.class);
    benefitsManageVo.setList(this.benefitsManageOrgService.findListVoByBenefitsManageId(id));
    return benefitsManageVo;
  }
  
  @Override
  @Transactional
  public BenefitsManageVo create(BenefitsManageVo benefitsManageVo) {
    this.createValidation(benefitsManageVo);
    BenefitsManage benefitsManage = this.nebulaToolkitService.copyObjectByWhiteList(benefitsManageVo, BenefitsManage.class, HashSet.class, LinkedList.class);
    benefitsManage.setTenantCode(TenantUtils.getTenantCode());
    benefitsManage.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    benefitsManage.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    benefitsManage.setCode(this.generateCodeService.generateCode("QY",5).get(0));
    this.benefitsManageRepository.saveOrUpdate(benefitsManage);
    // 明细新增
    if(CollectionUtils.isNotEmpty(benefitsManageVo.getList())){
      for (BenefitsManageOrgVo benefitsManageOrgVo : benefitsManageVo.getList()) {
        benefitsManageOrgVo.setId(null);
        benefitsManageOrgVo.setBenefitsManageId(benefitsManage.getId());
        benefitsManageOrgVo.setBenefitsManageCode(benefitsManage.getCode());
      }
      benefitsManageOrgService.saveBatch(benefitsManageVo.getList());
    }
    return benefitsManageVo;
  }

  @Override
  @Transactional
  public BenefitsManageVo update(BenefitsManageVo benefitsManageVo) {
    this.updateValidation(benefitsManageVo);
    String currentId = benefitsManageVo.getId();
    BenefitsManage current = benefitsManageRepository.findById(currentId);
    current = Validate.notNull(current, "修改信息不存在");
    current = this.nebulaToolkitService.copyObjectByWhiteList(benefitsManageVo, BenefitsManage.class, HashSet.class, LinkedList.class);
    this.benefitsManageRepository.saveOrUpdate(current);
    // 查询老的，删除
    List<BenefitsManageOrg> oldList = benefitsManageOrgService.findListByBenefitsManageId(current.getId());
    if(CollectionUtils.isNotEmpty(oldList)){
      List<String> ids = oldList.stream().map(UuidEntity::getId).collect(Collectors.toList());
      benefitsManageOrgService.updateDelFlagByIds(ids);
    }
    // 明细新增
    if(CollectionUtils.isNotEmpty(benefitsManageVo.getList())){
      for (BenefitsManageOrgVo benefitsManageOrgVo : benefitsManageVo.getList()) {
        benefitsManageOrgVo.setId(null);
        benefitsManageOrgVo.setBenefitsManageId(current.getId());
        benefitsManageOrgVo.setBenefitsManageCode(current.getCode());
      }
      benefitsManageOrgService.saveBatch(benefitsManageVo.getList());
    }
    return benefitsManageVo;
  }

  @Override
  @Transactional
  public void enableBatch(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.benefitsManageRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
  }

  @Override
  @Transactional
  public void disableBatch(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.benefitsManageRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
  }
  
  @Override
  @Transactional
  public void updateDelFlagByIds(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.benefitsManageRepository.updateDelFlagByIds(ids);
  }

  @Override
  public List<BenefitsManageVo> findDetailByCodes(Set<String> benefitsCodes) {
    Validate.isTrue(CollectionUtils.isNotEmpty(benefitsCodes),"权益编码集合不能为空");
    List<BenefitsManage> list = this.benefitsManageRepository.lambdaQuery()
        .in(BenefitsManage::getCode, benefitsCodes)
        .eq(UuidFlagOpEntity::getEnableStatus, EnableStatusEnum.ENABLE.getCode())
        .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode()).list();
    if(CollectionUtils.isEmpty(list)){
      return Lists.newArrayList();
    }
    return (List<BenefitsManageVo>)this.nebulaToolkitService.copyCollectionByWhiteList(list, BenefitsManage.class, BenefitsManageVo.class, HashSet.class, ArrayList.class);
  }

  private void createValidation(BenefitsManageVo benefitsManageVo) {
    this.validation(benefitsManageVo);
  }

  private void updateValidation(BenefitsManageVo benefitsManageVo) {
    this.validation(benefitsManageVo);
  }

  private void validation(BenefitsManageVo benefitsManageVo) {
    Validate.notBlank(benefitsManageVo.getName(), "权益名称不能为空");
    Validate.notBlank(benefitsManageVo.getType(), "权益类型不能为空");
    Validate.notNull(benefitsManageVo.getExchangeValidPeriod(),"兑换有效期(月)不能为空");
    Validate.notNull(benefitsManageVo.getUseValidPeriod(),"使用有效期(天)不能为空");
  }
}
