package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.local.entity.BenefitsManageOrg;
import com.biz.crm.member.business.member.local.entity.BenefitsTransferRecord;
import com.biz.crm.member.business.member.local.repository.BenefitsTransferRecordRepository;
import com.biz.crm.member.business.member.local.service.BenefitsTransferRecordService;
import com.biz.crm.member.business.member.sdk.dto.BenefitsManageOrgPaginationDto;
import com.biz.crm.member.business.member.sdk.dto.BenefitsTransferRecordPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.BenefitsManageOrgVo;
import com.biz.crm.member.business.member.sdk.vo.BenefitsTransferRecordVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/**
 * @author hupan
 * @date 2023/6/29 16:16
 */
@Slf4j
@Service("benefitsTransferRecordServiceImpl")
public class BenefitsTransferRecordServiceImpl implements BenefitsTransferRecordService {

  @Autowired
  private BenefitsTransferRecordRepository benefitsTransferRecordRepository;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public Page<BenefitsTransferRecordVo> findByConditions(Pageable pageable, BenefitsTransferRecordPaginationDto dto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    dto = Optional.ofNullable(dto).orElse(new BenefitsTransferRecordPaginationDto());
    Page<BenefitsTransferRecordVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.benefitsTransferRecordRepository.findByConditions(page, dto);
  }

  @Override
  public BenefitsTransferRecordVo findDetailById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    BenefitsTransferRecord benefitsTransferRecord = this.benefitsTransferRecordRepository.findById(id);
    BenefitsTransferRecordVo benefitsTransferRecordVo = this.nebulaToolkitService.copyObjectByWhiteList(benefitsTransferRecord, BenefitsTransferRecordVo.class, HashSet.class, LinkedList.class);
    return benefitsTransferRecordVo;
  }
}
