package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.local.entity.CulturalAndTourismRespondent;
import com.biz.crm.member.business.member.local.entity.CulturalAndTourismTopic;
import com.biz.crm.member.business.member.local.entity.SystemSettingsDetail;
import com.biz.crm.member.business.member.local.mapper.CulturalAndTourismTopicMapper;
import com.biz.crm.member.business.member.local.repository.CulturalAndTourismRespondentRepository;
import com.biz.crm.member.business.member.local.repository.CulturalAndTourismTopicRepository;
import com.biz.crm.member.business.member.local.service.CulturalAndTourismRespondentService;
import com.biz.crm.member.business.member.local.service.MemberInfoIntegralRecordService;
import com.biz.crm.member.business.member.local.service.SystemSettingsDetailService;
import com.biz.crm.member.business.member.sdk.dto.CulturalAndTourismRespondentPaginationDto;
import com.biz.crm.member.business.member.sdk.enums.IntegralSourceEnum;
import com.biz.crm.member.business.member.sdk.enums.SystemSettingsDetailEnum;
import com.biz.crm.member.business.member.sdk.vo.CulturalAndTourismInitAPIVo;
import com.biz.crm.member.business.member.sdk.vo.CulturalAndTourismRespondentAPIVo;
import com.biz.crm.member.business.member.sdk.vo.CulturalAndTourismRespondentVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoIntegralRecordVo;
import com.biz.crm.member.business.member.sdk.vo.SystemSettingsDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.time.LocalDate;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author hupan
 * @date 2023/6/19 14:51
 */
@Service("culturalAndTourismRespondentServiceImpl")
@Slf4j
public class CulturalAndTourismRespondentServiceImpl implements CulturalAndTourismRespondentService {

  @Autowired
  private CulturalAndTourismRespondentRepository culturalAndTourismRespondentRepository;
  @Autowired
  private CulturalAndTourismTopicMapper culturalAndTourismTopicMapper;
  @Autowired
  private CulturalAndTourismTopicRepository culturalAndTourismTopicRepository;
  @Autowired
  private MemberInfoIntegralRecordService memberInfoIntegralRecordService;
  @Autowired
  private SystemSettingsDetailService systemSettingsDetailService;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;
  @Autowired
  private GenerateCodeService generateCodeService;

  @Override
  public Page<CulturalAndTourismRespondentVo> findByConditions(Pageable pageable,
      CulturalAndTourismRespondentPaginationDto dto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    dto = Optional.ofNullable(dto).orElse(new CulturalAndTourismRespondentPaginationDto());
    Page<CulturalAndTourismRespondentVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return culturalAndTourismRespondentRepository.findByConditions(page,dto);
  }

  @Override
  public CulturalAndTourismInitAPIVo initData(String phone) {
    CulturalAndTourismInitAPIVo culturalAndTourismInitAPIVo = new CulturalAndTourismInitAPIVo();
    //已答题
    Integer number = this.count(phone);
    //答题获得积分
    Integer points = this.earnPoints(phone);
    //本月还可获得积分答题次数
    Integer times = this.numberOfQuestionsLeftThisMonth(phone);
    //活动规则
    SystemSettingsDetailVo result = this.activityRules();
    culturalAndTourismInitAPIVo.setAnsweredQuestionsTimes(number);
    culturalAndTourismInitAPIVo.setEarnPoints(points);
    culturalAndTourismInitAPIVo.setNumberOfQuestionsLeftThisMonth(times);
    culturalAndTourismInitAPIVo.setActivityRules(result.getTypeValueText());
    return culturalAndTourismInitAPIVo;
  }

  @Override
  @Transactional
  public CulturalAndTourismRespondentAPIVo create(CulturalAndTourismRespondentAPIVo culturalAndTourismRespondentAPIVo) {
    Validate.notBlank(culturalAndTourismRespondentAPIVo.getMemberCode(),"会员编码不能为空");
    CulturalAndTourismRespondentVo culturalAndTourismRespondentVo = this.nebulaToolkitService.copyObjectByWhiteList(culturalAndTourismRespondentAPIVo, CulturalAndTourismRespondentVo.class, HashSet.class, LinkedList.class);
    this.createValidation(culturalAndTourismRespondentVo);
    CulturalAndTourismRespondent culturalAndTourismRespondent = this.nebulaToolkitService.copyObjectByWhiteList(culturalAndTourismRespondentAPIVo, CulturalAndTourismRespondent.class, HashSet.class, LinkedList.class);
    //判断可以获取的积分为多少
    Integer points = this.thisTimeEarnPoints(culturalAndTourismRespondentVo.getPhone());
    //插入答题记录表
    culturalAndTourismRespondent.setTenantCode(TenantUtils.getTenantCode());
    culturalAndTourismRespondent.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    culturalAndTourismRespondent.setPoints(points);
    culturalAndTourismRespondent.setAnswerTime(new Date());
    culturalAndTourismRespondent.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    culturalAndTourismRespondent.setCode(this.generateCodeService.generateCode("WN",5).get(0));
    this.culturalAndTourismRespondentRepository.saveOrUpdate(culturalAndTourismRespondent);
    //更新文旅题目表
    String phone = culturalAndTourismRespondentAPIVo.getPhone();
    String answerResult = culturalAndTourismRespondentAPIVo.getAnswerResult();
    LambdaQueryWrapper<CulturalAndTourismTopic> queryWrapper = new LambdaQueryWrapper<>();
    queryWrapper.eq(CulturalAndTourismTopic::getCode,culturalAndTourismRespondentAPIVo.getCode());
    CulturalAndTourismTopic culturalAndTourismTopic = culturalAndTourismTopicMapper.selectOne(queryWrapper);
    Validate.notNull(culturalAndTourismTopic,"题目不存在");
    this.updateCulturalAndTourismTopic(phone,answerResult,culturalAndTourismTopic);
    //更新积分记录表
    if (points>0){
      MemberInfoIntegralRecordVo memberInfoIntegralRecordVo = nebulaToolkitService
          .copyObjectByWhiteList(culturalAndTourismRespondentAPIVo,
              MemberInfoIntegralRecordVo.class, HashSet.class, LinkedList.class);
      memberInfoIntegralRecordVo.setMemberCode(culturalAndTourismRespondentAPIVo.getMemberCode());
      memberInfoIntegralRecordVo.setSource(IntegralSourceEnum.CULTURAL_TOURISM_TOPIC.getValue());
      memberInfoIntegralRecordVo.setType(IntegralSourceEnum.CULTURAL_TOURISM_TOPIC.getType());
      memberInfoIntegralRecordVo.setIntegral(points);
      memberInfoIntegralRecordService.commonInternal(memberInfoIntegralRecordVo);
    }
    return culturalAndTourismRespondentAPIVo;
  }

  @Override
  public Integer count(String phone) {
    return culturalAndTourismRespondentRepository.lambdaQuery()
        .eq(CulturalAndTourismRespondent::getPhone,phone)
        .count();
  }

  @Override
  public Integer earnPoints(String phone) {
    //通过手机号获取记录
    List<CulturalAndTourismRespondent> list = culturalAndTourismRespondentRepository.lambdaQuery()
        .eq(CulturalAndTourismRespondent::getPhone, phone)
        .list();
    int sum = list.stream()
        .map(CulturalAndTourismRespondent::getPoints)
        .mapToInt(Integer::intValue)
        .sum();
    return sum;
  }

  @Override
  public Integer numberOfQuestionsLeftThisMonth(String phone) {
    //获取当前月的第一天的时间
    LocalDate now = LocalDate.now();
    LocalDate firstDay = now.withDayOfMonth(1);
    log.info("========================{}",firstDay);
    //通过手机号获取记录
    List<CulturalAndTourismRespondent> list = culturalAndTourismRespondentRepository.lambdaQuery()
        .eq(CulturalAndTourismRespondent::getPhone, phone)
        .gt(CulturalAndTourismRespondent::getAnswerTime,firstDay)
        .list();
    //本月通过答题已获得的积分
    int sum = list.stream()
        .map(CulturalAndTourismRespondent::getPoints)
        .mapToInt(Integer::intValue)
        .sum();
    //查询每道题可以获得的积分
    String answeringCorrectPointsString = systemSettingsDetailService
        .findValueByKey(SystemSettingsDetailEnum.ANSWERING_CORRECTLY_POINTS.getValue())
        .getTypeValue();
    answeringCorrectPointsString = Optional.ofNullable(answeringCorrectPointsString).orElse("0");
    int answeringCorrectPoints = Integer.parseInt(answeringCorrectPointsString);
    //查询每月可获得的积分上限
    String maxPointsPerMonthString = systemSettingsDetailService
        .findValueByKey(SystemSettingsDetailEnum.MAX_POINTS_PER_MONTH.getValue())
        .getTypeValue();
    maxPointsPerMonthString = Optional.ofNullable(maxPointsPerMonthString).orElse("0");
    int maxPointsPerMonth = Integer.parseInt(maxPointsPerMonthString);
    //计算出还可以获取的次数
    if (answeringCorrectPoints == 0){
      return 99;
    }
    int times = (maxPointsPerMonth-sum) / answeringCorrectPoints;
    if ((maxPointsPerMonth-sum) % answeringCorrectPoints != 0){
      times++;
    }
    return times;
  }

  @Override
  public SystemSettingsDetailVo activityRules() {
    SystemSettingsDetail systemSettingsDetail = systemSettingsDetailService
        .findValueByKey(SystemSettingsDetailEnum.ACTIVITY_RULES.getValue());
    SystemSettingsDetailVo systemSettingsDetailVo = nebulaToolkitService
        .copyObjectByWhiteList(systemSettingsDetail, SystemSettingsDetailVo.class, HashSet.class,
            LinkedList.class);
    return systemSettingsDetailVo;
  }

  private Integer thisTimeEarnPoints(String phone){
    //获取当前月的第一天的时间
    LocalDate now = LocalDate.now();
    LocalDate firstDay = now.withDayOfMonth(1);
    //通过手机号获取记录
    List<CulturalAndTourismRespondent> list = culturalAndTourismRespondentRepository.lambdaQuery()
        .eq(CulturalAndTourismRespondent::getPhone, phone)
        .gt(CulturalAndTourismRespondent::getAnswerTime,firstDay)
        .list();
    //本月通过答题已获得的积分
    int sum = list.stream()
        .map(CulturalAndTourismRespondent::getPoints)
        .mapToInt(Integer::intValue)
        .sum();
    //查询每道题可以获得的积分
    String answeringCorrectPointsString = systemSettingsDetailService
        .findValueByKey(SystemSettingsDetailEnum.ANSWERING_CORRECTLY_POINTS.getValue())
        .getTypeValue();
    int answeringCorrectPoints = Integer.parseInt(answeringCorrectPointsString);
    //查询每月可获得的积分上限
    String maxPointsPerMonthString = systemSettingsDetailService
        .findValueByKey(SystemSettingsDetailEnum.MAX_POINTS_PER_MONTH.getValue())
        .getTypeValue();
    int maxPointsPerMonth = Integer.parseInt(maxPointsPerMonthString);
    //计算出这次可以获取的积分
    if ((maxPointsPerMonth-sum) >= answeringCorrectPoints){
      return answeringCorrectPoints;
    }
    return maxPointsPerMonth - sum;
  }

  private void updateCulturalAndTourismTopic(String phone,String answerResult,
      CulturalAndTourismTopic culturalAndTourismTopic){
    //正确人数
    Integer correctPeopleTimes = culturalAndTourismTopic.getCorrectPeopleTimes();
    correctPeopleTimes = Optional.ofNullable(correctPeopleTimes).orElse(0);
    //正确次数
    Integer correctTimes = culturalAndTourismTopic.getCorrectTimes();
    correctTimes = Optional.ofNullable(correctTimes).orElse(0);
    //提交人数
    Integer commitPeopleTimes = culturalAndTourismTopic.getCommitPeopleTimes();
    commitPeopleTimes = Optional.ofNullable(commitPeopleTimes).orElse(0);
    //提交次数
    Integer commitTimes = culturalAndTourismTopic.getCommitTimes();
    commitTimes = Optional.ofNullable(commitTimes).orElse(0);
    List<CulturalAndTourismRespondent> list = culturalAndTourismRespondentRepository.lambdaQuery()
        .eq(CulturalAndTourismRespondent::getPhone, phone)
        .eq(CulturalAndTourismRespondent::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .list();
    //手机号不同
    if (list.isEmpty()){
      //答案正确
      if (Boolean.parseBoolean(answerResult)){
        culturalAndTourismTopic.setCommitPeopleTimes(++commitPeopleTimes);
        culturalAndTourismTopic.setCommitTimes(++commitTimes);
        culturalAndTourismTopic.setCorrectPeopleTimes(++correctPeopleTimes);
        culturalAndTourismTopic.setCorrectTimes(++correctTimes);
        culturalAndTourismTopicRepository.saveOrUpdate(culturalAndTourismTopic);
      }else {
        //答案错误
        culturalAndTourismTopic.setCommitPeopleTimes(++commitPeopleTimes);
        culturalAndTourismTopic.setCommitTimes(++commitTimes);
        culturalAndTourismTopicRepository.saveOrUpdate(culturalAndTourismTopic);
      }
    } else {
      //手机号相同
      //答案正确
      if (Boolean.parseBoolean(answerResult)){
        culturalAndTourismTopic.setCommitTimes(++commitTimes);
        culturalAndTourismTopic.setCorrectTimes(++correctTimes);
        culturalAndTourismTopicRepository.saveOrUpdate(culturalAndTourismTopic);
      }else {
        //答案错误
        culturalAndTourismTopic.setCommitTimes(++commitTimes);
        culturalAndTourismTopicRepository.saveOrUpdate(culturalAndTourismTopic);
      }
    }
  }
  private void createValidation(CulturalAndTourismRespondentVo culturalAndTourismRespondentVo) {
    this.validation(culturalAndTourismRespondentVo);
  }

  private void updateValidation(CulturalAndTourismRespondentVo culturalAndTourismRespondentVo) {
    this.validation(culturalAndTourismRespondentVo);
  }

  private void validation(CulturalAndTourismRespondentVo culturalAndTourismRespondentVo) {
    Validate.notBlank(culturalAndTourismRespondentVo.getCode(),"题目code不能为空");
    Validate.notBlank(culturalAndTourismRespondentVo.getName(), "题目名称不能为空");
    Validate.notBlank(culturalAndTourismRespondentVo.getRightAnswer(), "正确答案不能为空");
    Validate.notBlank(culturalAndTourismRespondentVo.getSelectAnswer(),"选择答案不能为空");
    Validate.notBlank(culturalAndTourismRespondentVo.getAnswerResult(),"答题结果不能为空");
    Validate.notBlank(culturalAndTourismRespondentVo.getPhone(),"答题人手机号不能为空");
    Validate.notBlank(culturalAndTourismRespondentVo.getName(),"答题人姓名不能为空");
  }
}
