package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.local.entity.BenefitsManage;
import com.biz.crm.member.business.member.local.entity.CulturalAndTourismTopic;
import com.biz.crm.member.business.member.local.repository.CulturalAndTourismTopicRepository;
import com.biz.crm.member.business.member.local.service.CulturalAndTourismTopicService;
import com.biz.crm.member.business.member.sdk.dto.BenefitsManagePaginationDto;
import com.biz.crm.member.business.member.sdk.dto.CulturalAndTourismTopicPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.BenefitsManageVo;
import com.biz.crm.member.business.member.sdk.vo.CulturalAndTourismTopicAPIVo;
import com.biz.crm.member.business.member.sdk.vo.CulturalAndTourismTopicVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author hupan
 * @date 2023/6/19 13:37
 */
@Slf4j
@Service("culturalAndTourismTopicServiceImpl")
public class CulturalAndTourismTopicServiceImpl implements CulturalAndTourismTopicService {

  @Autowired
  private CulturalAndTourismTopicRepository culturalAndTourismTopicRepository;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;
  @Autowired
  private GenerateCodeService generateCodeService;

  @Override
  public Page<CulturalAndTourismTopicVo> findByConditions(Pageable pageable,
      CulturalAndTourismTopicPaginationDto dto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    dto = Optional.ofNullable(dto).orElse(new CulturalAndTourismTopicPaginationDto());
    Page<CulturalAndTourismTopicVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return culturalAndTourismTopicRepository.findByConditions(page,dto);
  }

  @Override
  public CulturalAndTourismTopicVo create(CulturalAndTourismTopicVo culturalAndTourismTopicVo) {
    this.createValidation(culturalAndTourismTopicVo);
    CulturalAndTourismTopic culturalAndTourismTopic = this.nebulaToolkitService.copyObjectByWhiteList(culturalAndTourismTopicVo,CulturalAndTourismTopic.class,
        HashSet.class, LinkedList.class);
    culturalAndTourismTopic.setTenantCode(TenantUtils.getTenantCode());
    culturalAndTourismTopic.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    culturalAndTourismTopic.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    culturalAndTourismTopic.setCode(this.generateCodeService.generateCode("WL",5).get(0));
    culturalAndTourismTopicRepository.saveOrUpdate(culturalAndTourismTopic);
    return null;
  }

  @Override
  public CulturalAndTourismTopicVo findDetailById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    CulturalAndTourismTopic culturalAndTourismTopic = this.culturalAndTourismTopicRepository.getById(id);
    Validate.notNull(culturalAndTourismTopic,"题目未找到");
    CulturalAndTourismTopicVo culturalAndTourismTopicVo = this.nebulaToolkitService.copyObjectByWhiteList(culturalAndTourismTopic, CulturalAndTourismTopicVo.class, HashSet.class, LinkedList.class);
    return culturalAndTourismTopicVo;
  }

  @Override
  public CulturalAndTourismTopicVo update(CulturalAndTourismTopicVo culturalAndTourismTopicVo) {
    this.updateValidation(culturalAndTourismTopicVo);
    String currentId = culturalAndTourismTopicVo.getId();
    CulturalAndTourismTopic current = culturalAndTourismTopicRepository.getById(currentId);
    current = Validate.notNull(current,"修改信息不存在");
    current = this.nebulaToolkitService.copyObjectByWhiteList(culturalAndTourismTopicVo,CulturalAndTourismTopic.class,HashSet.class, LinkedList.class);
    this.culturalAndTourismTopicRepository.saveOrUpdate(current);
    return culturalAndTourismTopicVo;
  }

  @Override
  @Transactional
  public void enableBatch(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.culturalAndTourismTopicRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
  }

  @Override
  @Transactional
  public void disableBatch(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.culturalAndTourismTopicRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
  }

  @Override
  @Transactional
  public void updateDelFlagByIds(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.culturalAndTourismTopicRepository.updateDelFlagByIds(ids);
  }

  @Override
  public CulturalAndTourismTopicAPIVo questionTopic() {
    CulturalAndTourismTopic culturalAndTourismTopic = culturalAndTourismTopicRepository.selectRandOne();
    CulturalAndTourismTopicAPIVo culturalAndTourismTopicAPIVo = nebulaToolkitService
        .copyObjectByWhiteList(culturalAndTourismTopic, CulturalAndTourismTopicAPIVo.class,
            HashSet.class, LinkedList.class);
    return culturalAndTourismTopicAPIVo;
  }

  private void createValidation(CulturalAndTourismTopicVo culturalAndTourismTopicVo) {
    this.validation(culturalAndTourismTopicVo);
  }

  private void updateValidation(CulturalAndTourismTopicVo culturalAndTourismTopicVo) {
    this.validation(culturalAndTourismTopicVo);
  }

  private void validation(CulturalAndTourismTopicVo culturalAndTourismTopicVo) {
    Validate.notBlank(culturalAndTourismTopicVo.getTitle(), "题目标题不能为空");
    Validate.notBlank(culturalAndTourismTopicVo.getTitleOption(), "题目选项不能为空");
    Validate.notNull(culturalAndTourismTopicVo.getAnswer(),"题目答案不能为空");
  }
}
