package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.local.entity.DeliveryPermissionManage;
import com.biz.crm.member.business.member.local.mapper.DeliveryPermissionManageMapper;
import com.biz.crm.member.business.member.local.repository.DeliveryPermissionManageRepository;
import com.biz.crm.member.business.member.local.service.DeliveryPermissionManageService;
import com.biz.crm.member.business.member.sdk.dto.DeliveryPermissionManageDto;
import com.biz.crm.member.business.member.sdk.vo.DeliveryPermissionManageVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 *
 * @author hupan
 * @date 2023/6/14 11:37
 */
@Service("deliveryPermissionManageService")
public class DeliveryPermissionManageServiceImpl extends ServiceImpl<DeliveryPermissionManageMapper,DeliveryPermissionManage> implements DeliveryPermissionManageService {

  @Autowired
  private DeliveryPermissionManageMapper deliveryPermissionManageMapper;
  @Autowired
  private DeliveryPermissionManageService deliveryPermissionManageService;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;
  @Autowired
  private DeliveryPermissionManageRepository deliveryPermissionManageRepository;

  @Override
  public Page<DeliveryPermissionManageVo> findByConditions(Pageable pageable,DeliveryPermissionManageDto dto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    dto = Optional.ofNullable(dto).orElse(new DeliveryPermissionManageDto());
    Page<DeliveryPermissionManageVo> page = new Page<>(pageable.getPageNumber(),pageable.getPageSize());
    return deliveryPermissionManageRepository.findByConditions(page,dto);
  }

  @Override
  @Transactional
  public void addBatch(List<DeliveryPermissionManageDto> list) {
    List<DeliveryPermissionManage> listEntity = new ArrayList<>();
    for (DeliveryPermissionManageDto dto : list) {
      DeliveryPermissionManage deliveryPermissionManage = nebulaToolkitService
          .copyObjectByWhiteList(dto, DeliveryPermissionManage.class, HashSet.class,
              LinkedList.class);
      deliveryPermissionManage.setTenantCode(TenantUtils.getTenantCode());
      deliveryPermissionManage.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
      deliveryPermissionManage.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
      listEntity.add(deliveryPermissionManage);
    }
    deliveryPermissionManageService.saveBatch(listEntity);
  }

  @Override
  @Transactional
  public void enableBatch(List<String> ids) {
    deliveryPermissionManageRepository.enableBatch(ids);
  }

  @Override
  @Transactional
  public void disableBatch(List<String> ids) {
    deliveryPermissionManageRepository.disableBatch(ids);
  }
}
