package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.local.entity.BenefitsManageOrg;
import com.biz.crm.member.business.member.local.entity.DummyOrderUser;
import com.biz.crm.member.business.member.local.repository.DummyOrderUserRepository;
import com.biz.crm.member.business.member.local.service.DummyOrderUserService;
import com.biz.crm.member.business.member.sdk.dto.DummyOrderUserPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.BenefitsManageOrgVo;
import com.biz.crm.member.business.member.sdk.vo.DummyOrderApplyUserVo;
import com.biz.crm.member.business.member.sdk.vo.DummyOrderUserVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 虚拟订单用户信息(DummyOrderUser)表服务实现类
 *
 * @author zouhs
 * @date 2023-06-14 15:01:25
 */
@Slf4j
@Service("dummyOrderUserService")
public class DummyOrderUserServiceImpl implements DummyOrderUserService {
  
  @Autowired(required = false)
  private DummyOrderUserRepository dummyOrderUserRepository;

  @Autowired(required = false)
  private GenerateCodeService generateCodeService;

  @Autowired
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public Page<DummyOrderUserVo> findByConditions(Pageable pageable, DummyOrderUserPaginationDto dto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    dto = Optional.ofNullable(dto).orElse(new DummyOrderUserPaginationDto());
    Page<DummyOrderUserVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.dummyOrderUserRepository.findByConditions(page, dto);
  }

  @Override
  public DummyOrderUserVo findDetailById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    DummyOrderUser dummyOrderUser = this.dummyOrderUserRepository.findById(id);
    DummyOrderUserVo dummyOrderUserVo = this.nebulaToolkitService.copyObjectByWhiteList(dummyOrderUser, DummyOrderUserVo.class, HashSet.class, LinkedList.class);
    return dummyOrderUserVo;
  }
  
  @Override
  @Transactional
  public DummyOrderUserVo create(DummyOrderUserVo dummyOrderUserVo) {
    this.createValidation(dummyOrderUserVo);
    DummyOrderUser dummyOrderUser = this.nebulaToolkitService.copyObjectByWhiteList(dummyOrderUserVo, DummyOrderUser.class, HashSet.class, LinkedList.class);
    dummyOrderUser.setTenantCode(TenantUtils.getTenantCode());
    dummyOrderUser.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    dummyOrderUser.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    this.dummyOrderUserRepository.saveOrUpdate(dummyOrderUser);
    return dummyOrderUserVo;
  }

  @Override
  @Transactional
  public DummyOrderUserVo update(DummyOrderUserVo dummyOrderUserVo) {
    this.updateValidation(dummyOrderUserVo);
    String currentId = dummyOrderUserVo.getId();
    DummyOrderUser current = dummyOrderUserRepository.findById(currentId);
    current = Validate.notNull(current, "修改信息不存在");
    current = this.nebulaToolkitService.copyObjectByWhiteList(dummyOrderUserVo, DummyOrderUser.class, HashSet.class, LinkedList.class);
    this.dummyOrderUserRepository.saveOrUpdate(current);
    return dummyOrderUserVo;
  }

  @Override
  @Transactional
  public void enableBatch(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.dummyOrderUserRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
  }

  @Override
  @Transactional
  public void disableBatch(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.dummyOrderUserRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
  }
  
  @Override
  @Transactional
  public void updateDelFlagByIds(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.dummyOrderUserRepository.updateDelFlagByIds(ids);
  }

  @Override
  public List<DummyOrderUserVo> userInfoList(String orderCode) {
    List<DummyOrderUser> list = this.dummyOrderUserRepository.lambdaQuery()
        .eq(DummyOrderUser::getOrderCode, orderCode).list();
    return (List<DummyOrderUserVo>) this.nebulaToolkitService.copyCollectionByWhiteList(list, DummyOrderUser.class, DummyOrderUserVo.class, HashSet.class, ArrayList.class);
  }

  @Override
  public Page<DummyOrderApplyUserVo> findDummyOrderUserApplyByConditions(Pageable pageable,
      DummyOrderUserPaginationDto dto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    dto = Optional.ofNullable(dto).orElse(new DummyOrderUserPaginationDto());
    Page<DummyOrderApplyUserVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.dummyOrderUserRepository.findDummyOrderUserApplyByConditions(page, dto);
  }

  @Override
  public void batchSave(List<DummyOrderUserVo> list) {
    for (DummyOrderUserVo dummyOrderUserVo : list) {
      this.create(dummyOrderUserVo);
    }
  }

  private void createValidation(DummyOrderUserVo dummyOrderUserVo) {
    this.validation(dummyOrderUserVo);
  }

  private void updateValidation(DummyOrderUserVo dummyOrderUserVo) {
    this.validation(dummyOrderUserVo);
  }

  private void validation(DummyOrderUserVo dummyOrderUserVo) {
    Validate.notBlank(dummyOrderUserVo.getName(),"名字不能为空");
    Validate.notBlank(dummyOrderUserVo.getPhone(),"手机号不能为空");
    Validate.notBlank(dummyOrderUserVo.getOrderCode(),"订单号不能为空");
  }
}
