package com.biz.crm.member.business.member.local.service.internal;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.local.entity.HolidayIntegralRecord;
import com.biz.crm.member.business.member.local.helper.UserSearchHelper;
import com.biz.crm.member.business.member.local.repository.HolidayIntegralRecordRepository;
import com.biz.crm.member.business.member.local.repository.HolidayIntegralRepository;
import com.biz.crm.member.business.member.local.service.HolidayIntegralAction;
import com.biz.crm.member.business.member.sdk.enums.HolidayTypeEnum;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletHolidayIntegralVo;
import com.biz.crm.member.business.member.sdk.vo.login.MemberUserDetails;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * TODO
 *
 * @Description
 * @Author monroe
 * @Date 2023/7/5 15:49
 **/
@Service
public class HolidayIntegralActionImpl implements HolidayIntegralAction {

    @Autowired
    private HolidayIntegralRepository holidayIntegralRepository;
    @Autowired
    private HolidayIntegralRecordRepository holidayIntegralRecordRepository;
    @Autowired
    private UserSearchHelper userSearchHelper;

    @Override
    public BigDecimal getHolidayIntegralByDate(String memberCode, BigDecimal quantity, String type) {

        //查询当前日期是否是生日或者节日，并获取倍数
        String nowDate = DateUtil.formatDate(new Date());
        MemberUserDetails memberLogin = userSearchHelper.getMemberLogin();
        List<AppletHolidayIntegralVo> integralVos = this.holidayIntegralRepository.findByCurrentDate(memberCode, nowDate, type);
        if (CollUtil.isEmpty(integralVos)) {
            return null;
        }
        //获取当前会员获得的额外积分
        List<HolidayIntegralRecord> integralRecords = this.holidayIntegralRecordRepository.lambdaQuery().eq(HolidayIntegralRecord::getMemberCode, memberCode)
                .eq(HolidayIntegralRecord::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(HolidayIntegralRecord::getEnableStatus, EnableStatusEnum.ENABLE.getCode())
                .list();

        //根据节日编码分类
        Map<String, List<HolidayIntegralRecord>> recordMap = null;
        if (!CollUtil.isEmpty(integralRecords)) {
            recordMap = integralRecords.stream().collect(Collectors.groupingBy(HolidayIntegralRecord::getHolidayCode));
        }


        //获取当前日期内获取的积分
        for (AppletHolidayIntegralVo integralVo : integralVos) {
            //生日类型但不是本人生日
            if (HolidayTypeEnum.BIRTHDAY.getCode().equals(integralVo.getType())
                    && !nowDate.equals(memberLogin.getMemberBirthday())) {
                continue;
            }
            //个人节日积分上限
            Integer extraIntegralTop = integralVo.getExtraIntegralTop();
            BigDecimal multiple = integralVo.getMultiple();
            String holidayCode = integralVo.getHolidayCode();
            String channel = integralVo.getChannel();

            //倍数后积分
             BigDecimal multiply = quantity.multiply(multiple);

             //如果当前会员获得额外积分为空
            if(ObjectUtil.isNotNull(recordMap)) {
                return multiply;
            }
            List<HolidayIntegralRecord> records = recordMap.get(integralVo.getHolidayCode());
            //如果当前会员获得额外积分为空
            if(CollUtil.isEmpty(records)) {
                return multiply;
            }
            BigDecimal reduce = records.stream().map(HolidayIntegralRecord::getExtraIntegralNum).reduce(BigDecimal.ZERO, BigDecimal::add);
            //超过积分上限
            //额外积分
            BigDecimal subtract = multiply.subtract(quantity);
            if(reduce.add(subtract).compareTo(new BigDecimal(extraIntegralTop)) > 0) {
                continue;
            }

            //保存节日获得积分记录
            HolidayIntegralRecord record = new HolidayIntegralRecord();
            record.setHolidayCode(holidayCode);
            record.setIntegralNum(multiply);
            record.setExtraIntegralNum(subtract);
            record.setChannel(channel);
            record.setMemberPhone(memberLogin.getMemberPhone());
            record.setMemberCode(memberCode);
            this.holidayIntegralRecordRepository.saveOrUpdate(record);

            return multiply;

        }

        return null;
    }
}
