package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.local.entity.HolidayIntegralRecord;
import com.biz.crm.member.business.member.local.repository.HolidayIntegralRecordRepository;
import com.biz.crm.member.business.member.local.service.HolidayIntegralRecordService;
import com.biz.crm.member.business.member.sdk.dto.HolidayDto;
import com.biz.crm.member.business.member.sdk.dto.HolidayIntegralRecordDto;
import com.biz.crm.member.business.member.sdk.vo.HolidayIntegralRecordVo;
import com.biz.crm.member.business.member.sdk.vo.HolidayVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.Objects;
import java.util.Optional;

/**
 * TODO
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/28 12:25
 **/
@Service
public class HolidayIntegralRecordServiceImpl implements HolidayIntegralRecordService {

    @Autowired
    private HolidayIntegralRecordRepository holidayIntegralRecordRepository;

    @Override
    public Page<HolidayIntegralRecordVo> findByConditions(Pageable pageable, HolidayIntegralRecordDto holidayIntegralRecordDto) {
        if (Objects.isNull(holidayIntegralRecordDto)) {
            holidayIntegralRecordDto = new HolidayIntegralRecordDto();
        }
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
        Page<HolidayIntegralRecordVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.holidayIntegralRecordRepository.findByConditions(page, holidayIntegralRecordDto);
    }

    @Override
    public HolidayIntegralRecord create(HolidayIntegralRecord record) {
        return null;
    }
}
