package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.local.entity.Label;
import com.biz.crm.member.business.member.local.entity.LabelCategory;
import com.biz.crm.member.business.member.local.entity.LevelManageBenefits;
import com.biz.crm.member.business.member.local.mapper.LabelCategoryMapper;
import com.biz.crm.member.business.member.local.repository.LabelCategoryRepository;
import com.biz.crm.member.business.member.local.repository.LabelRepository;
import com.biz.crm.member.business.member.local.service.LabelCategoryService;
import com.biz.crm.member.business.member.sdk.dto.LabelCategoryDto;
import com.biz.crm.member.business.member.sdk.enums.LabelManageEnum;
import com.biz.crm.member.business.member.sdk.vo.LabelCategoryVo;
import com.biz.crm.member.business.member.sdk.vo.LabelVo;
import com.biz.crm.member.business.member.sdk.vo.LevelManageBenefitsVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service("labelCategoryService")
public class LabelCategoryServiceImpl implements LabelCategoryService {

  @Autowired
  private LabelCategoryMapper labelCategoryMapper;

  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Autowired
  private LabelCategoryRepository labelCategoryRepository;

  @Autowired(required = false)
  private GenerateCodeService generateCodeService;

  @Autowired
  private LabelRepository labelRepository;

  @Override
  public Page<LabelCategoryVo> findByConditions(Pageable pageable,
      LabelCategoryVo labelCategoryVo) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    labelCategoryVo = Optional.ofNullable(labelCategoryVo).orElse(new LabelCategoryVo());
    Page<LabelCategoryVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return labelCategoryRepository.findByConditions(page, labelCategoryVo);
  }

  @Override
  @Transactional
  public void create(LabelCategoryVo labelCategoryVo) {
    LabelCategory labelCategory = nebulaToolkitService
        .copyObjectByWhiteList(labelCategoryVo, LabelCategory.class, HashSet.class,
            LinkedList.class);
    labelCategory.setCode(this.generateCodeService.generateCode("LC", 5).get(0));
    labelCategory.setTenantCode(TenantUtils.getTenantCode());
    labelCategory.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    labelCategory.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    if (labelCategory.getSort()<1){
      labelCategory.setSort(1);
      Validate.notNull(null,"排序字段不能小于1");
    }
    labelCategoryMapper.insert(labelCategory);
  }

  @Override
  @Transactional
  public void update(LabelCategoryVo labelCategoryVo) {
    LabelCategory labelCategory = nebulaToolkitService
        .copyObjectByWhiteList(labelCategoryVo, LabelCategory.class, HashSet.class,
            LinkedList.class);
    if (labelCategory.getSort()<1){
      labelCategory.setSort(1);
      Validate.notNull(null,"排序字段不能小于1");
    }
    labelCategoryMapper.updateById(labelCategory);
  }

  @Override
  @Transactional
  public void enableBatch(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.labelCategoryRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
  }

  @Override
  @Transactional
  public void disableBatch(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.labelCategoryRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
  }

  @Override
  @Transactional
  public void updateDelFlagByIds(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.labelCategoryRepository.updateDelFlagByIds(ids);
  }

  @Override
  public List<LabelCategoryVo> findByConditions() {
    List<LabelCategoryVo> listVo = new ArrayList<>();
    List<LabelCategory> list = this.labelCategoryRepository.findByConditions();
    for (LabelCategory labelCategory : list) {
      LabelCategoryVo labelCategoryVo = new LabelCategoryVo();
      labelCategoryVo.setName(labelCategory.getName());
      labelCategoryVo.setTenantCode(labelCategory.getTenantCode());
      listVo.add(labelCategoryVo);
    }
    return listVo;
  }

  @Override
  public void updateSort(String id, Integer sort) {
    LabelCategory labelCategory = labelCategoryMapper.selectById(id);
    if (sort + labelCategory.getSort()<1){
      labelCategoryRepository.updateSort(id, 1);
    }else {
      labelCategoryRepository.updateSort(id, sort + labelCategory.getSort());
    }
  }

  @Override
  public List<LabelCategoryVo> labelCategoryAll() {
    List<LabelCategory> list = this.labelCategoryRepository.lambdaQuery()
        .eq(UuidFlagOpEntity::getEnableStatus,EnableStatusEnum.ENABLE.getCode())
        .eq(UuidFlagOpEntity::getDelFlag,DelFlagStatusEnum.NORMAL.getCode())
        .orderByAsc(LabelCategory::getSort).list();
    return (List<LabelCategoryVo>) this.nebulaToolkitService
        .copyCollectionByWhiteList(list, LabelCategory.class, LabelCategoryVo.class, HashSet.class,
            ArrayList.class);
  }

  @Override
  public List<LabelCategoryVo> labelAll(LabelCategoryVo vo) {
    List<LabelCategory> list = this.labelCategoryRepository.lambdaQuery()
        .eq(StringUtils.isNotBlank(vo.getCode()), LabelCategory::getCode, vo.getCode())
        .eq(UuidFlagOpEntity::getEnableStatus,EnableStatusEnum.ENABLE.getCode())
        .eq(UuidFlagOpEntity::getDelFlag,DelFlagStatusEnum.NORMAL.getCode())
        .orderByAsc(LabelCategory::getSort).list();
    if (CollectionUtils.isEmpty(list)) {
      return Lists.newArrayList();
    }
    List<LabelCategoryVo> labelCategoryVos = (List<LabelCategoryVo>) this.nebulaToolkitService
        .copyCollectionByWhiteList(list, LabelCategory.class, LabelCategoryVo.class, HashSet.class,
            ArrayList.class);
    if (CollectionUtils.isNotEmpty(labelCategoryVos)) {
      for (LabelCategoryVo labelCategoryVo : labelCategoryVos) {
        List<Label> labelList = this.labelRepository.lambdaQuery()
            .eq(UuidFlagOpEntity::getEnableStatus,EnableStatusEnum.ENABLE.getCode())
            .eq(UuidFlagOpEntity::getDelFlag,DelFlagStatusEnum.NORMAL.getCode())
            .eq(Label::getType, LabelManageEnum.AUTOMATIC_LABEL.getValue())
            .eq(Label::getCategoryCode, labelCategoryVo.getCode()).list();
        if (CollectionUtils.isNotEmpty(labelList)) {
          List<LabelVo> labelVos = Lists.newArrayList();
          LabelVo labelVo;
          for (Label label : labelList) {
            labelVo = new LabelVo();
            labelVo.setCode(label.getCode());
            labelVo.setName(label.getName());
            labelVo.setType(label.getType());
            labelVos.add(labelVo);
          }
          labelCategoryVo.setList(labelVos);
        } else {
          labelCategoryVo.setList(Lists.newArrayList());
        }
      }
    }
    return labelCategoryVos;
  }
}
