package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.local.entity.LevelManageBenefits;
import com.biz.crm.member.business.member.local.entity.LevelManageBenefitsDetail;
import com.biz.crm.member.business.member.local.repository.LevelManageBenefitsDetailRepository;
import com.biz.crm.member.business.member.local.service.LevelManageBenefitsDetailService;
import com.biz.crm.member.business.member.sdk.dto.LevelManageBenefitsDetailPaginationDto;
import com.biz.crm.member.business.member.sdk.event.LevelManageBenefitsDetailEventListener;
import com.biz.crm.member.business.member.sdk.vo.LevelManageBenefitsDetailVo;
import com.biz.crm.member.business.member.sdk.vo.LevelManageBenefitsVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 等级管理-权益配置明细(LevelManageBenefitsDetail)表服务实现类
 *
 * @author zouhs
 * @date 2023-06-13 09:52:24
 */
@Slf4j
@Service("levelManageBenefitsDetailService")
public class LevelManageBenefitsDetailServiceImpl implements LevelManageBenefitsDetailService {

  @Autowired(required = false)
  private LevelManageBenefitsDetailRepository levelManageBenefitsDetailRepository;

  @Autowired(required = false)
  private List<LevelManageBenefitsDetailEventListener> eventListeners;

  @Autowired(required = false)
  private GenerateCodeService generateCodeService;

  @Autowired
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public Page<LevelManageBenefitsDetailVo> findByConditions(Pageable pageable,
      LevelManageBenefitsDetailPaginationDto dto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    dto = Optional.ofNullable(dto).orElse(new LevelManageBenefitsDetailPaginationDto());
    Page<LevelManageBenefitsDetailVo> page = new Page<>(pageable.getPageNumber(),
        pageable.getPageSize());
    return this.levelManageBenefitsDetailRepository.findByConditions(page, dto);
  }

  @Override
  public LevelManageBenefitsDetailVo findDetailById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    LevelManageBenefitsDetail levelManageBenefitsDetail = this.levelManageBenefitsDetailRepository
        .findById(id);
    LevelManageBenefitsDetailVo levelManageBenefitsDetailVo = this.nebulaToolkitService
        .copyObjectByWhiteList(levelManageBenefitsDetail, LevelManageBenefitsDetailVo.class,
            HashSet.class, LinkedList.class);
    return levelManageBenefitsDetailVo;
  }

  @Override
  @Transactional
  public LevelManageBenefitsDetailVo create(
      LevelManageBenefitsDetailVo levelManageBenefitsDetailVo) {
    this.createValidation(levelManageBenefitsDetailVo);
    LevelManageBenefitsDetail levelManageBenefitsDetail = this.nebulaToolkitService
        .copyObjectByWhiteList(levelManageBenefitsDetailVo, LevelManageBenefitsDetail.class,
            HashSet.class, LinkedList.class);
    levelManageBenefitsDetail.setTenantCode(TenantUtils.getTenantCode());
    levelManageBenefitsDetail.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    levelManageBenefitsDetail.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    this.levelManageBenefitsDetailRepository.saveOrUpdate(levelManageBenefitsDetail);
    return levelManageBenefitsDetailVo;
  }

  @Override
  @Transactional
  public LevelManageBenefitsDetailVo update(
      LevelManageBenefitsDetailVo levelManageBenefitsDetailVo) {
    this.updateValidation(levelManageBenefitsDetailVo);
    String currentId = levelManageBenefitsDetailVo.getId();
    LevelManageBenefitsDetail current = levelManageBenefitsDetailRepository.findById(currentId);
    current = Validate.notNull(current, "修改信息不存在");
    current = this.nebulaToolkitService
        .copyObjectByWhiteList(levelManageBenefitsDetailVo, LevelManageBenefitsDetail.class,
            HashSet.class, LinkedList.class);
    this.levelManageBenefitsDetailRepository.saveOrUpdate(current);
    return levelManageBenefitsDetailVo;
  }

  @Override
  @Transactional
  public void enableBatch(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.levelManageBenefitsDetailRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
  }

  @Override
  @Transactional
  public void disableBatch(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.levelManageBenefitsDetailRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
  }

  @Override
  @Transactional
  public void updateDelFlagByIds(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.levelManageBenefitsDetailRepository.updateDelFlagByIds(ids);
  }

  @Override
  @Transactional
  public void saveBatch(List<LevelManageBenefitsDetailVo> levelManageBenefitsDetailVos) {
    List<LevelManageBenefitsDetail> saveList = Lists.newArrayList();
    for (LevelManageBenefitsDetailVo levelManageBenefitsDetailVo : levelManageBenefitsDetailVos) {
      this.validation(levelManageBenefitsDetailVo);
      LevelManageBenefitsDetail levelManageBenefitsDetail = this.nebulaToolkitService
          .copyObjectByWhiteList(levelManageBenefitsDetailVo, LevelManageBenefitsDetail.class,
              HashSet.class, LinkedList.class);
      levelManageBenefitsDetail.setTenantCode(TenantUtils.getTenantCode());
      levelManageBenefitsDetail.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
      levelManageBenefitsDetail.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
      saveList.add(levelManageBenefitsDetail);
    }
    this.levelManageBenefitsDetailRepository.saveBatch(saveList);
  }

  @Override
  public List<LevelManageBenefitsDetailVo> findListDetailById(String levelCode,String code) {
    List<LevelManageBenefitsDetail> list = this.levelManageBenefitsDetailRepository.lambdaQuery()
        .eq(LevelManageBenefitsDetail::getLevelCode,levelCode)
        .eq(LevelManageBenefitsDetail::getLevelManageBenefitsCode, code).orderByAsc(LevelManageBenefitsDetail::getSeq).list();
    if(CollectionUtils.isEmpty(list)){
      return Lists.newArrayList();
    }
    return (List<LevelManageBenefitsDetailVo>)this.nebulaToolkitService.copyCollectionByWhiteList(list, LevelManageBenefitsDetail.class, LevelManageBenefitsDetailVo.class, HashSet.class, ArrayList.class);
  }

  @Override
  public void del(Set<String> ids) {
    this.levelManageBenefitsDetailRepository.removeByIds(ids);
  }

  @Override
  public List<LevelManageBenefitsDetailVo> findListDetailByLevelCodeAndCode(Set<String> bLevelCodes,
      List<String> codes) {
    List<LevelManageBenefitsDetail> list = this.levelManageBenefitsDetailRepository.lambdaQuery()
        .in(LevelManageBenefitsDetail::getLevelCode, bLevelCodes)
        .in(LevelManageBenefitsDetail::getLevelManageBenefitsCode, codes)
        .list();
    if(CollectionUtils.isEmpty(list)){
      return Lists.newArrayList();
    }
    return (List<LevelManageBenefitsDetailVo>)this.nebulaToolkitService.copyCollectionByWhiteList(list, LevelManageBenefitsDetail.class, LevelManageBenefitsDetailVo.class, HashSet.class, ArrayList.class);
  }

  private void createValidation(LevelManageBenefitsDetailVo levelManageBenefitsDetailVo) {
    this.validation(levelManageBenefitsDetailVo);
  }

  private void updateValidation(LevelManageBenefitsDetailVo levelManageBenefitsDetailVo) {
    this.validation(levelManageBenefitsDetailVo);
  }

  private void validation(LevelManageBenefitsDetailVo levelManageBenefitsDetailVo) {
    Validate.notBlank(levelManageBenefitsDetailVo.getLevelManageBenefitsCode(), "关联权益列表不能为空");
    Validate.notBlank(levelManageBenefitsDetailVo.getCode(), "权益编码不能为空");
    Validate.notBlank(levelManageBenefitsDetailVo.getName(), "权益名称不能为空");
    Validate.notBlank(levelManageBenefitsDetailVo.getType(), "权益类型不能为空");
    Validate.notNull(levelManageBenefitsDetailVo.getSeq(), "序列不能为空");
    Validate.notNull(levelManageBenefitsDetailVo.getNum(), "数量不能为空");
  }
}
