package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.local.entity.BenefitsManageOrg;
import com.biz.crm.member.business.member.sdk.vo.BenefitsManageOrgVo;
import com.biz.crm.member.business.member.sdk.vo.LevelManageBenefitsVo;
import com.biz.crm.member.business.member.local.entity.LevelManageBenefits;
import com.biz.crm.member.business.member.local.repository.LevelManageBenefitsRepository;
import com.biz.crm.member.business.member.local.service.LevelManageBenefitsService;
import com.biz.crm.member.business.member.sdk.dto.LevelManageBenefitsPaginationDto;
import com.biz.crm.member.business.member.sdk.event.LevelManageBenefitsEventListener;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 等级管理-权益配置(LevelManageBenefits)表服务实现类
 *
 * @author zouhs
 * @date 2023-06-13 09:52:00
 */
@Slf4j
@Service("levelManageBenefitsService")
public class LevelManageBenefitsServiceImpl implements LevelManageBenefitsService {
  
  @Autowired(required = false)
  private LevelManageBenefitsRepository levelManageBenefitsRepository;

  @Autowired(required = false)
  private List<LevelManageBenefitsEventListener> eventListeners;

  @Autowired(required = false)
  private GenerateCodeService generateCodeService;

  @Autowired
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public Page<LevelManageBenefitsVo> findByConditions(Pageable pageable, LevelManageBenefitsPaginationDto dto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    dto = Optional.ofNullable(dto).orElse(new LevelManageBenefitsPaginationDto());
    Page<LevelManageBenefitsVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.levelManageBenefitsRepository.findByConditions(page, dto);
  }

  @Override
  public LevelManageBenefitsVo findDetailById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    LevelManageBenefits levelManageBenefits = this.levelManageBenefitsRepository.findById(id);
    LevelManageBenefitsVo levelManageBenefitsVo = this.nebulaToolkitService.copyObjectByWhiteList(levelManageBenefits, LevelManageBenefitsVo.class, HashSet.class, LinkedList.class);
    return levelManageBenefitsVo;
  }
  
  @Override
  @Transactional
  public LevelManageBenefitsVo create(LevelManageBenefitsVo levelManageBenefitsVo) {
    this.createValidation(levelManageBenefitsVo);
    LevelManageBenefits levelManageBenefits = this.nebulaToolkitService.copyObjectByWhiteList(levelManageBenefitsVo, LevelManageBenefits.class, HashSet.class, LinkedList.class);
    levelManageBenefits.setTenantCode(TenantUtils.getTenantCode());
    levelManageBenefits.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    levelManageBenefits.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    this.levelManageBenefitsRepository.saveOrUpdate(levelManageBenefits);
    return levelManageBenefitsVo;
  }

  @Override
  @Transactional
  public LevelManageBenefitsVo update(LevelManageBenefitsVo levelManageBenefitsVo) {
//    this.updateValidation(levelManageBenefitsVo);
//    String currentId = levelManageBenefitsVo.getId();
//    LevelManageBenefits current = levelManageBenefitsRepository.findById(currentId);
//    current = Validate.notNull(current, "修改信息不存在");
//    current = this.nebulaToolkitService.copyObjectByWhiteList(levelManageBenefitsVo, LevelManageBenefits.class, HashSet.class, LinkedList.class);
//    this.levelManageBenefitsRepository.saveOrUpdate(current);
    return levelManageBenefitsVo;
  }

  @Override
  @Transactional
  public void enableBatch(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.levelManageBenefitsRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
  }

  @Override
  @Transactional
  public void disableBatch(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.levelManageBenefitsRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
  }
  
  @Override
  @Transactional
  public void updateDelFlagByIds(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.levelManageBenefitsRepository.updateDelFlagByIds(ids);
  }

  @Override
  public List<LevelManageBenefitsVo> findListDetailById(String levelCode) {
    List<LevelManageBenefits> list = this.levelManageBenefitsRepository.lambdaQuery()
        .eq(LevelManageBenefits::getLevelCode, levelCode).orderByAsc(LevelManageBenefits::getSeq).list();
    if(CollectionUtils.isEmpty(list)){
      return Lists.newArrayList();
    }
    return (List<LevelManageBenefitsVo>)this.nebulaToolkitService.copyCollectionByWhiteList(list, LevelManageBenefits.class, LevelManageBenefitsVo.class, HashSet.class, ArrayList.class);
  }

  private void createValidation(LevelManageBenefitsVo levelManageBenefitsVo) {
    this.validation(levelManageBenefitsVo);
  }

  private void updateValidation(LevelManageBenefitsVo levelManageBenefitsVo) {
    this.validation(levelManageBenefitsVo);
  }

  private void validation(LevelManageBenefitsVo levelManageBenefitsVo) {
    Validate.notBlank(levelManageBenefitsVo.getLevelCode(),"关联等级编码不能为空");
    Validate.notBlank(levelManageBenefitsVo.getCode(),"权益编码不能为空");
    Validate.notNull(levelManageBenefitsVo.getSeq(),"序号不能为空");
    if(levelManageBenefitsVo.getSeq().intValue() == 1){
      Validate.notNull(levelManageBenefitsVo.getYearNum(),"连续x年该等级会员以上不能为空");
    }else{
      Validate.notBlank(levelManageBenefitsVo.getName(),"权益名称不能为空");
    }
//    Validate.isTrue(CollectionUtils.isNotEmpty(levelManageBenefitsVo.getList()),"等级权益列表明细不能为空");
  }
}
