package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.vo.UuidVo;
import com.biz.crm.member.business.member.local.entity.LevelManageBenefits;
import com.biz.crm.member.business.member.local.entity.LevelManageBenefitsDetail;
import com.biz.crm.member.business.member.local.service.BenefitsManageService;
import com.biz.crm.member.business.member.local.service.LevelManageBenefitsDetailService;
import com.biz.crm.member.business.member.local.service.LevelManageBenefitsService;
import com.biz.crm.member.business.member.local.service.SystemSettingsDetailService;
import com.biz.crm.member.business.member.local.service.SystemSettingsService;
import com.biz.crm.member.business.member.sdk.enums.CpsYesOrNoEnum;
import com.biz.crm.member.business.member.sdk.vo.BenefitsManageVo;
import com.biz.crm.member.business.member.sdk.vo.LevelManageBenefitsDetailVo;
import com.biz.crm.member.business.member.sdk.vo.LevelManageBenefitsVo;
import com.biz.crm.member.business.member.sdk.vo.LevelManageVo;
import com.biz.crm.member.business.member.local.entity.LevelManage;
import com.biz.crm.member.business.member.local.repository.LevelManageRepository;
import com.biz.crm.member.business.member.local.service.LevelManageService;
import com.biz.crm.member.business.member.sdk.dto.LevelManagePaginationDto;
import com.biz.crm.member.business.member.sdk.event.LevelManageEventListener;
import com.biz.crm.member.business.member.sdk.vo.SystemSettingsReservedVo;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletLevelBenefitsDetailsVo;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletLevelBenefitsVo;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletLevelManageVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hibernate.type.YesNoType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 等级管理(LevelManage)表服务实现类
 *
 * @author zouhs
 * @date 2023-06-13 09:51:36
 */
@Slf4j
@Service("levelManageService")
public class LevelManageServiceImpl implements LevelManageService {

  @Autowired(required = false)
  private LevelManageRepository levelManageRepository;

  @Autowired(required = false)
  private List<LevelManageEventListener> eventListeners;

  @Autowired(required = false)
  private GenerateCodeService generateCodeService;

  @Autowired
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Autowired
  private LevelManageBenefitsService levelManageBenefitsService;

  @Autowired
  private LevelManageBenefitsDetailService levelManageBenefitsDetailService;

  @Autowired
  private SystemSettingsService systemSettingsService;

  @Autowired
  private BenefitsManageService benefitsManageService;

  @Override
  public Page<LevelManageVo> findByConditions(Pageable pageable, LevelManagePaginationDto dto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    dto = Optional.ofNullable(dto).orElse(new LevelManagePaginationDto());
    Page<LevelManageVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.levelManageRepository.findByConditions(page, dto);
  }

  @Override
  public LevelManageVo findDetailById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    LevelManage levelManage = this.levelManageRepository.findById(id);
    levelManage = Optional.ofNullable(levelManage).orElse(new LevelManage());
    LevelManageVo levelManageVo = this.nebulaToolkitService
        .copyObjectByWhiteList(levelManage, LevelManageVo.class, HashSet.class, LinkedList.class);
    List<LevelManageBenefitsVo> levelManageBenefitsVoList = this.levelManageBenefitsService
        .findListDetailById(levelManage.getLevelCode());
    if (CollectionUtils.isNotEmpty(levelManageBenefitsVoList)) {
      for (LevelManageBenefitsVo levelManageBenefitsVo : levelManageBenefitsVoList) {
        List<LevelManageBenefitsDetailVo> levelManageBenefitsDetailVoList = this.levelManageBenefitsDetailService
            .findListDetailById(levelManageVo.getLevelCode(), levelManageBenefitsVo.getCode());
        levelManageBenefitsVo.setList(levelManageBenefitsDetailVoList);
      }
    }
    levelManageVo.setList(levelManageBenefitsVoList);
    return levelManageVo;
  }

  @Override
  public LevelManageVo findDetailByLevelCode(String levelCode) {
    if (StringUtils.isBlank(levelCode)) {
      return null;
    }
    LevelManage levelManage = levelManageRepository.lambdaQuery()
        .eq(LevelManage::getLevelCode, levelCode)
        .one();
    LevelManageVo levelManageVo = this.nebulaToolkitService
        .copyObjectByWhiteList(levelManage, LevelManageVo.class, HashSet.class, LinkedList.class);
    return levelManageVo;
  }

  @Override
  @Transactional
  public LevelManageVo create(LevelManageVo levelManageVo) {
    this.createValidation(levelManageVo);
    LevelManage levelManage = this.nebulaToolkitService
        .copyObjectByWhiteList(levelManageVo, LevelManage.class, HashSet.class, LinkedList.class);
    levelManage.setTenantCode(TenantUtils.getTenantCode());
    levelManage.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    levelManage.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    levelManage.setLevelCode(this.generateCodeService.generateCode("VIP", 5).get(0));
    this.levelManageRepository.saveOrUpdate(levelManage);
    int benefitsCount = 1;
    // 处理权益列表
    for (LevelManageBenefitsVo levelManageBenefitsVo : levelManageVo.getList()) {
      levelManageBenefitsVo.setLevelCode(levelManage.getLevelCode());
      levelManageBenefitsVo.setSeq(benefitsCount++);
      levelManageBenefitsVo.setFlagFixed(
          benefitsCount < 3 ? CpsYesOrNoEnum.YES.getValue() : CpsYesOrNoEnum.NO.getValue());
      this.levelManageBenefitsService.create(levelManageBenefitsVo);
      if (CollectionUtils.isNotEmpty(levelManageBenefitsVo.getList())) {
        List<LevelManageBenefitsDetailVo> levelManageBenefitsDetailVos = Lists.newArrayList();
        // 处理真实权益明细
        int benefitsDetailCount = 1;
        for (LevelManageBenefitsDetailVo levelManageBenefitsDetailVo : levelManageBenefitsVo
            .getList()) {
          levelManageBenefitsDetailVo.setLevelCode(levelManage.getLevelCode());
          levelManageBenefitsDetailVo.setLevelManageBenefitsCode(levelManageBenefitsVo.getCode());
          levelManageBenefitsDetailVo.setSeq(benefitsDetailCount++);
          levelManageBenefitsDetailVos.add(levelManageBenefitsDetailVo);
        }
        levelManageBenefitsDetailService.saveBatch(levelManageBenefitsDetailVos);
      }
    }
    return levelManageVo;
  }

  @Override
  @Transactional
  public LevelManageVo update(LevelManageVo levelManageVo) {
    String currentId = levelManageVo.getId();
    LevelManage current = levelManageRepository.findById(currentId);
    current = Validate.notNull(current, "修改信息不存在");
    levelManageVo.setLevelCode(current.getLevelCode());
    this.updateValidation(levelManageVo);
    current = this.nebulaToolkitService
        .copyObjectByWhiteList(levelManageVo, LevelManage.class, HashSet.class, LinkedList.class);
    this.levelManageRepository.saveOrUpdate(current);
    // 处理权益列表
    for (LevelManageBenefitsVo levelManageBenefitsVo : levelManageVo.getList()) {
      if (CollectionUtils.isNotEmpty(levelManageBenefitsVo.getList())) {
        // 删除历史的
        List<LevelManageBenefitsDetailVo> oldList = levelManageBenefitsDetailService
            .findListDetailById(current.getLevelCode(), levelManageBenefitsVo.getCode());
        if (CollectionUtils.isNotEmpty(oldList)) {
          levelManageBenefitsDetailService
              .del(oldList.stream().map(UuidVo::getId).collect(Collectors.toSet()));
        }
        List<LevelManageBenefitsDetailVo> levelManageBenefitsDetailVos = Lists.newArrayList();
        // 处理真实权益明细
        int benefitsDetailCount = 1;
        for (LevelManageBenefitsDetailVo levelManageBenefitsDetailVo : levelManageBenefitsVo
            .getList()) {
          levelManageBenefitsDetailVo.setId(null);
          levelManageBenefitsDetailVo.setLevelCode(current.getLevelCode());
          levelManageBenefitsDetailVo.setLevelManageBenefitsCode(levelManageBenefitsVo.getCode());
          levelManageBenefitsDetailVo.setSeq(benefitsDetailCount++);
          levelManageBenefitsDetailVos.add(levelManageBenefitsDetailVo);
        }
        levelManageBenefitsDetailService.saveBatch(levelManageBenefitsDetailVos);
      }
    }
    return levelManageVo;
  }

  @Override
  @Transactional
  public void enableBatch(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    List<LevelManage> list1 = this.levelManageRepository.lambdaQuery().in(UuidEntity::getId, ids)
        .list();
    if (CollectionUtils.isNotEmpty(list1)) {
      LevelManageVo levelManageVo;
      for (LevelManage levelManage : list1) {
        levelManageVo = new LevelManageVo();
        levelManageVo.setGrowStart(levelManage.getGrowStart());
        levelManageVo.setGrowEnd(levelManage.getGrowEnd());
        // 验证成长值区间不能重复
        List<LevelManage> list = this.levelManageRepository.checkGrow(levelManageVo);
        Validate.isTrue(CollectionUtils.isEmpty(list), "成长值区间重叠,请检查");
      }
    }
    this.levelManageRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
  }

  @Override
  @Transactional
  public void disableBatch(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.levelManageRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
  }

  @Override
  @Transactional
  public void updateDelFlagByIds(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.levelManageRepository.updateDelFlagByIds(ids);
  }

  @Override
  public List<LevelManageVo> allList() {
    List<LevelManage> list = this.levelManageRepository.lambdaQuery()
        .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .eq(UuidFlagOpEntity::getEnableStatus, EnableStatusEnum.ENABLE.getCode())
        .orderByAsc(LevelManage::getLevelNum)
        .list();
    if (CollectionUtils.isEmpty(list)) {
      return Lists.newArrayList();
    }
    List<LevelManageVo> levelManageVoList = Lists.newArrayList();
    LevelManageVo levelManageVo;
    for (LevelManage levelManage : list) {
      levelManageVo = new LevelManageVo();
      levelManageVo.setLevelCode(levelManage.getLevelCode());
      levelManageVo.setLevelName(levelManage.getLevelName());
      levelManageVo.setLevelNum(levelManage.getLevelNum());
      levelManageVoList.add(levelManageVo);
    }
    return levelManageVoList;
  }

  @Override
  public LevelManageVo nextLevelManage(LevelManageVo levelManageVo) {
    List<LevelManage> list = this.levelManageRepository.lambdaQuery()
        .eq(LevelManage::getLevelNum, levelManageVo.getLevelNum() + 1)
        .eq(UuidFlagOpEntity::getEnableStatus, EnableStatusEnum.ENABLE.getCode())
        .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .orderByDesc(UuidOpEntity::getCreateTime)
        .list();
    if (CollectionUtils.isNotEmpty(list)) {
      return this.nebulaToolkitService
          .copyObjectByWhiteList(list.get(0), LevelManageVo.class, HashSet.class, LinkedList.class);
    }
    return null;
  }

  @Override
  public List<AppletLevelManageVo> getMemberLevelAll(String memberCode) {
    List<LevelManage> list = this.levelManageRepository.lambdaQuery()
        .eq(UuidFlagOpEntity::getEnableStatus, EnableStatusEnum.ENABLE.getCode())
        .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .orderByAsc(LevelManage::getLevelNum)
        .list();
    if (CollectionUtils.isNotEmpty(list)) {
      List<AppletLevelManageVo> appletLevelManageVos = (List<AppletLevelManageVo>) this.nebulaToolkitService
          .copyCollectionByWhiteList(list, LevelManage.class, AppletLevelManageVo.class,
              HashSet.class, ArrayList.class);

      return appletLevelManageVos;
    }
    return Lists.newArrayList();
  }

  @Override
  public List<AppletLevelManageVo> getAllChildrenIncludeMe(String memberLevelCode) {
    if (StringUtils.isEmpty(memberLevelCode)) return Lists.newArrayList();
    Integer levelNum = this.levelManageRepository.lambdaQuery().eq(LevelManage::getLevelCode, memberLevelCode).one().getLevelNum();
    List<LevelManage> manageList = this.levelManageRepository.lambdaQuery()
            .eq(UuidFlagOpEntity::getEnableStatus, EnableStatusEnum.ENABLE.getCode())
            .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
            .le(LevelManage::getLevelNum, levelNum)
            .orderByAsc(LevelManage::getLevelNum)
            .list();
    if (CollectionUtils.isNotEmpty(manageList)) {
      List<AppletLevelManageVo> allChildrenIncludeMe = (List<AppletLevelManageVo>) this.nebulaToolkitService
              .copyCollectionByWhiteList(manageList, LevelManage.class, AppletLevelManageVo.class,
                      HashSet.class, ArrayList.class);
      return allChildrenIncludeMe;
    }
    return Lists.newArrayList();
  }

  @Override
  public List<AppletLevelBenefitsVo> getMemberBenefitsList(String levelCode, String memberCode) {
    Validate.notBlank(levelCode, "请选择等级卡片编码");
    LevelManage levelManage = this.levelManageRepository.lambdaQuery()
        .eq(LevelManage::getLevelCode, levelCode).one();
    Validate.notNull(levelManage, "等级异常");
    // 查询当前等级之前的所有权益
    List<LevelManage> list = this.levelManageRepository.lambdaQuery()
        .le(LevelManage::getLevelNum, levelManage.getLevelNum())
        .eq(UuidFlagOpEntity::getEnableStatus, EnableStatusEnum.ENABLE.getCode())
        .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .list();
    if(CollectionUtils.isEmpty(list)){
      return Lists.newArrayList();
    }
    Set<String> bLevelCodes = Sets.newHashSet();
    bLevelCodes.add(levelCode);
    // 生日礼遇只查当前等级的
    List<LevelManageBenefitsDetailVo> blist = this.levelManageBenefitsDetailService
        .findListDetailByLevelCodeAndCode(bLevelCodes, Arrays.asList("B"));
    // 其他 - 查询所有会员等级重叠的
    Set<String> levelCodeSets = list.stream().map(LevelManage::getLevelCode)
        .collect(Collectors.toSet());
    List<LevelManageBenefitsDetailVo> olist = this.levelManageBenefitsDetailService
        .findListDetailByLevelCodeAndCode(levelCodeSets,
            Arrays.asList("C", "D"));
    // 其他分组
    Map<String, List<LevelManageBenefitsDetailVo>> otherLevelManageBenefitsDetailVoMap = olist.stream()
        .collect(Collectors.groupingBy(LevelManageBenefitsDetailVo::getLevelManageBenefitsCode));

    Set<String> benefitsCodes = Sets.newHashSet();
    // 所有权益查询
    if(CollectionUtils.isNotEmpty(blist)){
      benefitsCodes.add(blist.get(0).getCode());
    }
    if(CollectionUtils.isNotEmpty(olist)){
      Set<String> codes = olist.stream().map(LevelManageBenefitsDetailVo::getCode)
          .collect(Collectors.toSet());
      benefitsCodes.addAll(codes);
    }
    // 权益数据
    List<BenefitsManageVo> benefitsManageVoList = benefitsManageService.findDetailByCodes(benefitsCodes);
    Map<String, BenefitsManageVo> benefitsManageVoMap = benefitsManageVoList.stream()
        .collect(Collectors.toMap(BenefitsManageVo::getCode, Function.identity()));
    List<AppletLevelBenefitsVo> resultList = Lists.newArrayList();
    // 获取系统配置的
    List<SystemSettingsReservedVo> reserved = systemSettingsService.findReserved();
    if(CollectionUtils.isNotEmpty(reserved)){
      reserved.sort(Comparator.comparing(SystemSettingsReservedVo::getReservedFieldsOne));
      AppletLevelBenefitsVo appletLevelBenefitsVo;
      for (SystemSettingsReservedVo systemSettingsReservedVo : reserved) {
        if(Objects.equals("A",systemSettingsReservedVo.getReservedFieldsOne())){
          continue;
        }
        appletLevelBenefitsVo = new AppletLevelBenefitsVo();
        appletLevelBenefitsVo.setCode(systemSettingsReservedVo.getReservedFieldsOne());
        appletLevelBenefitsVo.setName(systemSettingsReservedVo.getTypeValue());
        List<AppletLevelBenefitsDetailsVo> appletLevelBenefitsDetailsVos = Lists.newArrayList();
        AppletLevelBenefitsDetailsVo appletLevelBenefitsDetailsVo;
        if(Objects.equals("B",systemSettingsReservedVo.getReservedFieldsOne())){
          appletLevelBenefitsVo.setBNum(blist.size());
          for (LevelManageBenefitsDetailVo levelManageBenefitsDetailVo : blist) {
            appletLevelBenefitsDetailsVo = new AppletLevelBenefitsDetailsVo();
            appletLevelBenefitsDetailsVo.setCode(levelManageBenefitsDetailVo.getCode());
            BenefitsManageVo benefitsManageVo = benefitsManageVoMap
                .get(levelManageBenefitsDetailVo.getCode());
            if(benefitsManageVo!=null){
              appletLevelBenefitsDetailsVo.setName(benefitsManageVo.getName());
              appletLevelBenefitsDetailsVo.setProductDesc(benefitsManageVo.getProductDesc());
              appletLevelBenefitsDetailsVo.setProductImage(benefitsManageVo.getProductImage());
              appletLevelBenefitsDetailsVo.setUnit(benefitsManageVo.getUnit());
            }
            appletLevelBenefitsDetailsVo.setNum(levelManageBenefitsDetailVo.getNum());
            appletLevelBenefitsDetailsVo.setRemarkDesc(levelManageBenefitsDetailVo.getRemarkDesc());
            appletLevelBenefitsDetailsVos.add(appletLevelBenefitsDetailsVo);
          }
          appletLevelBenefitsVo.setList(appletLevelBenefitsDetailsVos);
        }else{
          List<LevelManageBenefitsDetailVo> levelManageBenefitsDetailVos = otherLevelManageBenefitsDetailVoMap
              .get(systemSettingsReservedVo.getReservedFieldsOne());
          appletLevelBenefitsVo.setBNum(levelManageBenefitsDetailVos.size());
          for (LevelManageBenefitsDetailVo levelManageBenefitsDetailVo : levelManageBenefitsDetailVos) {
            appletLevelBenefitsDetailsVo = new AppletLevelBenefitsDetailsVo();
            appletLevelBenefitsDetailsVo.setCode(levelManageBenefitsDetailVo.getCode());
            BenefitsManageVo benefitsManageVo = benefitsManageVoMap
                .get(levelManageBenefitsDetailVo.getCode());
            if(benefitsManageVo!=null){
              appletLevelBenefitsDetailsVo.setName(benefitsManageVo.getName());
              appletLevelBenefitsDetailsVo.setProductDesc(benefitsManageVo.getProductDesc());
              appletLevelBenefitsDetailsVo.setProductImage(benefitsManageVo.getProductImage());
              appletLevelBenefitsDetailsVo.setUnit(benefitsManageVo.getUnit());
            }
            appletLevelBenefitsDetailsVo.setNum(levelManageBenefitsDetailVo.getNum());
            appletLevelBenefitsDetailsVo.setRemarkDesc(levelManageBenefitsDetailVo.getRemarkDesc());
            appletLevelBenefitsDetailsVos.add(appletLevelBenefitsDetailsVo);
          }
          appletLevelBenefitsVo.setList(appletLevelBenefitsDetailsVos);
        }
        resultList.add(appletLevelBenefitsVo);
      }
    }
    return resultList;
  }

  private void createValidation(LevelManageVo levelManageVo) {
    this.validation(levelManageVo);
  }

  private void updateValidation(LevelManageVo levelManageVo) {
    this.validation(levelManageVo);
  }

  private void validation(LevelManageVo levelManageVo) {
    Validate.notNull(levelManageVo.getLevelNum(), "等级不能为空");
    Validate.notBlank(levelManageVo.getLevelName(), "等级名称不能为空");
    Validate.notNull(levelManageVo.getGrowStart(), "成长值区间开始不能为空");
    Validate.notBlank(levelManageVo.getCardImageOne(), "第一年该等级卡片不能为空");
    Validate.notNull(levelManageVo.getExpireDeductRatio(), "到期扣除比例不能为空");
    Validate.notNull(levelManageVo.getActiveGrow(), "激活成长值不能为空");
    // 验证成长值区间不能重复
    List<LevelManage> list = this.levelManageRepository.checkGrow(levelManageVo);
    Validate.isTrue(CollectionUtils.isEmpty(list), "成长值区间重叠,请检查");
    // 等级权益列表不能为空
//    Validate.isTrue(CollectionUtils.isNotEmpty(levelManageVo.getList()), "等级权益列表不能为空");
  }
}
