package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoArchivesVo;
import com.biz.crm.member.business.member.local.entity.MemberInfoArchives;
import com.biz.crm.member.business.member.local.repository.MemberInfoArchivesRepository;
import com.biz.crm.member.business.member.local.service.MemberInfoArchivesService;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoArchivesPaginationDto;
import com.biz.crm.member.business.member.sdk.event.MemberInfoArchivesEventListener;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 会员档案(MemberInfoArchives)表服务实现类
 *
 * @author zouhs
 * @date 2023-06-19 14:32:22
 */
@Slf4j
@Service("memberInfoArchivesService")
public class MemberInfoArchivesServiceImpl implements MemberInfoArchivesService {
  
  @Autowired(required = false)
  private MemberInfoArchivesRepository memberInfoArchivesRepository;

  @Autowired(required = false)
  private List<MemberInfoArchivesEventListener> eventListeners;

  @Autowired(required = false)
  private GenerateCodeService generateCodeService;

  @Autowired
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public Page<MemberInfoArchivesVo> findByConditions(Pageable pageable, MemberInfoArchivesPaginationDto dto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    dto = Optional.ofNullable(dto).orElse(new MemberInfoArchivesPaginationDto());
    Page<MemberInfoArchivesVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.memberInfoArchivesRepository.findByConditions(page, dto);
  }

  @Override
  public MemberInfoArchivesVo findDetailById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    MemberInfoArchives memberInfoArchives = this.memberInfoArchivesRepository.findById(id);
    MemberInfoArchivesVo memberInfoArchivesVo = this.nebulaToolkitService.copyObjectByWhiteList(memberInfoArchives, MemberInfoArchivesVo.class, HashSet.class, LinkedList.class);
    return memberInfoArchivesVo;
  }

  @Override
  public MemberInfoArchivesVo findDetailByMemberCode(String memberCode) {
    if (StringUtils.isBlank(memberCode)) {
      return null;
    }
    MemberInfoArchives memberInfoArchives = this.memberInfoArchivesRepository.lambdaQuery().eq(MemberInfoArchives::getMemberCode,memberCode).one();
    MemberInfoArchivesVo memberInfoArchivesVo = this.nebulaToolkitService.copyObjectByWhiteList(memberInfoArchives, MemberInfoArchivesVo.class, HashSet.class, LinkedList.class);
    return memberInfoArchivesVo;
  }

  @Override
  @Transactional
  public MemberInfoArchivesVo create(MemberInfoArchivesVo memberInfoArchivesVo) {
    this.createValidation(memberInfoArchivesVo);
    MemberInfoArchives memberInfoArchives = this.nebulaToolkitService.copyObjectByWhiteList(memberInfoArchivesVo, MemberInfoArchives.class, HashSet.class, LinkedList.class);
    memberInfoArchives.setTenantCode(TenantUtils.getTenantCode());
    memberInfoArchives.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    memberInfoArchives.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    this.memberInfoArchivesRepository.saveOrUpdate(memberInfoArchives);
    // 发送通知
    // TODO 发送通知
    return memberInfoArchivesVo;
  }

  @Override
  @Transactional
  public MemberInfoArchivesVo update(MemberInfoArchivesVo memberInfoArchivesVo) {
    this.updateValidation(memberInfoArchivesVo);
    String currentId = memberInfoArchivesVo.getId();
    MemberInfoArchives current = memberInfoArchivesRepository.findById(currentId);
    current = Validate.notNull(current, "修改信息不存在");
    current = this.nebulaToolkitService.copyObjectByWhiteList(memberInfoArchivesVo, MemberInfoArchives.class, HashSet.class, LinkedList.class);
    this.memberInfoArchivesRepository.saveOrUpdate(current);
    // 发送修改通知
    // TODO 发送通知
    return memberInfoArchivesVo;
  }

  @Override
  @Transactional
  public void enableBatch(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.memberInfoArchivesRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
  }

  @Override
  @Transactional
  public void disableBatch(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.memberInfoArchivesRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
  }
  
  @Override
  @Transactional
  public void updateDelFlagByIds(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.memberInfoArchivesRepository.updateDelFlagByIds(ids);
  }

  private void createValidation(MemberInfoArchivesVo memberInfoArchivesVo) {
    // TODO 具体实现
    this.validation(memberInfoArchivesVo);
  }

  private void updateValidation(MemberInfoArchivesVo memberInfoArchivesVo) {
    // TODO 具体实现
    this.validation(memberInfoArchivesVo);
  }

  private void validation(MemberInfoArchivesVo memberInfoArchivesVo) {
    // TODO 具体实现
  }
}
