package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoAssetsVo;
import com.biz.crm.member.business.member.local.entity.MemberInfoAssets;
import com.biz.crm.member.business.member.local.repository.MemberInfoAssetsRepository;
import com.biz.crm.member.business.member.local.service.MemberInfoAssetsService;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoAssetsPaginationDto;
import com.biz.crm.member.business.member.sdk.event.MemberInfoAssetsEventListener;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 会员资产(MemberInfoAssets)表服务实现类
 *
 * @author zouhs
 * @date 2023-06-19 14:32:53
 */
@Slf4j
@Service("memberInfoAssetsService")
public class MemberInfoAssetsServiceImpl implements MemberInfoAssetsService {
  
  @Autowired(required = false)
  private MemberInfoAssetsRepository memberInfoAssetsRepository;

  @Autowired(required = false)
  private List<MemberInfoAssetsEventListener> eventListeners;

  @Autowired(required = false)
  private GenerateCodeService generateCodeService;

  @Autowired
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public Page<MemberInfoAssetsVo> findByConditions(Pageable pageable, MemberInfoAssetsPaginationDto dto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    dto = Optional.ofNullable(dto).orElse(new MemberInfoAssetsPaginationDto());
    Page<MemberInfoAssetsVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.memberInfoAssetsRepository.findByConditions(page, dto);
  }

  @Override
  public MemberInfoAssetsVo findDetailById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    MemberInfoAssets memberInfoAssets = this.memberInfoAssetsRepository.findById(id);
    MemberInfoAssetsVo memberInfoAssetsVo = this.nebulaToolkitService.copyObjectByWhiteList(memberInfoAssets, MemberInfoAssetsVo.class, HashSet.class, LinkedList.class);
    return memberInfoAssetsVo;
  }

  @Override
  public MemberInfoAssetsVo findDetailByMemberCode(String memberCode) {
    if (StringUtils.isBlank(memberCode)) {
      return null;
    }
    MemberInfoAssets memberInfoAssets = this.memberInfoAssetsRepository.lambdaQuery().eq(MemberInfoAssets::getMemberCode,memberCode).one();
    MemberInfoAssetsVo memberInfoAssetsVo = this.nebulaToolkitService.copyObjectByWhiteList(memberInfoAssets, MemberInfoAssetsVo.class, HashSet.class, LinkedList.class);
    return memberInfoAssetsVo;
  }

  @Override
  @Transactional
  public MemberInfoAssetsVo create(MemberInfoAssetsVo memberInfoAssetsVo) {
    this.createValidation(memberInfoAssetsVo);
    MemberInfoAssets memberInfoAssets = this.nebulaToolkitService.copyObjectByWhiteList(memberInfoAssetsVo, MemberInfoAssets.class, HashSet.class, LinkedList.class);
    memberInfoAssets.setTenantCode(TenantUtils.getTenantCode());
    memberInfoAssets.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    memberInfoAssets.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    this.memberInfoAssetsRepository.saveOrUpdate(memberInfoAssets);
    // 发送通知
    // TODO 发送通知
    return memberInfoAssetsVo;
  }

  @Override
  @Transactional
  public MemberInfoAssetsVo update(MemberInfoAssetsVo memberInfoAssetsVo) {
    this.updateValidation(memberInfoAssetsVo);
    String currentId = memberInfoAssetsVo.getId();
    MemberInfoAssets current = memberInfoAssetsRepository.findById(currentId);
    current = Validate.notNull(current, "修改信息不存在");
    current = this.nebulaToolkitService.copyObjectByWhiteList(memberInfoAssetsVo, MemberInfoAssets.class, HashSet.class, LinkedList.class);
    this.memberInfoAssetsRepository.saveOrUpdate(current);
    return memberInfoAssetsVo;
  }

  @Override
  @Transactional
  public void enableBatch(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.memberInfoAssetsRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
  }

  @Override
  @Transactional
  public void disableBatch(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.memberInfoAssetsRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
  }
  
  @Override
  @Transactional
  public void updateDelFlagByIds(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.memberInfoAssetsRepository.updateDelFlagByIds(ids);
  }

  private void createValidation(MemberInfoAssetsVo memberInfoAssetsVo) {
    // TODO 具体实现
    this.validation(memberInfoAssetsVo);
  }

  private void updateValidation(MemberInfoAssetsVo memberInfoAssetsVo) {
    // TODO 具体实现
    this.validation(memberInfoAssetsVo);
  }

  private void validation(MemberInfoAssetsVo memberInfoAssetsVo) {
    // TODO 具体实现
  }
}
