package com.biz.crm.member.business.member.local.service.internal;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.local.service.DummyOrderService;
import com.biz.crm.member.business.member.local.service.DummyOrderUserService;
import com.biz.crm.member.business.member.local.service.RealOrderService;
import com.biz.crm.member.business.member.sdk.dto.BenefitsRecordPaginationDto;
import com.biz.crm.member.business.member.sdk.enums.BenefitsTypeEnum;
import com.biz.crm.member.business.member.sdk.enums.DummyOrderStatusEnum;
import com.biz.crm.member.business.member.sdk.enums.OrderSourceEnum;
import com.biz.crm.member.business.member.sdk.enums.RealOrderStatusEnum;
import com.biz.crm.member.business.member.sdk.vo.DummyOrderVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoBenefitsVo;
import com.biz.crm.member.business.member.local.entity.MemberInfoBenefits;
import com.biz.crm.member.business.member.local.repository.MemberInfoBenefitsRepository;
import com.biz.crm.member.business.member.local.service.MemberInfoBenefitsService;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoBenefitsPaginationDto;
import com.biz.crm.member.business.member.sdk.event.MemberInfoBenefitsEventListener;
import com.biz.crm.member.business.member.sdk.vo.RealOrderVo;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletLevelBenefitsVo;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletMemberInfoBenefits;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletMemberInfoBenefitsReqVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 会员权益关联表(MemberInfoBenefits)表服务实现类
 *
 * @author zouhs
 * @date 2023-06-20 15:08:40
 */
@Slf4j
@Service("memberInfoBenefitsService")
public class MemberInfoBenefitsServiceImpl implements MemberInfoBenefitsService {

  @Autowired(required = false)
  private MemberInfoBenefitsRepository memberInfoBenefitsRepository;

  @Autowired(required = false)
  private List<MemberInfoBenefitsEventListener> eventListeners;

  @Autowired(required = false)
  private GenerateCodeService generateCodeService;

  @Autowired
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Autowired
  private DummyOrderUserService dummyOrderUserService;

  @Autowired
  private RealOrderService realOrderService;

  @Autowired
  private DummyOrderService dummyOrderService;

  @Override
  public Page<MemberInfoBenefitsVo> findByConditions(Pageable pageable,
      MemberInfoBenefitsPaginationDto dto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    dto = Optional.ofNullable(dto).orElse(new MemberInfoBenefitsPaginationDto());
    Page<MemberInfoBenefitsVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.memberInfoBenefitsRepository.findByConditions(page, dto);
  }

  @Override
  public MemberInfoBenefitsVo findDetailById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    MemberInfoBenefits memberInfoBenefits = this.memberInfoBenefitsRepository.findById(id);
    MemberInfoBenefitsVo memberInfoBenefitsVo = this.nebulaToolkitService
        .copyObjectByWhiteList(memberInfoBenefits, MemberInfoBenefitsVo.class, HashSet.class,
            LinkedList.class);
    return memberInfoBenefitsVo;
  }

  @Override
  @Transactional
  public MemberInfoBenefitsVo create(MemberInfoBenefitsVo memberInfoBenefitsVo) {
    this.createValidation(memberInfoBenefitsVo);
    MemberInfoBenefits memberInfoBenefits = this.nebulaToolkitService
        .copyObjectByWhiteList(memberInfoBenefitsVo, MemberInfoBenefits.class, HashSet.class,
            LinkedList.class);
    memberInfoBenefits.setTenantCode(TenantUtils.getTenantCode());
    memberInfoBenefits.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    memberInfoBenefits.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    this.memberInfoBenefitsRepository.saveOrUpdate(memberInfoBenefits);
    return memberInfoBenefitsVo;
  }

  @Override
  @Transactional
  public MemberInfoBenefitsVo update(MemberInfoBenefitsVo memberInfoBenefitsVo) {
    this.updateValidation(memberInfoBenefitsVo);
    String currentId = memberInfoBenefitsVo.getId();
    MemberInfoBenefits current = memberInfoBenefitsRepository.findById(currentId);
    current = Validate.notNull(current, "修改信息不存在");
    current = this.nebulaToolkitService
        .copyObjectByWhiteList(memberInfoBenefitsVo, MemberInfoBenefits.class, HashSet.class,
            LinkedList.class);
    this.memberInfoBenefitsRepository.saveOrUpdate(current);
    return memberInfoBenefitsVo;
  }

  @Override
  @Transactional
  public void enableBatch(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.memberInfoBenefitsRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
  }

  @Override
  @Transactional
  public void disableBatch(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.memberInfoBenefitsRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
  }

  @Override
  @Transactional
  public void updateDelFlagByIds(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.memberInfoBenefitsRepository.updateDelFlagByIds(ids);
  }

  @Override
  public Page<AppletMemberInfoBenefits> getMemberInfoBenefitsList(
      Pageable pageable, AppletMemberInfoBenefitsReqVo dto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    dto = Optional.ofNullable(dto).orElse(new AppletMemberInfoBenefitsReqVo());
    Page<AppletMemberInfoBenefits> page = new Page<>(pageable.getPageNumber(),
        pageable.getPageSize());
    Page<AppletMemberInfoBenefits> result = this.memberInfoBenefitsRepository
        .getMemberInfoBenefitsList(page, dto);
    if (result != null && CollectionUtils.isNotEmpty(result.getRecords())) {
      for (AppletMemberInfoBenefits record : result.getRecords()) {
        record.setEndBenefitsTime(
            DateUtil.offsetMonth(record.getObtainBenefitsTime(), record.getExchangeValidPeriod()));
        // 虚拟查询用户报名信息
        if (Objects.equals(BenefitsTypeEnum.DUMMY.getValue(), record.getBenefitsType())) {
          DummyOrderVo dummyOrderVo = dummyOrderService
              .findDetailByOrderCode(record.getOrderCode());
          if (dummyOrderVo != null) {
            record.setDummyOrderStatus(dummyOrderVo.getOrderStatus());
          }
          record.setList(dummyOrderUserService.userInfoList(record.getOrderCode()));
        } else if (Objects.equals(BenefitsTypeEnum.REAL.getValue(), record.getBenefitsType())) {
          RealOrderVo detailByOrderCode = realOrderService
              .findDetailByOrderCode(record.getBenefitsType());
          if (detailByOrderCode != null) {
            record.setRealOrderStatus(detailByOrderCode.getOrderStatus());
            record.setReceiptName(detailByOrderCode.getReceiptName());
            record.setReceiptPhone(detailByOrderCode.getReceiptPhone());
            record.setReceiptAddress(detailByOrderCode.getReceiptAddress());
            record.setExpressNum(detailByOrderCode.getExpressNum());
          }
        }
      }
    }
    return result;
  }

  /**
   * 根据条件分页获取权限记录
   *
   * @param pageable
   * @param dto
   * @return
   */
  @Override
  public Page<MemberInfoBenefitsVo> pageByConditions(Pageable pageable,
      BenefitsRecordPaginationDto dto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    dto = Optional.ofNullable(dto).orElse(new BenefitsRecordPaginationDto());
    Page<MemberInfoBenefitsVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.memberInfoBenefitsRepository.pageByConditions(page, dto);
  }

  @Override
  public AppletMemberInfoBenefits getMemberInfoBenefitsDetailById(String memberCode, String id) {
    MemberInfoBenefits memberInfoBenefits = memberInfoBenefitsRepository.findById(id);
    if (memberInfoBenefits == null) {
      Validate.isTrue(false, "当前会员权益已失效");
    }
    if (!Objects.equals(memberInfoBenefits.getMemberCode(), memberCode)) {
      Validate.isTrue(false, "当前会员权益非本人兑换");
    }
    AppletMemberInfoBenefits appletMemberInfoBenefits = this.nebulaToolkitService
        .copyObjectByWhiteList(memberInfoBenefits, AppletMemberInfoBenefits.class, HashSet.class,
            LinkedList.class);
    return appletMemberInfoBenefits;
  }

  @Override
  public AppletMemberInfoBenefits getMemberInfoBenefitsSubmit(
      AppletMemberInfoBenefits appletMemberInfoBenefits) {
    Validate.notBlank(appletMemberInfoBenefits.getId(),"兑换权益ID不能为空");
    MemberInfoBenefits memberInfoBenefits = memberInfoBenefitsRepository.findById(appletMemberInfoBenefits.getId());
    if (memberInfoBenefits == null) {
      Validate.isTrue(false, "当前会员权益已失效");
    }
    if (!Objects.equals(memberInfoBenefits.getMemberCode(), appletMemberInfoBenefits.getMemberCode())) {
      Validate.isTrue(false, "当前会员权益非本人兑换");
    }
    // 虚拟订单
    if(Objects.equals(BenefitsTypeEnum.DUMMY.getValue(),memberInfoBenefits.getBenefitsType())){
      DummyOrderVo dummyOrderVo = new DummyOrderVo();
      dummyOrderVo.setOrderStatus(DummyOrderStatusEnum.STAY_USE.getValue());
      dummyOrderVo.setOrderSource(OrderSourceEnum.MEMBER_ROLE.getValue());
      dummyOrderVo.setUserCode(appletMemberInfoBenefits.getMemberCode());
      dummyOrderVo.setProductImg(memberInfoBenefits.getProductImage());
      dummyOrderVo.setProductNum(memberInfoBenefits.getNum());
      dummyOrderVo.setProductName(memberInfoBenefits.getBenefitsName());
      dummyOrderVo.setList(appletMemberInfoBenefits.getList());
      DummyOrderVo dummyOrderVo1 = dummyOrderService.create(dummyOrderVo);
      appletMemberInfoBenefits.setOrderId(dummyOrderVo1.getId());
      appletMemberInfoBenefits.setOrderCode(dummyOrderVo1.getOrderCode());
    }else{
      // 实物订单
      RealOrderVo realOrderVo = new RealOrderVo();
      realOrderVo.setOrderSource(OrderSourceEnum.MEMBER_ROLE.getValue());
      realOrderVo.setProductImg(memberInfoBenefits.getProductImage());
      realOrderVo.setUserCode(appletMemberInfoBenefits.getMemberCode());
      realOrderVo.setProductNum(memberInfoBenefits.getNum());
      realOrderVo.setProductName(memberInfoBenefits.getBenefitsName());
      realOrderVo.setReceiptName(appletMemberInfoBenefits.getReceiptName());
      realOrderVo.setReceiptPhone(appletMemberInfoBenefits.getReceiptPhone());
      realOrderVo.setReceiptAddress(appletMemberInfoBenefits.getReceiptAddress());
      RealOrderVo realOrderVo1 = realOrderService.create(realOrderVo);
      appletMemberInfoBenefits.setOrderId(realOrderVo1.getId());
      appletMemberInfoBenefits.setOrderCode(realOrderVo1.getOrderCode());
    }
    return appletMemberInfoBenefits;
  }

  private void createValidation(MemberInfoBenefitsVo memberInfoBenefitsVo) {
    this.validation(memberInfoBenefitsVo);
  }

  private void updateValidation(MemberInfoBenefitsVo memberInfoBenefitsVo) {
    this.validation(memberInfoBenefitsVo);
  }

  private void validation(MemberInfoBenefitsVo memberInfoBenefitsVo) {
  }
}
