package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.sdk.vo.GrowRecordAPIVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoComeBackRecordDetailVo;
import com.biz.crm.member.business.member.local.entity.MemberInfoComeBackRecordDetail;
import com.biz.crm.member.business.member.local.repository.MemberInfoComeBackRecordDetailRepository;
import com.biz.crm.member.business.member.local.service.MemberInfoComeBackRecordDetailService;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoComeBackRecordDetailPaginationDto;
import com.biz.crm.member.business.member.sdk.event.MemberInfoComeBackRecordDetailEventListener;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 会员退货记录明细(MemberInfoComeBackRecordDetail)表服务实现类
 *
 * @author zouhs
 * @date 2023-06-28 16:57:10
 */
@Slf4j
@Service("memberInfoComeBackRecordDetailService")
public class MemberInfoComeBackRecordDetailServiceImpl implements MemberInfoComeBackRecordDetailService {
  
  @Autowired(required = false)
  private MemberInfoComeBackRecordDetailRepository memberInfoComeBackRecordDetailRepository;

  @Autowired(required = false)
  private List<MemberInfoComeBackRecordDetailEventListener> eventListeners;

  @Autowired(required = false)
  private GenerateCodeService generateCodeService;

  @Autowired
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public Page<MemberInfoComeBackRecordDetailVo> findByConditions(Pageable pageable, MemberInfoComeBackRecordDetailPaginationDto dto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    dto = Optional.ofNullable(dto).orElse(new MemberInfoComeBackRecordDetailPaginationDto());
    Page<MemberInfoComeBackRecordDetailVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.memberInfoComeBackRecordDetailRepository.findByConditions(page, dto);
  }

  @Override
  public MemberInfoComeBackRecordDetailVo findDetailById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    MemberInfoComeBackRecordDetail memberInfoComeBackRecordDetail = this.memberInfoComeBackRecordDetailRepository.findById(id);
    MemberInfoComeBackRecordDetailVo memberInfoComeBackRecordDetailVo = this.nebulaToolkitService.copyObjectByWhiteList(memberInfoComeBackRecordDetail, MemberInfoComeBackRecordDetailVo.class, HashSet.class, LinkedList.class);
    return memberInfoComeBackRecordDetailVo;
  }
  
  @Override
  @Transactional
  public MemberInfoComeBackRecordDetailVo create(MemberInfoComeBackRecordDetailVo memberInfoComeBackRecordDetailVo) {
    this.createValidation(memberInfoComeBackRecordDetailVo);
    MemberInfoComeBackRecordDetail memberInfoComeBackRecordDetail = this.nebulaToolkitService.copyObjectByWhiteList(memberInfoComeBackRecordDetailVo, MemberInfoComeBackRecordDetail.class, HashSet.class, LinkedList.class);
    memberInfoComeBackRecordDetail.setTenantCode(TenantUtils.getTenantCode());
    memberInfoComeBackRecordDetail.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    memberInfoComeBackRecordDetail.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    this.memberInfoComeBackRecordDetailRepository.saveOrUpdate(memberInfoComeBackRecordDetail);
    return memberInfoComeBackRecordDetailVo;
  }

  @Override
  @Transactional
  public MemberInfoComeBackRecordDetailVo update(MemberInfoComeBackRecordDetailVo memberInfoComeBackRecordDetailVo) {
    this.updateValidation(memberInfoComeBackRecordDetailVo);
    String currentId = memberInfoComeBackRecordDetailVo.getId();
    MemberInfoComeBackRecordDetail current = memberInfoComeBackRecordDetailRepository.findById(currentId);
    current = Validate.notNull(current, "修改信息不存在");
    current = this.nebulaToolkitService.copyObjectByWhiteList(memberInfoComeBackRecordDetailVo, MemberInfoComeBackRecordDetail.class, HashSet.class, LinkedList.class);
    this.memberInfoComeBackRecordDetailRepository.saveOrUpdate(current);
    return memberInfoComeBackRecordDetailVo;
  }

  @Override
  @Transactional
  public void enableBatch(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.memberInfoComeBackRecordDetailRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
  }

  @Override
  @Transactional
  public void disableBatch(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.memberInfoComeBackRecordDetailRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
  }
  
  @Override
  @Transactional
  public void updateDelFlagByIds(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.memberInfoComeBackRecordDetailRepository.updateDelFlagByIds(ids);
  }

  @Override
  public List<GrowRecordAPIVo> findDetailByResourceDocumentCode(String resourceDocumentCode) {
    List<GrowRecordAPIVo> result = Lists.newArrayList();
    List<MemberInfoComeBackRecordDetail> list = this.memberInfoComeBackRecordDetailRepository.lambdaQuery()
        .eq(MemberInfoComeBackRecordDetail::getComeBackCode, resourceDocumentCode)
        .list();
    if(CollectionUtils.isNotEmpty(list)){
      GrowRecordAPIVo growRecordAPIVo;
      for (MemberInfoComeBackRecordDetail memberInfoComeBackRecordDetail : list) {
        growRecordAPIVo = new GrowRecordAPIVo();
        growRecordAPIVo.setProductName(memberInfoComeBackRecordDetail.getProductName());
        growRecordAPIVo.setNum(memberInfoComeBackRecordDetail.getNum());
        result.add(growRecordAPIVo);
      }
    }
    return result;
  }

  private void createValidation(MemberInfoComeBackRecordDetailVo memberInfoComeBackRecordDetailVo) {
    this.validation(memberInfoComeBackRecordDetailVo);
  }

  private void updateValidation(MemberInfoComeBackRecordDetailVo memberInfoComeBackRecordDetailVo) {
    this.validation(memberInfoComeBackRecordDetailVo);
  }

  private void validation(MemberInfoComeBackRecordDetailVo memberInfoComeBackRecordDetailVo) {
  }
}
