package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.local.entity.MemberInfoComeBackRecordDetail;
import com.biz.crm.member.business.member.local.repository.MemberInfoComeBackRecordDetailRepository;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoComeBackRecordDetailVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoComeBackRecordVo;
import com.biz.crm.member.business.member.local.entity.MemberInfoComeBackRecord;
import com.biz.crm.member.business.member.local.repository.MemberInfoComeBackRecordRepository;
import com.biz.crm.member.business.member.local.service.MemberInfoComeBackRecordService;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoComeBackRecordPaginationDto;
import com.biz.crm.member.business.member.sdk.event.MemberInfoComeBackRecordEventListener;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 会员退货记录(MemberInfoComeBackRecord)表服务实现类
 *
 * @author zouhs
 * @date 2023-06-28 16:56:23
 */
@Slf4j
@Service("memberInfoComeBackRecordService")
public class MemberInfoComeBackRecordServiceImpl implements MemberInfoComeBackRecordService {
  
  @Autowired(required = false)
  private MemberInfoComeBackRecordRepository memberInfoComeBackRecordRepository;

  @Autowired(required = false)
  private List<MemberInfoComeBackRecordEventListener> eventListeners;

  @Autowired(required = false)
  private GenerateCodeService generateCodeService;

  @Autowired
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Autowired
  private MemberInfoComeBackRecordDetailRepository memberInfoComeBackRecordDetailRepository;

  @Override
  public Page<MemberInfoComeBackRecordVo> findByConditions(Pageable pageable, MemberInfoComeBackRecordPaginationDto dto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    dto = Optional.ofNullable(dto).orElse(new MemberInfoComeBackRecordPaginationDto());
    Page<MemberInfoComeBackRecordVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.memberInfoComeBackRecordRepository.findByConditions(page, dto);
  }

  @Override
  public MemberInfoComeBackRecordVo findDetailById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    MemberInfoComeBackRecord memberInfoComeBackRecord = this.memberInfoComeBackRecordRepository.findById(id);
    MemberInfoComeBackRecordVo memberInfoComeBackRecordVo = this.nebulaToolkitService.copyObjectByWhiteList(memberInfoComeBackRecord, MemberInfoComeBackRecordVo.class, HashSet.class, LinkedList.class);
    return memberInfoComeBackRecordVo;
  }
  
  @Override
  @Transactional
  public MemberInfoComeBackRecordVo create(MemberInfoComeBackRecordVo memberInfoComeBackRecordVo) {
    this.createValidation(memberInfoComeBackRecordVo);
    MemberInfoComeBackRecord memberInfoComeBackRecord = this.nebulaToolkitService.copyObjectByWhiteList(memberInfoComeBackRecordVo, MemberInfoComeBackRecord.class, HashSet.class, LinkedList.class);
    memberInfoComeBackRecord.setTenantCode(TenantUtils.getTenantCode());
    memberInfoComeBackRecord.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    memberInfoComeBackRecord.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    this.memberInfoComeBackRecordRepository.saveOrUpdate(memberInfoComeBackRecord);
    return memberInfoComeBackRecordVo;
  }

  @Override
  @Transactional
  public MemberInfoComeBackRecordVo update(MemberInfoComeBackRecordVo memberInfoComeBackRecordVo) {
    this.updateValidation(memberInfoComeBackRecordVo);
    String currentId = memberInfoComeBackRecordVo.getId();
    MemberInfoComeBackRecord current = memberInfoComeBackRecordRepository.findById(currentId);
    current = Validate.notNull(current, "修改信息不存在");
    current = this.nebulaToolkitService.copyObjectByWhiteList(memberInfoComeBackRecordVo, MemberInfoComeBackRecord.class, HashSet.class, LinkedList.class);
    this.memberInfoComeBackRecordRepository.saveOrUpdate(current);
    return memberInfoComeBackRecordVo;
  }

  @Override
  @Transactional
  public void enableBatch(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.memberInfoComeBackRecordRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
  }

  @Override
  @Transactional
  public void disableBatch(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.memberInfoComeBackRecordRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
  }
  
  @Override
  @Transactional
  public void updateDelFlagByIds(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.memberInfoComeBackRecordRepository.updateDelFlagByIds(ids);
  }

  /**
   * 根据退货编码获取退货明细
   * @param comeBackCode
   * @return
   */
  @Override
  public List<MemberInfoComeBackRecordDetailVo> findDetailByComeBackCode(String comeBackCode) {
    Validate.notBlank(comeBackCode, "退货编码不能为空");
    LambdaQueryWrapper<MemberInfoComeBackRecordDetail> queryDetail = new LambdaQueryWrapper<>();
    queryDetail.eq(MemberInfoComeBackRecordDetail::getComeBackCode, comeBackCode)
        .eq(MemberInfoComeBackRecordDetail::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .orderByDesc(MemberInfoComeBackRecordDetail::getCreateTime);
    List<MemberInfoComeBackRecordDetail> details = this.memberInfoComeBackRecordDetailRepository
        .list(queryDetail);
    Collection<MemberInfoComeBackRecordDetailVo> result = this.nebulaToolkitService
        .copyCollectionByWhiteList(details,
            MemberInfoComeBackRecordDetail.class,
            MemberInfoComeBackRecordDetailVo.class,
            HashSet.class,
            LinkedList.class);
    return (List<MemberInfoComeBackRecordDetailVo>) result;
  }

  private void createValidation(MemberInfoComeBackRecordVo memberInfoComeBackRecordVo) {
    this.validation(memberInfoComeBackRecordVo);
  }

  private void updateValidation(MemberInfoComeBackRecordVo memberInfoComeBackRecordVo) {
    this.validation(memberInfoComeBackRecordVo);
  }

  private void validation(MemberInfoComeBackRecordVo memberInfoComeBackRecordVo) {
    Validate.notBlank(memberInfoComeBackRecordVo.getComeBackCode(), "单据流水号不能为空");
    Validate.notBlank(memberInfoComeBackRecordVo.getCustomerCode(), "发货单位编码不能为空");
    Validate.notBlank(memberInfoComeBackRecordVo.getCustomerName(), "发货单位不能为空");
    Validate.notBlank(memberInfoComeBackRecordVo.getTerminalCode(), "收货单位编码不能为空");
    Validate.notBlank(memberInfoComeBackRecordVo.getTerminalName(), "收货单位不能为空");
    Validate.notBlank(memberInfoComeBackRecordVo.getOrgCode(), "组织编码不能为空");
    Validate.notBlank(memberInfoComeBackRecordVo.getOrgName(), "组织名称不能为空");
    Validate.notNull(memberInfoComeBackRecordVo.getDocumentTime(), "单据时间不能为空");
    Validate.notNull(memberInfoComeBackRecordVo.getBackTime(), "退货时间不能为空");
    Validate.notNull(memberInfoComeBackRecordVo.getDeductionGrow(), "获得成长值不能为空");
  }
}
