package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoContactVo;
import com.biz.crm.member.business.member.local.entity.MemberInfoContact;
import com.biz.crm.member.business.member.local.repository.MemberInfoContactRepository;
import com.biz.crm.member.business.member.local.service.MemberInfoContactService;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoContactPaginationDto;
import com.biz.crm.member.business.member.sdk.event.MemberInfoContactEventListener;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 业务员联系人(MemberInfoContact)表服务实现类
 *
 * @author zouhs
 * @date 2023-06-19 14:33:17
 */
@Slf4j
@Service("memberInfoContactService")
public class MemberInfoContactServiceImpl implements MemberInfoContactService {
  
  @Autowired(required = false)
  private MemberInfoContactRepository memberInfoContactRepository;

  @Autowired(required = false)
  private List<MemberInfoContactEventListener> eventListeners;

  @Autowired(required = false)
  private GenerateCodeService generateCodeService;

  @Autowired
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public Page<MemberInfoContactVo> findByConditions(Pageable pageable, MemberInfoContactPaginationDto dto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    dto = Optional.ofNullable(dto).orElse(new MemberInfoContactPaginationDto());
    Page<MemberInfoContactVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.memberInfoContactRepository.findByConditions(page, dto);
  }

  @Override
  public MemberInfoContactVo findDetailById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    MemberInfoContact memberInfoContact = this.memberInfoContactRepository.findById(id);
    MemberInfoContactVo memberInfoContactVo = this.nebulaToolkitService.copyObjectByWhiteList(memberInfoContact, MemberInfoContactVo.class, HashSet.class, LinkedList.class);
    return memberInfoContactVo;
  }
  
  @Override
  @Transactional
  public MemberInfoContactVo create(MemberInfoContactVo memberInfoContactVo) {
    this.createValidation(memberInfoContactVo);
    MemberInfoContact memberInfoContact = this.nebulaToolkitService.copyObjectByWhiteList(memberInfoContactVo, MemberInfoContact.class, HashSet.class, LinkedList.class);
    memberInfoContact.setTenantCode(TenantUtils.getTenantCode());
    memberInfoContact.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    memberInfoContact.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    this.memberInfoContactRepository.saveOrUpdate(memberInfoContact);
    // 发送通知
    // TODO 发送通知
    return memberInfoContactVo;
  }

  @Override
  @Transactional
  public MemberInfoContactVo update(MemberInfoContactVo memberInfoContactVo) {
    this.updateValidation(memberInfoContactVo);
    String currentId = memberInfoContactVo.getId();
    MemberInfoContact current = memberInfoContactRepository.findById(currentId);
    current = Validate.notNull(current, "修改信息不存在");
    current = this.nebulaToolkitService.copyObjectByWhiteList(memberInfoContactVo, MemberInfoContact.class, HashSet.class, LinkedList.class);
    this.memberInfoContactRepository.saveOrUpdate(current);
    // 发送修改通知
    // TODO 发送通知
    return memberInfoContactVo;
  }

  @Override
  @Transactional
  public void enableBatch(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.memberInfoContactRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
  }

  @Override
  @Transactional
  public void disableBatch(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.memberInfoContactRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
  }
  
  @Override
  @Transactional
  public void updateDelFlagByIds(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.memberInfoContactRepository.updateDelFlagByIds(ids);
  }

  private void createValidation(MemberInfoContactVo memberInfoContactVo) {
    // TODO 具体实现
    this.validation(memberInfoContactVo);
  }

  private void updateValidation(MemberInfoContactVo memberInfoContactVo) {
    // TODO 具体实现
    this.validation(memberInfoContactVo);
  }

  private void validation(MemberInfoContactVo memberInfoContactVo) {
    // TODO 具体实现
  }
}
