package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.local.helper.UserSearchHelper;
import com.biz.crm.member.business.member.local.service.MemberInfoComeBackRecordDetailService;
import com.biz.crm.member.business.member.local.service.MemberInfoComeBackRecordService;
import com.biz.crm.member.business.member.local.service.MemberInfoReceiptRecordDetailService;
import com.biz.crm.member.business.member.local.service.MemberInfoReceiptRecordService;
import com.biz.crm.member.business.member.sdk.dto.GrowRecordAPIPaginationDto;
import com.biz.crm.member.business.member.sdk.enums.GrowOperationEnum;
import com.biz.crm.member.business.member.sdk.vo.GrowRecordAPIVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoGrowRecordVo;
import com.biz.crm.member.business.member.local.entity.MemberInfoGrowRecord;
import com.biz.crm.member.business.member.local.repository.MemberInfoGrowRecordRepository;
import com.biz.crm.member.business.member.local.service.MemberInfoGrowRecordService;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoGrowRecordPaginationDto;
import com.biz.crm.member.business.member.sdk.event.MemberInfoGrowRecordEventListener;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 会员成长值变动记录(MemberInfoGrowRecord)表服务实现类
 *
 * @author zouhs
 * @date 2023-06-19 14:33:37
 */
@Slf4j
@Service("memberInfoGrowRecordService")
public class MemberInfoGrowRecordServiceImpl implements MemberInfoGrowRecordService {
  
  @Autowired(required = false)
  private MemberInfoGrowRecordRepository memberInfoGrowRecordRepository;

  @Autowired(required = false)
  private List<MemberInfoGrowRecordEventListener> eventListeners;

  @Autowired(required = false)
  private GenerateCodeService generateCodeService;

  @Autowired
  private MemberInfoComeBackRecordDetailService memberInfoComeBackRecordDetailService;

  @Autowired
  private MemberInfoReceiptRecordDetailService memberInfoReceiptRecordDetailService;

  @Autowired
  private UserSearchHelper userSearchHelper;

  @Autowired
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public Page<MemberInfoGrowRecordVo> findByConditions(Pageable pageable, MemberInfoGrowRecordPaginationDto dto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    dto = Optional.ofNullable(dto).orElse(new MemberInfoGrowRecordPaginationDto());
    Page<MemberInfoGrowRecordVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.memberInfoGrowRecordRepository.findByConditions(page, dto);
  }

  @Override
  public MemberInfoGrowRecordVo findDetailById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    MemberInfoGrowRecord memberInfoGrowRecord = this.memberInfoGrowRecordRepository.findById(id);
    MemberInfoGrowRecordVo memberInfoGrowRecordVo = this.nebulaToolkitService.copyObjectByWhiteList(memberInfoGrowRecord, MemberInfoGrowRecordVo.class, HashSet.class, LinkedList.class);
    return memberInfoGrowRecordVo;
  }
  
  @Override
  @Transactional
  public MemberInfoGrowRecordVo create(MemberInfoGrowRecordVo memberInfoGrowRecordVo) {
    this.createValidation(memberInfoGrowRecordVo);
    MemberInfoGrowRecord memberInfoGrowRecord = this.nebulaToolkitService.copyObjectByWhiteList(memberInfoGrowRecordVo, MemberInfoGrowRecord.class, HashSet.class, LinkedList.class);
    memberInfoGrowRecord.setTenantCode(TenantUtils.getTenantCode());
    memberInfoGrowRecord.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    memberInfoGrowRecord.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    this.memberInfoGrowRecordRepository.saveOrUpdate(memberInfoGrowRecord);
    return memberInfoGrowRecordVo;
  }

  @Override
  @Transactional
  public MemberInfoGrowRecordVo update(MemberInfoGrowRecordVo memberInfoGrowRecordVo) {
    this.updateValidation(memberInfoGrowRecordVo);
    String currentId = memberInfoGrowRecordVo.getId();
    MemberInfoGrowRecord current = memberInfoGrowRecordRepository.findById(currentId);
    current = Validate.notNull(current, "修改信息不存在");
    current = this.nebulaToolkitService.copyObjectByWhiteList(memberInfoGrowRecordVo, MemberInfoGrowRecord.class, HashSet.class, LinkedList.class);
    this.memberInfoGrowRecordRepository.saveOrUpdate(current);
    // 发送修改通知
    // TODO 发送通知
    return memberInfoGrowRecordVo;
  }

  @Override
  @Transactional
  public void enableBatch(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.memberInfoGrowRecordRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
  }

  @Override
  @Transactional
  public void disableBatch(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.memberInfoGrowRecordRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
  }
  
  @Override
  @Transactional
  public void updateDelFlagByIds(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.memberInfoGrowRecordRepository.updateDelFlagByIds(ids);
  }

  @Override
  public Page<GrowRecordAPIVo> findByConditionsAPI(Pageable pageable, GrowRecordAPIPaginationDto dto) {
    String memberCode = userSearchHelper.getMemberLogin().getMemberCode();
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    dto = Optional.ofNullable(dto).orElse(new GrowRecordAPIPaginationDto());
    Page<GrowRecordAPIVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    dto.setMemberCode(memberCode);
    return this.memberInfoGrowRecordRepository.findByConditionsAPI(page, dto);
  }

  @Override
  public List<GrowRecordAPIVo> findDetail(GrowRecordAPIVo vo) {
    Validate.notBlank(vo.getIncreaseOrReduce(),"请填写increaseOrReduce字段");
    Validate.notBlank(vo.getResourceDocumentCode(),"请填写resourceDocumentCode字段");
    if (GrowOperationEnum.REDUCE.getValue().equals(vo.getIncreaseOrReduce())){
      return memberInfoComeBackRecordDetailService.findDetailByResourceDocumentCode(vo.getResourceDocumentCode());
    }else if (GrowOperationEnum.INCREASE.getValue().equals(vo.getIncreaseOrReduce())){
      return memberInfoReceiptRecordDetailService.findDetailByResourceDocumentCode(vo.getResourceDocumentCode());
    }
    Validate.notNull(null,"请检查填写是否为increase/reduce");
    return null;
  }

  private void createValidation(MemberInfoGrowRecordVo memberInfoGrowRecordVo) {
    this.validation(memberInfoGrowRecordVo);
  }

  private void updateValidation(MemberInfoGrowRecordVo memberInfoGrowRecordVo) {
    this.validation(memberInfoGrowRecordVo);
  }

  private void validation(MemberInfoGrowRecordVo memberInfoGrowRecordVo) {
    Validate.notBlank(memberInfoGrowRecordVo.getMemberCode(),"会员编码不能为空");
    Validate.notBlank(memberInfoGrowRecordVo.getGrowCode(),"流水编码不能为空");
    Validate.notBlank(memberInfoGrowRecordVo.getSource(),"来源不能为空");
    Validate.notNull(memberInfoGrowRecordVo.getGrow(),"操作成长值不能为空");
  }
}
