package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoLevelChangeRecordVo;
import com.biz.crm.member.business.member.local.entity.MemberInfoLevelChangeRecord;
import com.biz.crm.member.business.member.local.repository.MemberInfoLevelChangeRecordRepository;
import com.biz.crm.member.business.member.local.service.MemberInfoLevelChangeRecordService;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoLevelChangeRecordPaginationDto;
import com.biz.crm.member.business.member.sdk.event.MemberInfoLevelChangeRecordEventListener;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 会员等级变动记录(MemberInfoLevelChangeRecord)表服务实现类
 *
 * @author zouhs
 * @date 2023-06-19 14:34:22
 */
@Slf4j
@Service("memberInfoLevelChangeRecordService")
public class MemberInfoLevelChangeRecordServiceImpl implements MemberInfoLevelChangeRecordService {
  
  @Autowired(required = false)
  private MemberInfoLevelChangeRecordRepository memberInfoLevelChangeRecordRepository;

  @Autowired(required = false)
  private List<MemberInfoLevelChangeRecordEventListener> eventListeners;

  @Autowired(required = false)
  private GenerateCodeService generateCodeService;

  @Autowired
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public Page<MemberInfoLevelChangeRecordVo> findByConditions(Pageable pageable, MemberInfoLevelChangeRecordPaginationDto dto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    dto = Optional.ofNullable(dto).orElse(new MemberInfoLevelChangeRecordPaginationDto());
    Page<MemberInfoLevelChangeRecordVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.memberInfoLevelChangeRecordRepository.findByConditions(page, dto);
  }

  @Override
  public MemberInfoLevelChangeRecordVo findDetailById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    MemberInfoLevelChangeRecord memberInfoLevelChangeRecord = this.memberInfoLevelChangeRecordRepository.findById(id);
    MemberInfoLevelChangeRecordVo memberInfoLevelChangeRecordVo = this.nebulaToolkitService.copyObjectByWhiteList(memberInfoLevelChangeRecord, MemberInfoLevelChangeRecordVo.class, HashSet.class, LinkedList.class);
    return memberInfoLevelChangeRecordVo;
  }

  @Override
  public MemberInfoLevelChangeRecordVo findDetailByMemberCode(String memberCode) {
    if (StringUtils.isBlank(memberCode)) {
      return null;
    }
    MemberInfoLevelChangeRecord memberInfoLevelChangeRecord = memberInfoLevelChangeRecordRepository.lambdaQuery()
        .eq(MemberInfoLevelChangeRecord::getMemberCode, memberCode)
        .one();
    MemberInfoLevelChangeRecordVo memberInfoLevelChangeRecordVo = this.nebulaToolkitService.copyObjectByWhiteList(memberInfoLevelChangeRecord, MemberInfoLevelChangeRecordVo.class, HashSet.class, LinkedList.class);
    return memberInfoLevelChangeRecordVo;
  }

  @Override
  @Transactional
  public MemberInfoLevelChangeRecordVo create(MemberInfoLevelChangeRecordVo memberInfoLevelChangeRecordVo) {
    this.createValidation(memberInfoLevelChangeRecordVo);
    MemberInfoLevelChangeRecord memberInfoLevelChangeRecord = this.nebulaToolkitService.copyObjectByWhiteList(memberInfoLevelChangeRecordVo, MemberInfoLevelChangeRecord.class, HashSet.class, LinkedList.class);
    memberInfoLevelChangeRecord.setTenantCode(TenantUtils.getTenantCode());
    memberInfoLevelChangeRecord.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    memberInfoLevelChangeRecord.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    this.memberInfoLevelChangeRecordRepository.saveOrUpdate(memberInfoLevelChangeRecord);
    // 发送通知
    // TODO 发送通知
    return memberInfoLevelChangeRecordVo;
  }

  @Override
  @Transactional
  public MemberInfoLevelChangeRecordVo update(MemberInfoLevelChangeRecordVo memberInfoLevelChangeRecordVo) {
    this.updateValidation(memberInfoLevelChangeRecordVo);
    String currentId = memberInfoLevelChangeRecordVo.getId();
    MemberInfoLevelChangeRecord current = memberInfoLevelChangeRecordRepository.findById(currentId);
    current = Validate.notNull(current, "修改信息不存在");
    current = this.nebulaToolkitService.copyObjectByWhiteList(memberInfoLevelChangeRecordVo, MemberInfoLevelChangeRecord.class, HashSet.class, LinkedList.class);
    this.memberInfoLevelChangeRecordRepository.saveOrUpdate(current);
    // 发送修改通知
    // TODO 发送通知
    return memberInfoLevelChangeRecordVo;
  }

  @Override
  @Transactional
  public void enableBatch(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.memberInfoLevelChangeRecordRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
  }

  @Override
  @Transactional
  public void disableBatch(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.memberInfoLevelChangeRecordRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
  }
  
  @Override
  @Transactional
  public void updateDelFlagByIds(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.memberInfoLevelChangeRecordRepository.updateDelFlagByIds(ids);
  }

  private void createValidation(MemberInfoLevelChangeRecordVo memberInfoLevelChangeRecordVo) {
    // TODO 具体实现
    this.validation(memberInfoLevelChangeRecordVo);
  }

  private void updateValidation(MemberInfoLevelChangeRecordVo memberInfoLevelChangeRecordVo) {
    // TODO 具体实现
    this.validation(memberInfoLevelChangeRecordVo);
  }

  private void validation(MemberInfoLevelChangeRecordVo memberInfoLevelChangeRecordVo) {
    // TODO 具体实现
  }
}
