package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.local.entity.MemberInfoComeBackRecordDetail;
import com.biz.crm.member.business.member.sdk.vo.GrowRecordAPIVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoReceiptRecordDetailVo;
import com.biz.crm.member.business.member.local.entity.MemberInfoReceiptRecordDetail;
import com.biz.crm.member.business.member.local.repository.MemberInfoReceiptRecordDetailRepository;
import com.biz.crm.member.business.member.local.service.MemberInfoReceiptRecordDetailService;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoReceiptRecordDetailPaginationDto;
import com.biz.crm.member.business.member.sdk.event.MemberInfoReceiptRecordDetailEventListener;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 会员签收记录产品明细(MemberInfoReceiptRecordDetail)表服务实现类
 *
 * @author zouhs
 * @date 2023-06-28 16:55:59
 */
@Slf4j
@Service("memberInfoReceiptRecordDetailService")
public class MemberInfoReceiptRecordDetailServiceImpl implements MemberInfoReceiptRecordDetailService {
  
  @Autowired(required = false)
  private MemberInfoReceiptRecordDetailRepository memberInfoReceiptRecordDetailRepository;

  @Autowired(required = false)
  private List<MemberInfoReceiptRecordDetailEventListener> eventListeners;

  @Autowired(required = false)
  private GenerateCodeService generateCodeService;

  @Autowired
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public Page<MemberInfoReceiptRecordDetailVo> findByConditions(Pageable pageable, MemberInfoReceiptRecordDetailPaginationDto dto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    dto = Optional.ofNullable(dto).orElse(new MemberInfoReceiptRecordDetailPaginationDto());
    Page<MemberInfoReceiptRecordDetailVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.memberInfoReceiptRecordDetailRepository.findByConditions(page, dto);
  }

  @Override
  public MemberInfoReceiptRecordDetailVo findDetailById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    MemberInfoReceiptRecordDetail memberInfoReceiptRecordDetail = this.memberInfoReceiptRecordDetailRepository.findById(id);
    MemberInfoReceiptRecordDetailVo memberInfoReceiptRecordDetailVo = this.nebulaToolkitService.copyObjectByWhiteList(memberInfoReceiptRecordDetail, MemberInfoReceiptRecordDetailVo.class, HashSet.class, LinkedList.class);
    return memberInfoReceiptRecordDetailVo;
  }
  
  @Override
  @Transactional
  public MemberInfoReceiptRecordDetailVo create(MemberInfoReceiptRecordDetailVo memberInfoReceiptRecordDetailVo) {
    this.createValidation(memberInfoReceiptRecordDetailVo);
    MemberInfoReceiptRecordDetail memberInfoReceiptRecordDetail = this.nebulaToolkitService.copyObjectByWhiteList(memberInfoReceiptRecordDetailVo, MemberInfoReceiptRecordDetail.class, HashSet.class, LinkedList.class);
    memberInfoReceiptRecordDetail.setTenantCode(TenantUtils.getTenantCode());
    memberInfoReceiptRecordDetail.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    memberInfoReceiptRecordDetail.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    this.memberInfoReceiptRecordDetailRepository.saveOrUpdate(memberInfoReceiptRecordDetail);
    return memberInfoReceiptRecordDetailVo;
  }

  @Override
  @Transactional
  public MemberInfoReceiptRecordDetailVo update(MemberInfoReceiptRecordDetailVo memberInfoReceiptRecordDetailVo) {
    this.updateValidation(memberInfoReceiptRecordDetailVo);
    String currentId = memberInfoReceiptRecordDetailVo.getId();
    MemberInfoReceiptRecordDetail current = memberInfoReceiptRecordDetailRepository.findById(currentId);
    current = Validate.notNull(current, "修改信息不存在");
    current = this.nebulaToolkitService.copyObjectByWhiteList(memberInfoReceiptRecordDetailVo, MemberInfoReceiptRecordDetail.class, HashSet.class, LinkedList.class);
    this.memberInfoReceiptRecordDetailRepository.saveOrUpdate(current);
    return memberInfoReceiptRecordDetailVo;
  }

  @Override
  @Transactional
  public void enableBatch(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.memberInfoReceiptRecordDetailRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
  }

  @Override
  @Transactional
  public void disableBatch(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.memberInfoReceiptRecordDetailRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
  }
  
  @Override
  @Transactional
  public void updateDelFlagByIds(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.memberInfoReceiptRecordDetailRepository.updateDelFlagByIds(ids);
  }

  @Override
  public List<GrowRecordAPIVo> findDetailByResourceDocumentCode(String resourceDocumentCode) {
    List<GrowRecordAPIVo> result = Lists.newArrayList();
    List<MemberInfoReceiptRecordDetail> list = this.memberInfoReceiptRecordDetailRepository.lambdaQuery()
        .eq(MemberInfoReceiptRecordDetail::getReceiptCode, resourceDocumentCode)
        .list();
    if(CollectionUtils.isNotEmpty(list)){
      GrowRecordAPIVo growRecordAPIVo;
      for (MemberInfoReceiptRecordDetail memberInfoReceiptRecordDetail : list) {
        growRecordAPIVo = new GrowRecordAPIVo();
        growRecordAPIVo.setNum(memberInfoReceiptRecordDetail.getNum());
        growRecordAPIVo.setProductName(memberInfoReceiptRecordDetail.getProductName());
        result.add(growRecordAPIVo);
      }
    }
    return result;
  }

  @Override
  @Transactional
  public void batchSave(List<MemberInfoReceiptRecordDetailVo> list) {
    for (MemberInfoReceiptRecordDetailVo memberInfoReceiptRecordDetailVo : list) {
      this.create(memberInfoReceiptRecordDetailVo);
    }
  }

  private void createValidation(MemberInfoReceiptRecordDetailVo memberInfoReceiptRecordDetailVo) {
    this.validation(memberInfoReceiptRecordDetailVo);
  }

  private void updateValidation(MemberInfoReceiptRecordDetailVo memberInfoReceiptRecordDetailVo) {
    this.validation(memberInfoReceiptRecordDetailVo);
  }

  private void validation(MemberInfoReceiptRecordDetailVo memberInfoReceiptRecordDetailVo) {
    Validate.notBlank(memberInfoReceiptRecordDetailVo.getReceiptCode(), "单据流水号不能为空");
    Validate.notBlank(memberInfoReceiptRecordDetailVo.getProductCode(), "产品编码不能为空");
    Validate.notBlank(memberInfoReceiptRecordDetailVo.getProductName(), "产品名称不能为空");
    Validate.notNull(memberInfoReceiptRecordDetailVo.getNum(), "数量不能为空");

  }
}
