package com.biz.crm.member.business.member.local.service.internal;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.RandomUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.member.business.member.local.entity.LevelManage;
import com.biz.crm.member.business.member.local.entity.MemberInfo;
import com.biz.crm.member.business.member.local.entity.MemberInfoArchives;
import com.biz.crm.member.business.member.local.entity.MemberInfoAssets;
import com.biz.crm.member.business.member.local.entity.MemberInfoContact;
import com.biz.crm.member.business.member.local.entity.MemberInfoLevelChangeRecord;
import com.biz.crm.member.business.member.local.entity.MemberInfoSupply;
import com.biz.crm.member.business.member.local.helper.UserSearchHelper;
import com.biz.crm.member.business.member.local.repository.MemberInfoArchivesRepository;
import com.biz.crm.member.business.member.local.repository.MemberInfoAssetsRepository;
import com.biz.crm.member.business.member.local.repository.MemberInfoContactRepository;
import com.biz.crm.member.business.member.local.repository.MemberInfoGrowRecordRepository;
import com.biz.crm.member.business.member.local.repository.MemberInfoIntegralRecordRepository;
import com.biz.crm.member.business.member.local.repository.MemberInfoLevelChangeRecordRepository;
import com.biz.crm.member.business.member.local.repository.MemberInfoRepository;
import com.biz.crm.member.business.member.local.repository.MemberInfoSupplyRepository;
import com.biz.crm.member.business.member.local.service.AppletPopupNotifyService;
import com.biz.crm.member.business.member.local.service.LevelManageService;
import com.biz.crm.member.business.member.local.service.MemberInfoGrowRecordService;
import com.biz.crm.member.business.member.local.service.MemberInfoIntegralRecordService;
import com.biz.crm.member.business.member.local.service.MemberInfoService;
import com.biz.crm.member.business.member.local.service.SystemSettingsDetailService;
import com.biz.crm.member.business.member.local.service.TastingConsultantService;
import com.biz.crm.member.business.member.local.utils.AssertUtils;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoPaginationDto;
import com.biz.crm.member.business.member.sdk.enums.MemberApprovalStatusEnum;
import com.biz.crm.member.business.member.sdk.enums.SystemSettingsDetailEnum;
import com.biz.crm.member.business.member.sdk.enums.TriggerConditionEnum;
import com.biz.crm.member.business.member.sdk.enums.TriggerTypeEnum;
import com.biz.crm.member.business.member.sdk.event.MemberInfoEventListener;
import com.biz.crm.member.business.member.sdk.vo.LevelManageVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoAllVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoAssetsVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoContactVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoGrowRecordVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoIntegralRecordVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoLevelChangeRecordVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoSupplyVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoVo;
import com.biz.crm.member.business.member.sdk.vo.MemberLoginVo;
import com.biz.crm.member.business.member.sdk.vo.PersonalCenterAPIVo;
import com.biz.crm.member.business.member.sdk.vo.TastingConsultantVo;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletMemberBaseInfoVo;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletMemberHoneVo;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletMemberInfoReqVo;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletMemberInfoVo;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletPopupNotifyVo;
import com.biz.crm.member.business.member.sdk.vo.login.MemberUserDetails;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 会员信息(MemberInfo)表服务实现类
 *
 * @author zouhs
 * @date 2023-06-19 14:31:58
 */
@Slf4j
@Service("memberInfoService")
public class MemberInfoServiceImpl implements MemberInfoService {

  @Autowired(required = false)
  private MemberInfoRepository memberInfoRepository;

  @Autowired
  private AppletPopupNotifyService appletPopupNotifyService;

  @Autowired
  private MemberInfoArchivesRepository memberInfoArchivesRepository;

  @Autowired
  private MemberInfoContactRepository memberInfoContactRepository;

  @Autowired
  private MemberInfoSupplyRepository memberInfoSupplyRepository;

  @Autowired
  private MemberInfoAssetsRepository memberInfoAssetsRepository;

  @Autowired
  private MemberInfoLevelChangeRecordRepository memberInfoLevelChangeRecordRepository;

  @Autowired
  private MemberInfoIntegralRecordRepository memberInfoIntegralRecordRepository;

  @Autowired
  private MemberInfoIntegralRecordService memberInfoIntegralRecordService;

  @Autowired
  private MemberInfoGrowRecordRepository memberInfoGrowRecordRepository;

  @Autowired
  private MemberInfoGrowRecordService memberInfoGrowRecordService;

  @Autowired(required = false)
  private List<MemberInfoEventListener> eventListeners;

  @Autowired(required = false)
  private GenerateCodeService generateCodeService;

  @Autowired
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Autowired
  private LoginUserService loginUserService;

  @Autowired
  private UserSearchHelper userSearchHelper;

  @Autowired
  private LevelManageService levelManageService;

  @Autowired
  private SystemSettingsDetailService systemSettingsDetailService;

  @Autowired
  private TastingConsultantService tastingConsultantService;

  @Override
  public Page<MemberInfoVo> findByConditions(Pageable pageable, MemberInfoPaginationDto dto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    dto = Optional.ofNullable(dto).orElse(new MemberInfoPaginationDto());
    Page<MemberInfoVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.memberInfoRepository.findByConditions(page, dto);
  }

  @Override
  public MemberInfoVo findDetailById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    MemberInfo memberInfo = this.memberInfoRepository.findById(id);
    MemberInfoVo memberInfoVo = this.nebulaToolkitService
        .copyObjectByWhiteList(memberInfo, MemberInfoVo.class, HashSet.class, LinkedList.class);
    return memberInfoVo;
  }

  @Override
  public MemberInfoVo findDetailByMemberCode(String memberCode) {
    if (StringUtils.isBlank(memberCode)) {
      return null;
    }
    MemberInfo memberInfo = this.memberInfoRepository.lambdaQuery()
        .eq(MemberInfo::getMemberCode, memberCode).one();
    MemberInfoVo memberInfoVo = this.nebulaToolkitService
        .copyObjectByWhiteList(memberInfo, MemberInfoVo.class, HashSet.class, LinkedList.class);
    return memberInfoVo;
  }

  @Override
  public AppletMemberBaseInfoVo findBaseInfoByMemberCode(String memberCode) {
    AppletMemberBaseInfoVo memberBaseInfoVo = new AppletMemberBaseInfoVo();
    MemberInfo memberInfo = this.memberInfoRepository.lambdaQuery()
        .eq(MemberInfo::getMemberCode, memberCode).one();
    memberBaseInfoVo.setMemberAvatar(memberInfo.getMemberAvatar());
    memberBaseInfoVo.setMemberName(memberInfo.getMemberName());
    memberBaseInfoVo.setMemberPhone(memberInfo.getMemberPhone());
    memberBaseInfoVo.setMemberBirthday(memberInfo.getMemberBirthday());
    return memberBaseInfoVo;
  }

  @Override
  @Transactional
  public MemberInfoVo create(MemberInfoVo memberInfoVo) {
    this.createValidation(memberInfoVo);
    MemberInfo memberInfo = this.nebulaToolkitService
        .copyObjectByWhiteList(memberInfoVo, MemberInfo.class, HashSet.class, LinkedList.class);
    memberInfo.setTenantCode(TenantUtils.getTenantCode());
    memberInfo.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    memberInfo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    this.memberInfoRepository.saveOrUpdate(memberInfo);
    // 发送通知
    // TODO 发送通知
    return memberInfoVo;
  }

  @Override
  @Transactional
  public MemberInfoVo update(MemberInfoVo memberInfoVo) {
    this.updateValidation(memberInfoVo);
    String currentId = memberInfoVo.getId();
    MemberInfo current = memberInfoRepository.findById(currentId);
    current = Validate.notNull(current, "修改信息不存在");
    current = this.nebulaToolkitService
        .copyObjectByWhiteList(memberInfoVo, MemberInfo.class, HashSet.class, LinkedList.class);
    this.memberInfoRepository.saveOrUpdate(current);
    // 发送修改通知
    // TODO 发送通知
    return memberInfoVo;
  }

  @Override
  public AppletMemberBaseInfoVo updateBase(AppletMemberBaseInfoVo appletMemberBaseInfoVo) {
    MemberInfo memberInfo = this.memberInfoRepository.lambdaQuery()
        .eq(MemberInfo::getMemberCode, userSearchHelper.getMemberLogin().getMemberCode())
        .one();
    Validate.notNull(memberInfo, "会员不存在");
    if (appletMemberBaseInfoVo.getMemberBirthday() != null) {
      if (memberInfo.getMemberBirthday() != null) {
        Validate.notBlank(null, "会员生日不可修改，只可新增");
      }
      memberInfo.setMemberBirthday(appletMemberBaseInfoVo.getMemberBirthday());
    }
    if (appletMemberBaseInfoVo.getMemberAvatar() != null) {
      memberInfo.setMemberAvatar(appletMemberBaseInfoVo.getMemberAvatar());
    }
    if (appletMemberBaseInfoVo.getMemberNick() != null) {
      memberInfo.setMemberNick(appletMemberBaseInfoVo.getMemberNick());
    }
    if (appletMemberBaseInfoVo.getMemberPhone() != null) {
      memberInfo.setMemberPhone(appletMemberBaseInfoVo.getMemberPhone());
    }
    this.memberInfoRepository.saveOrUpdate(memberInfo);
    return appletMemberBaseInfoVo;
  }

  @Override
  @Transactional
  public void enableBatch(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.memberInfoRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
  }

  @Override
  @Transactional
  public void disableBatch(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.memberInfoRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
  }

  @Override
  @Transactional
  public void updateDelFlagByIds(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.memberInfoRepository.updateDelFlagByIds(ids);
  }

  @Override
  public void approvalPass(MemberInfoVo memberInfoVo) {
    Validate.notBlank(memberInfoVo.getId(), "会员ID不能为空");
    MemberInfo memberInfo = this.memberInfoRepository.findById(memberInfoVo.getId());
    Validate.notNull(memberInfo, "会员不存在");
    Validate.isTrue(
        Objects.equals(MemberApprovalStatusEnum.STAY.getValue(), memberInfo.getApprovalStatus()),
        "请选择未审批的会员");
    AbstractCrmUserIdentity abstractLoginUser = loginUserService.getAbstractLoginUser();
    memberInfo.setApprovalCode(abstractLoginUser.getUsername());
    memberInfo.setApprovalName(abstractLoginUser.getRealName());
    memberInfo.setApprovalStatus(MemberApprovalStatusEnum.PASS.getValue());
    memberInfo.setApprovalDate(new Date());
    this.memberInfoRepository.updateById(memberInfo);
  }

  @Override
  public void approvalReject(MemberInfoVo memberInfoVo) {
    Validate.notBlank(memberInfoVo.getId(), "会员ID不能为空");
    Validate.notBlank(memberInfoVo.getApprovalRejectDesc(), "驳回原因不能为空");
    MemberInfo memberInfo = this.memberInfoRepository.findById(memberInfoVo.getId());
    Validate.notNull(memberInfo, "会员不存在");
    Validate.isTrue(
        Objects.equals(MemberApprovalStatusEnum.STAY.getValue(), memberInfo.getApprovalStatus()),
        "请选择未审批的会员");
    AbstractCrmUserIdentity abstractLoginUser = loginUserService.getAbstractLoginUser();
    memberInfo.setApprovalCode(abstractLoginUser.getUsername());
    memberInfo.setApprovalName(abstractLoginUser.getRealName());
    memberInfo.setApprovalStatus(MemberApprovalStatusEnum.REJECT.getValue());
    memberInfo.setApprovalDate(new Date());
    memberInfo.setApprovalRejectDesc(memberInfoVo.getApprovalRejectDesc());
    this.memberInfoRepository.updateById(memberInfo);
  }

  @Override
  public void maintainIndustry(MemberInfoVo memberInfoVo) {
    Validate.notBlank(memberInfoVo.getId(), "会员ID不能为空");
    Validate.notBlank(memberInfoVo.getIndustryCode(), "请选择行业");
    Validate.notBlank(memberInfoVo.getIndustryName(), "请选择行业");
    MemberInfo memberInfo = this.memberInfoRepository.findById(memberInfoVo.getId());
    Validate.notNull(memberInfo, "会员不存在");
    memberInfo.setIndustryCode(memberInfoVo.getIndustryCode());
    memberInfo.setIndustryName(memberInfoVo.getIndustryName());
    this.memberInfoRepository.updateById(memberInfo);
  }

  @Override
  public void maintainDepartment(MemberInfoVo memberInfoVo) {
    Validate.notBlank(memberInfoVo.getId(), "会员ID不能为空");
    Validate.notBlank(memberInfoVo.getDepartment(), "部门不能为空");
    MemberInfo memberInfo = this.memberInfoRepository.findById(memberInfoVo.getId());
    Validate.notNull(memberInfo, "会员不存在");
    memberInfo.setDepartment(memberInfoVo.getDepartment());
    this.memberInfoRepository.updateById(memberInfo);
  }

  @Override
  public MemberInfoAllVo findAllDetailById(String id) {
    Validate.notBlank(id, "会员ID不能为空");
    MemberInfo memberInfo = this.memberInfoRepository.findById(id);
    Validate.notNull(memberInfo, "会员不存在");
    MemberInfoAllVo memberInfoAllVo = this.nebulaToolkitService
        .copyObjectByWhiteList(memberInfo, MemberInfoAllVo.class, HashSet.class, LinkedList.class);
    MemberInfoArchives memberInfoArchives = this.memberInfoArchivesRepository.lambdaQuery()
        .eq(MemberInfoArchives::getMemberCode, memberInfo.getMemberCode()).one();
    if (memberInfoArchives != null) {
      memberInfoAllVo = this.nebulaToolkitService
          .copyObjectByWhiteList(memberInfoArchives, MemberInfoAllVo.class, HashSet.class,
              LinkedList.class);
      // 查询关联的业务员
      List<MemberInfoContact> memberInfoContactList = memberInfoContactRepository.lambdaQuery()
          .eq(MemberInfoContact::getTerminalCode, memberInfoArchives.getTerminalCode()).list();
      if (CollectionUtils.isNotEmpty(memberInfoContactList)) {
        memberInfoAllVo
            .setMemberInfoContactVoList((List<MemberInfoContactVo>) this.nebulaToolkitService
                .copyCollectionByWhiteList(memberInfoContactList, MemberInfoContact.class,
                    MemberInfoContactVo.class, HashSet.class,
                    ArrayList.class));
      }
      // 查询采供关系
      List<MemberInfoSupply> memberInfoSupplyList = memberInfoSupplyRepository.lambdaQuery()
          .eq(MemberInfoSupply::getTerminalCode, memberInfoArchives.getTerminalCode()).list();
      if (CollectionUtils.isNotEmpty(memberInfoSupplyList)) {
        memberInfoAllVo
            .setMemberInfoSupplyVoList((List<MemberInfoSupplyVo>) this.nebulaToolkitService
                .copyCollectionByWhiteList(memberInfoSupplyList, MemberInfoSupply.class,
                    MemberInfoSupplyVo.class, HashSet.class,
                    ArrayList.class));
      }
    }
    return memberInfoAllVo;
  }

  @Override
  public MemberInfoAssetsVo findAssetsDetailById(String id) {
    Validate.notBlank(id, "会员ID不能为空");
    MemberInfo memberInfo = this.memberInfoRepository.findById(id);
    Validate.notNull(memberInfo, "会员不存在");
    MemberInfoAssets memberInfoAssets = memberInfoAssetsRepository.lambdaQuery()
        .eq(MemberInfoAssets::getMemberCode, memberInfo.getMemberCode()).one();
    Validate.notNull(memberInfoAssets, "会员资产不存在");
    MemberInfoAssetsVo memberInfoAssetsVo = this.nebulaToolkitService
        .copyObjectByWhiteList(memberInfoAssets, MemberInfoAssetsVo.class, HashSet.class,
            LinkedList.class);
    List<MemberInfoLevelChangeRecord> list = memberInfoLevelChangeRecordRepository.lambdaQuery()
        .eq(MemberInfoLevelChangeRecord::getMemberCode, memberInfo.getMemberCode()).orderByDesc(
            UuidOpEntity::getCreateTime).list();
    if (CollectionUtils.isNotEmpty(list)) {
      memberInfoAssetsVo.setList((List<MemberInfoLevelChangeRecordVo>) this.nebulaToolkitService
          .copyCollectionByWhiteList(list, MemberInfoLevelChangeRecord.class,
              MemberInfoLevelChangeRecordVo.class, HashSet.class, LinkedList.class));
    }

    return memberInfoAssetsVo;
  }

  @Override
  @Transactional
  public void updateIntegral(MemberInfoIntegralRecordVo memberInfoIntegralRecordVo) {
    Validate.notNull(memberInfoIntegralRecordVo, "入参不能为空");
    Validate.notNull(memberInfoIntegralRecordVo.getIntegral(), "积分不能为空");
    Validate.notBlank(memberInfoIntegralRecordVo.getMemberId(), "会员ID不能为空");
    MemberInfo memberInfo = this.memberInfoRepository
        .findById(memberInfoIntegralRecordVo.getMemberId());
    Validate.notNull(memberInfo, "会员不存在");
    MemberInfoAssets memberInfoAssets = memberInfoAssetsRepository.lambdaQuery()
        .eq(MemberInfoAssets::getMemberCode, memberInfo.getMemberCode()).one();
    Validate.notNull(memberInfoAssets, "会员资产不存在");

    // 新增记录
    memberInfoIntegralRecordVo.setMemberCode(memberInfo.getMemberCode());
    memberInfoIntegralRecordVo.setOptTime(new Date());
    memberInfoIntegralRecordVo.setBeforeIntegral(memberInfoAssets.getTotalIntegral());
    memberInfoIntegralRecordVo.setAfterIntegral(
        memberInfoAssets.getTotalIntegral() + memberInfoIntegralRecordVo.getIntegral());
    memberInfoIntegralRecordVo.setIntegralCode(generateCodeService.generateCode("JF", 5).get(0));
    memberInfoIntegralRecordVo.setSource("系统后台");
    this.memberInfoIntegralRecordService.create(memberInfoIntegralRecordVo);

    // 变更主表 - 将就用着吧这里会存在积分唯一性问题。以流水记录为准
    memberInfoAssets.setTotalIntegral(
        memberInfoAssets.getTotalIntegral() + memberInfoIntegralRecordVo.getIntegral());
    memberInfoAssets.setCurrentIntegral(
        memberInfoAssets.getCurrentIntegral() + memberInfoIntegralRecordVo.getIntegral());
    this.memberInfoAssetsRepository.updateById(memberInfoAssets);
  }

  @Override
  @Transactional
  public void updateGrow(MemberInfoGrowRecordVo memberInfoGrowRecordVo) {
    Validate.notNull(memberInfoGrowRecordVo, "入参不能为空");
    Validate.notNull(memberInfoGrowRecordVo.getGrow(), "成长值不能为空");
    Validate.notBlank(memberInfoGrowRecordVo.getMemberId(), "会员ID不能为空");
    MemberInfo memberInfo = this.memberInfoRepository
        .findById(memberInfoGrowRecordVo.getMemberId());
    Validate.notNull(memberInfo, "会员不存在");
    MemberInfoAssets memberInfoAssets = memberInfoAssetsRepository.lambdaQuery()
        .eq(MemberInfoAssets::getMemberCode, memberInfo.getMemberCode()).one();
    Validate.notNull(memberInfoAssets, "会员资产不存在");

    // 新增记录
    memberInfoGrowRecordVo.setMemberCode(memberInfo.getMemberCode());
    memberInfoGrowRecordVo.setOptTime(new Date());
    memberInfoGrowRecordVo.setBeforeGrow(memberInfoAssets.getTotalGrow());
    memberInfoGrowRecordVo
        .setAfterGrow(memberInfoAssets.getTotalGrow() + memberInfoGrowRecordVo.getGrow());
    memberInfoGrowRecordVo.setGrowCode(generateCodeService.generateCode("CZZ", 5).get(0));
    memberInfoGrowRecordVo.setSource("系统后台");
    this.memberInfoGrowRecordService.create(memberInfoGrowRecordVo);

    // 变更主表 - 将就用着吧这里会存在成长值唯一性问题。以流水记录为准
    memberInfoAssets
        .setTotalGrow(memberInfoAssets.getTotalGrow() + memberInfoGrowRecordVo.getGrow());
    memberInfoAssets
        .setCurrentGrow(memberInfoAssets.getCurrentGrow() + memberInfoGrowRecordVo.getGrow());
    this.memberInfoAssetsRepository.updateById(memberInfoAssets);
  }

  @Override
  public MemberLoginVo queryMemberInfo(String phone) {
    MemberLoginVo memberLoginVo = null;
    MemberInfo memberInfo = this.memberInfoRepository.lambdaQuery()
        .eq(MemberInfo::getMemberPhone, phone)
        .one();
    if (memberInfo != null) {
      memberLoginVo = new MemberLoginVo();
      memberLoginVo.setMemberCode(memberInfo.getMemberCode());
      memberLoginVo.setMemberPhone(memberInfo.getMemberPhone());
      memberLoginVo.setMemberName(memberInfo.getMemberName());
      memberLoginVo.setMemberNick(memberInfo.getMemberNick());
      memberLoginVo.setMemberBirthday(memberInfo.getMemberBirthday());
      memberLoginVo.setUserType(memberInfo.getUserType());
    }
    return memberLoginVo;
  }

  @Override
  public MemberLoginVo createVisitorMember(String phone) {
    MemberInfo memberInfo = new MemberInfo();
    memberInfo.setUserType("2");
    memberInfo.setMemberCode(generateCodeService.generateCode("YK", 5).get(0));
    memberInfo.setMemberPhone(phone);
    memberInfo.setMemberName("游客" + RandomUtil.randomNumbers(5));
    memberInfo.setMemberNick(memberInfo.getMemberName());
    memberInfo.setTenantCode(TenantUtils.getTenantCode());
    memberInfo.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    memberInfo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    memberInfo.setMemberRegister(new Date());
    this.memberInfoRepository.save(memberInfo);
    MemberLoginVo memberLoginVo = new MemberLoginVo();
    memberLoginVo.setUserType(memberInfo.getUserType());
    memberLoginVo.setMemberCode(memberInfo.getMemberCode());
    memberLoginVo.setMemberPhone(memberInfo.getMemberPhone());
    return memberLoginVo;
  }

  @Override
  public PersonalCenterAPIVo queryMemberAssociationInfo() {
    PersonalCenterAPIVo personalCenterAPIVo = new PersonalCenterAPIVo();
    MemberUserDetails memberLogin = userSearchHelper.getMemberLogin();
    Validate.notNull(memberLogin.getMemberCode(), "会员信息为空");
    //查询关联业务员信息
    List<MemberInfoContact> list = memberInfoContactRepository.lambdaQuery()
        .eq(MemberInfoContact::getMemberCode, memberLogin.getMemberCode())
        .list();
    //如果集合不为空,则取得第一个业务员手机号
    if (CollectionUtils.isNotEmpty(list)) {
      MemberInfoContact memberInfoContact = list.get(0);
      personalCenterAPIVo.setWineHotline(memberInfoContact.getContactPhone());
    }
    //查询品鉴顾问的手机号以及头像信息
    MemberInfo memberInfo = memberInfoRepository.lambdaQuery()
        .eq(MemberInfo::getMemberCode, memberLogin.getMemberCode())
        .one();
    memberInfo = Optional.ofNullable(memberInfo).orElse(new MemberInfo());
    personalCenterAPIVo.setTastingAdvisor(memberInfo.getLinkTastingPhone());
    personalCenterAPIVo.setMemberCode(memberLogin.getMemberCode());
    return personalCenterAPIVo;
  }

  @Override
  public PersonalCenterAPIVo queryMemberAssociationInfoCard() {
    PersonalCenterAPIVo personalCenterAPIVo = new PersonalCenterAPIVo();
    MemberUserDetails memberLogin = userSearchHelper.getMemberLogin();
    Validate.notNull(memberLogin.getMemberCode(), "会员信息为空");
    //查询会员手机号以及头像信息
    MemberInfo memberInfo = memberInfoRepository.lambdaQuery()
        .eq(MemberInfo::getMemberCode, memberLogin.getMemberCode())
        .one();
    memberInfo = Optional.ofNullable(memberInfo).orElse(new MemberInfo());
    personalCenterAPIVo.setMemberName(memberInfo.getMemberName());
    personalCenterAPIVo.setMemberAvatar(memberInfo.getMemberAvatar());
    personalCenterAPIVo.setMemberCode(memberLogin.getMemberCode());
    return personalCenterAPIVo;
  }

  @Override
  public AppletMemberInfoVo getMemberInfo(String memberCode) {
    MemberInfo memberInfo = this.memberInfoRepository.lambdaQuery()
        .eq(MemberInfo::getMemberCode, memberCode).one();
    Validate.notNull(memberInfo, "会员不存在");
    AppletMemberInfoVo appletMemberInfoVo = new AppletMemberInfoVo();
    BeanUtils.copyProperties(memberInfo, appletMemberInfoVo);
    // 查询等级
    MemberInfoAssets memberInfoAssets = this.memberInfoAssetsRepository.lambdaQuery()
        .eq(MemberInfoAssets::getMemberCode, memberCode).one();
    if (memberInfoAssets != null) {
      appletMemberInfoVo.setLevelCode(memberInfoAssets.getLevelCode());
      appletMemberInfoVo.setLevelName(memberInfoAssets.getLevelName());
    }
    if (StringUtils.isBlank(memberInfo.getMemberBirthday())) {
      Date date = DateUtil.offsetHour(memberInfo.getMemberRegister(), 1);
      if (date.after(new Date())) {
        appletMemberInfoVo.setFirstLogin(true);
      }
    }
    return appletMemberInfoVo;
  }

  @Override
  public void updMemberBirthday(AppletMemberInfoReqVo appletMemberInfoReqVo) {
    MemberInfo memberInfo = this.memberInfoRepository.lambdaQuery()
        .eq(MemberInfo::getMemberCode, appletMemberInfoReqVo.getMemberCode()).one();
    Validate.notNull(memberInfo, "会员不存在");
    if (StringUtils.isBlank(memberInfo.getMemberBirthday())) {
      memberInfo.setMemberBirthday(appletMemberInfoReqVo.getMemberBirthday());
      this.memberInfoRepository.updateById(memberInfo);
    } else {
      Validate.isTrue(false, "生日不允许二次修改");
    }
  }

  @Override
  public AppletMemberHoneVo getMemberHome(String memberCode) {
    AppletMemberHoneVo appletMemberHoneVo = new AppletMemberHoneVo();
    MemberInfo memberInfo = this.memberInfoRepository.lambdaQuery()
        .eq(MemberInfo::getMemberCode, memberCode).one();
    Validate.notNull(memberInfo, "会员不存在");
    appletMemberHoneVo.setMemberCode(memberInfo.getMemberCode());
    appletMemberHoneVo.setMemberNick(memberInfo.getMemberNick());
    appletMemberHoneVo.setMemberName(memberInfo.getMemberName());
    appletMemberHoneVo.setMemberAvatar(memberInfo.getMemberAvatar());
    appletMemberHoneVo.setMemberBirthday(memberInfo.getMemberBirthday());
    // 查询资产
    MemberInfoAssets memberInfoAssets = this.memberInfoAssetsRepository.lambdaQuery()
        .eq(MemberInfoAssets::getMemberCode, memberCode).one();
    Validate.notNull(memberInfoAssets, "会员资产不存在");
    appletMemberHoneVo.setCurrentIntegral(memberInfoAssets.getCurrentIntegral());
    appletMemberHoneVo.setCurrentGrow(memberInfoAssets.getCurrentGrow());
    appletMemberHoneVo.setLevelCode(memberInfoAssets.getLevelCode());
    appletMemberHoneVo.setLevelName(memberInfoAssets.getLevelName());
    appletMemberHoneVo.setStayBenefitsNum(memberInfoAssets.getStayBenefitsNum());
    appletMemberHoneVo.setBigWheelPrizes(memberInfoAssets.getBigWheelPrizes());
    // 查询等级
    LevelManageVo levelManageVo = levelManageService
        .findDetailByLevelCode(memberInfoAssets.getLevelCode());
    appletMemberHoneVo.setGrowStart(levelManageVo.getGrowStart());
    appletMemberHoneVo.setGrowEnd(levelManageVo.getGrowEnd());
    appletMemberHoneVo.setCardImageOne(levelManageVo.getCardImageOne());
    appletMemberHoneVo.setCardImageTwo(levelManageVo.getCardImageTwo());
    LevelManageVo nextLevelMangeVo = levelManageService.nextLevelManage(levelManageVo);
    if (nextLevelMangeVo != null) {
      appletMemberHoneVo.setNextLevelName(nextLevelMangeVo.getLevelName());
    }
    // 查询是否是品鉴顾问
    TastingConsultantVo tastingConsultantVo = tastingConsultantService
        .queryFlagTastingByPhone(memberInfo.getMemberPhone());
    if (tastingConsultantVo != null) {
      appletMemberHoneVo.setTastingCode(tastingConsultantVo.getCode());
      appletMemberHoneVo.setTastingName("品鉴顾问");
      appletMemberHoneVo.setTastingPhone(tastingConsultantVo.getPhone());
      // 获取品鉴顾问的卡片
      String typeValue = systemSettingsDetailService
          .findValueByKey(SystemSettingsDetailEnum.CARD_IMAGE.getValue()).getTypeValue();
      appletMemberHoneVo.setLinkTastingCard(typeValue);
    }
    appletMemberHoneVo.setMemberLevelExpires("2099-01-10");
    // TODO 这里需要判断品鉴顾问的权益是否发放

    return appletMemberHoneVo;
  }

  @Override
  public AppletMemberHoneVo getMemberLevelInfo(String memberCode) {
    AppletMemberHoneVo appletMemberHoneVo = new AppletMemberHoneVo();
    MemberInfo memberInfo = this.memberInfoRepository.lambdaQuery()
        .eq(MemberInfo::getMemberCode, memberCode).one();
    Validate.notNull(memberInfo, "会员不存在");
    appletMemberHoneVo.setMemberCode(memberInfo.getMemberCode());
    // 查询资产
    MemberInfoAssets memberInfoAssets = this.memberInfoAssetsRepository.lambdaQuery()
        .eq(MemberInfoAssets::getMemberCode, memberCode).one();
    Validate.notNull(memberInfoAssets, "会员资产不存在");
    appletMemberHoneVo.setCurrentIntegral(memberInfoAssets.getCurrentIntegral());
    appletMemberHoneVo.setCurrentGrow(memberInfoAssets.getCurrentGrow());
    appletMemberHoneVo.setLevelCode(memberInfoAssets.getLevelCode());
    appletMemberHoneVo.setLevelName(memberInfoAssets.getLevelName());
    // 查询等级
    LevelManageVo levelManageVo = levelManageService
        .findDetailByLevelCode(memberInfoAssets.getLevelCode());
    appletMemberHoneVo.setGrowStart(levelManageVo.getGrowStart());
    appletMemberHoneVo.setGrowEnd(levelManageVo.getGrowEnd());
    appletMemberHoneVo.setCardImageOne(levelManageVo.getCardImageOne());
    appletMemberHoneVo.setCardImageTwo(levelManageVo.getCardImageTwo());
    LevelManageVo nextLevelMangeVo = levelManageService.nextLevelManage(levelManageVo);
    if (nextLevelMangeVo != null) {
      appletMemberHoneVo.setNextLevelName(nextLevelMangeVo.getLevelName());
    }
    appletMemberHoneVo.setMemberLevelExpires("2099-01-10");
    // 查询升级规则
    String typeValueText = systemSettingsDetailService
        .findValueByKey(SystemSettingsDetailEnum.UPGRADE_RULE_DESC.getValue()).getTypeValueText();
    appletMemberHoneVo.setLevelRule(typeValueText);
    return appletMemberHoneVo;
  }

  @Override
  @DynamicTaskService(cornExpression = "0 0 0 1/1 * ?", taskDesc = "每天0点向弹窗表推送一次生日弹窗")
  public void addPopupNotify(){
    String memberCode = userSearchHelper.getMemberLogin().getMemberCode();
    MemberInfo memberInfo = memberInfoRepository.lambdaQuery()
        .eq(MemberInfo::getMemberCode, memberCode)
        .one();
    String memberBirthday = memberInfo.getMemberBirthday();
    if (memberBirthday!=null){
//      SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
//      SimpleDateFormat timeFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
      AppletPopupNotifyVo currentApplet = new AppletPopupNotifyVo();
      AppletPopupNotifyVo beforeApplet = new AppletPopupNotifyVo();
      //获取当前日期
      Calendar calendarCurrent = Calendar.getInstance();
      calendarCurrent.set(Calendar.HOUR_OF_DAY, 0);
      calendarCurrent.set(Calendar.MINUTE, 0);
      calendarCurrent.set(Calendar.SECOND, 0);
      calendarCurrent.set(Calendar.MILLISECOND, 0);
      Date currentDate = calendarCurrent.getTime();
      //获取会员当天的生日的日期以及前10天的日期
//      Date birthday = dateFormat.parse(memberBirthday);
      Date birthday = DateUtil.parse(memberBirthday);
      Calendar calendar = Calendar.getInstance();
      calendar.setTime(birthday);
      calendar.add(Calendar.DAY_OF_YEAR,-10);
      Date birthdayBefore = calendar.getTime();
      //如果当前日期是生日,添加弹窗
      if (isSameDay(currentDate,birthday)){
        currentApplet.setEndTime(getTargetTime(birthday));
        currentApplet.setMemberCode(memberCode);
        currentApplet.setTriggerType(TriggerTypeEnum.BIRTHDAY.getCode());
        currentApplet.setTriggerConditions(TriggerConditionEnum.BIRTHDAY_DAY.getCode());
        appletPopupNotifyService.addOne(currentApplet);
      }
      //如果当前日期是生日前10天,添加弹窗
      if (isSameDay(currentDate,birthdayBefore)){
        beforeApplet.setEndTime(getTargetTime(birthdayBefore));
        beforeApplet.setMemberCode(memberCode);
        beforeApplet.setTriggerType(TriggerTypeEnum.BIRTHDAY.getCode());
        beforeApplet.setTriggerConditions(TriggerConditionEnum.BIRTHDAY_10.getCode());
        appletPopupNotifyService.addOne(beforeApplet);
      }
    }
  }

  private void createValidation(MemberInfoVo memberInfoVo) {
    this.validation(memberInfoVo);
  }

  private void updateValidation(MemberInfoVo memberInfoVo) {
    this.validation(memberInfoVo);
  }

  private void validation(MemberInfoVo memberInfoVo) {
  }

  //判断是不是同一天,忽略年份
  private static boolean isSameDay(Date date1, Date date2) {
    Calendar calendar1 = Calendar.getInstance();
    calendar1.setTime(date1);
    Calendar calendar2 = Calendar.getInstance();
    calendar2.setTime(date2);
    return calendar1.get(Calendar.MONTH) == calendar2.get(Calendar.MONTH) &&
        calendar1.get(Calendar.DAY_OF_MONTH) == calendar2.get(Calendar.DAY_OF_MONTH);
  }
  //获取指定日期的晚上23:53:00的时间
  private static Date getTargetTime(Date specifiedDate) {
    Calendar calendar = Calendar.getInstance();
    calendar.setTime(specifiedDate);
    calendar.set(Calendar.HOUR_OF_DAY, 23);
    calendar.set(Calendar.MINUTE, 53);
    calendar.set(Calendar.SECOND, 0);
    calendar.set(Calendar.MILLISECOND, 0);
    return calendar.getTime();
  }
}
