package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.local.repository.MemberInviteRecordRepository;
import com.biz.crm.member.business.member.local.service.MemberInviteRecordService;
import com.biz.crm.member.business.member.sdk.dto.BenefitsManagePaginationDto;
import com.biz.crm.member.business.member.sdk.dto.MemberInviteRecordPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.BenefitsManageVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInviteRecordVo;
import java.util.Optional;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/**
 * @author hupan
 * @date 2023/6/29 16:18
 */
@Slf4j
@Service("memberInviteRecordServiceImpl")
public class MemberInviteRecordServiceImpl implements MemberInviteRecordService {

  @Autowired
  private MemberInviteRecordRepository memberInviteRecordRepository;

  @Override
  public Page<MemberInviteRecordVo> findByConditions(Pageable pageable,
      MemberInviteRecordPaginationDto dto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    dto = Optional.ofNullable(dto).orElse(new MemberInviteRecordPaginationDto());
    Page<MemberInviteRecordVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.memberInviteRecordRepository.findByConditions(page, dto);
  }
}
