package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.local.entity.MessageManage;
import com.biz.crm.member.business.member.local.entity.MessageNotify;
import com.biz.crm.member.business.member.local.helper.UserSearchHelper;
import com.biz.crm.member.business.member.local.repository.MessageManageRepository;
import com.biz.crm.member.business.member.local.repository.MessageNotifyRepository;
import com.biz.crm.member.business.member.local.service.MessageNotifyService;
import com.biz.crm.member.business.member.sdk.dto.MessageManagePageDto;
import com.biz.crm.member.business.member.sdk.dto.MessageNotifyPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.MessageManagePageVo;
import com.biz.crm.member.business.member.sdk.vo.MessageManageVo;
import com.biz.crm.member.business.member.sdk.vo.MessageNotifyVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import liquibase.pro.packaged.A;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/**
 * @author hupan
 * @date 2023/7/5 16:08
 */
@Service("messageNotifyServiceImpl")
public class MessageNotifyServiceImpl implements MessageNotifyService {

  @Autowired
  private MessageNotifyRepository messageNotifyRepository;
  @Autowired
  private MessageManageRepository messageManageRepository;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;
  @Autowired
  private UserSearchHelper userSearchHelper;

  @Override
  public Page<MessageNotifyVo> findByConditions(
      Pageable pageable, MessageNotifyPaginationDto messageManageDto) {
    if (Objects.isNull(messageManageDto)) {
      messageManageDto = new MessageNotifyPaginationDto();
    }
    messageManageDto.setMemberCode(userSearchHelper.getMemberLogin().getMemberCode());
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    Page<MessageNotifyVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.messageNotifyRepository.findByConditions(page, messageManageDto);
  }

  @Override
  public void create(MessageNotifyVo messageNotifyVo) {
    //根据触发类型和触发条件查询记录
    MessageManage messageManage = messageManageRepository.lambdaQuery()
        .eq(MessageManage::getTriggerType, messageNotifyVo.getTriggerType())
        .eq(MessageManage::getTriggerCondition, messageNotifyVo.getTriggerCondition())
        .one();
    //如果开启了消息通知,则插入记录表
    if (messageManage.getMessageNotify()){
      messageNotifyVo.setTitle(messageManage.getTitle());
      messageNotifyVo.setContent(messageManage.getContent());
      MessageNotify messageNotify = nebulaToolkitService
          .copyObjectByWhiteList(messageNotifyVo, MessageNotify.class,
              HashSet.class, LinkedList.class);
      messageNotify.setSendFlag("0");
      messageNotify.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
      messageNotify.setTenantCode(TenantUtils.getTenantCode());
      messageNotify.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
      messageNotifyRepository.saveOrUpdate(messageNotify);
    }
  }

  private void validate(MessageNotifyVo messageNotifyVo){
    Validate.notNull(messageNotifyVo.getMemberCode(),"会员编码不能为空");
    Validate.notNull(messageNotifyVo.getTriggerType(),"触发类型不能为空");
    Validate.notNull(messageNotifyVo.getTriggerCondition(),"触发条件不能为空");
  }
}
