package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.local.service.NearestAndNearbyStoresAPIService;
import com.biz.crm.member.business.member.sdk.dto.BenefitsManagePaginationDto;
import com.biz.crm.member.business.member.sdk.dto.NearestAndNearbyStoresAPIPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.BenefitsManageVo;
import com.biz.crm.member.business.member.sdk.vo.NearestAndNearbyStoresAPIVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/**
 * @author hupan
 * @date 2023/6/26 16:17
 */
@Service("nearestAndNearbyStoresAPIServiceImpl")
public class NearestAndNearbyStoresAPIServiceImpl implements NearestAndNearbyStoresAPIService {

  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public NearestAndNearbyStoresAPIVo findNearestStores(NearestAndNearbyStoresAPIVo nearestAndNearbyStoresAPIVo) {
    this.validationNearest(nearestAndNearbyStoresAPIVo);
    nearestAndNearbyStoresAPIVo.setAddress("地址");
    nearestAndNearbyStoresAPIVo.setCityName("名字");
    nearestAndNearbyStoresAPIVo.setLatitude(new BigDecimal(464868));
    nearestAndNearbyStoresAPIVo.setLongitude(new BigDecimal("58498"));
    nearestAndNearbyStoresAPIVo.setImage("image");
    return nearestAndNearbyStoresAPIVo;
  }

  @Override
  public List<NearestAndNearbyStoresAPIVo> findByConditional(NearestAndNearbyStoresAPIVo vo) {
    this.validationNearby(vo);
    List<NearestAndNearbyStoresAPIVo> list = new ArrayList<>();
    NearestAndNearbyStoresAPIVo nearestAndNearbyStoresAPIVo = new NearestAndNearbyStoresAPIVo();
    nearestAndNearbyStoresAPIVo.setAddress("地址");
    nearestAndNearbyStoresAPIVo.setCityName("名字");
    nearestAndNearbyStoresAPIVo.setLatitude(new BigDecimal(464868));
    nearestAndNearbyStoresAPIVo.setLongitude(new BigDecimal("58498"));
    nearestAndNearbyStoresAPIVo.setImage("image");
    list.add(nearestAndNearbyStoresAPIVo);
    return list;
  }

  private void validationNearest(NearestAndNearbyStoresAPIVo nearbyStoresAPIVo) {
    Validate.notNull(nearbyStoresAPIVo.getLatitude(), "纬度不能为空");
    Validate.notNull(nearbyStoresAPIVo.getLongitude(), "经度不能为空");
  }
  private void validationNearby(NearestAndNearbyStoresAPIVo nearbyStoresAPIVo) {
    Validate.notNull(nearbyStoresAPIVo.getLatitude(), "纬度不能为空");
    Validate.notNull(nearbyStoresAPIVo.getLongitude(), "经度不能为空");
    Validate.notBlank(nearbyStoresAPIVo.getProvinceName(),"省不能为空");
    Validate.notBlank(nearbyStoresAPIVo.getProvinceCode(),"省code不能为空");
    Validate.notBlank(nearbyStoresAPIVo.getCityName(),"市不能为空");
    Validate.notBlank(nearbyStoresAPIVo.getCityCode(),"市code不能为空");
    Validate.notBlank(nearbyStoresAPIVo.getDistrictName(),"区不能为空");
    Validate.notBlank(nearbyStoresAPIVo.getDistrictCode(),"区code不能为空");
  }
}
