package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.local.entity.Questionnaire;
import com.biz.crm.member.business.member.local.entity.QuestionnaireQuestion;
import com.biz.crm.member.business.member.local.repository.QuestionnaireQuestionRepository;
import com.biz.crm.member.business.member.local.repository.QuestionnaireRepository;
import com.biz.crm.member.business.member.local.service.QuestionnaireQuestionService;
import com.biz.crm.member.business.member.sdk.dto.QuestionDto;
import com.biz.crm.member.business.member.sdk.dto.QuestionnaireQuestionDto;
import com.biz.crm.member.business.member.sdk.vo.QuestionCountVo;
import com.biz.crm.member.business.member.sdk.vo.QuestionVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/20 15:38
 * @description 问卷答题配置管理
 */
@Service
public class QuestionnaireQuestionServiceImpl implements QuestionnaireQuestionService {

  @Autowired
  private QuestionnaireQuestionRepository repository;

  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Autowired
  private GenerateCodeService generateCodeService;


  @Transactional
  @Override
  public void createQuestion(List<QuestionnaireQuestionDto> dtoList, String questionnaireCode) {
    this.validateCreate(dtoList);
    Collection<QuestionnaireQuestion> questionnaireQuestions = this.nebulaToolkitService
        .copyCollectionByWhiteList(dtoList,
            QuestionnaireQuestionDto.class, QuestionnaireQuestion.class, HashSet.class,
            LinkedList.class);
    this.populateProperty(questionnaireQuestions, questionnaireCode);
    this.repository.saveBatch(questionnaireQuestions);
  }


  /**
   * 根据问卷编码获取题目配置信息
   * 根据sortIndex升序排序
   * @param questionnaireCode
   * @return
   */
  @Override
  public List<QuestionVo> listByQuestionnaireCodeOrderBySortIndex(String questionnaireCode) {
    return this.repository.listByQuestionnaireCodeOrderBySortIndex(questionnaireCode);
  }

  /**
   * 根据问卷编码逻辑删除题目
   * @param questionnaireCode
   */
  @Override
  public void logicDeleteByQuestionnaireCode(String questionnaireCode) {
    this.repository.logicDeleteByQuestionnaireCode(questionnaireCode);
  }

  /**
   * 根据题目编码获取题目详情
   * @return
   */
  @Override
  public QuestionnaireQuestion getQuestionInfoByCode(String questionCode) {
    LambdaQueryWrapper<QuestionnaireQuestion> queryWrapper = new LambdaQueryWrapper<>();
    queryWrapper.eq(QuestionnaireQuestion::getCode, questionCode);
    return this.repository.getOne(queryWrapper);
  }

  /**
   * 属性填充
   * @param questionnaireQuestions
   */
  private void populateProperty(Collection<QuestionnaireQuestion> questionnaireQuestions ,String questionnaireCode){
    for (QuestionnaireQuestion question : questionnaireQuestions) {
      question.setQuestionnaireCode(questionnaireCode);
      question.setTenantCode(TenantUtils.getTenantCode());
      question.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
      question.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
      question.setCode(this.generateCodeService.generateCode("TM", 5).get(0));
    }
  }


  /**
   * 校验新增
   * @param dtoList
   */
  private void validateCreate(List<QuestionnaireQuestionDto> dtoList){
    Validate.isTrue(CollectionUtils.isNotEmpty(dtoList), "配置题目不能为空");
    for (QuestionnaireQuestionDto questionDto : dtoList) {
      Validate.notNull(questionDto.getSortIndex(), "题目序号不能为空");
      Validate.notBlank(questionDto.getTitle(), "题目标题不能为空");
      Validate.notBlank(questionDto.getField(), "题目字段不能为空");
    }
  }


}
