package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.local.entity.RafflePrizeDetails;
import com.biz.crm.member.business.member.local.entity.RafflePrizeRecord;
import com.biz.crm.member.business.member.local.mapper.RafflePrizeRecordMapper;
import com.biz.crm.member.business.member.local.repository.RafflePrizeRecordRepository;
import com.biz.crm.member.business.member.local.service.RafflePrizeRecordService;
import com.biz.crm.member.business.member.sdk.dto.RaffleManagePageDto;
import com.biz.crm.member.business.member.sdk.dto.RafflePrizeRecordDto;
import com.biz.crm.member.business.member.sdk.vo.PrizeVo;
import com.biz.crm.member.business.member.sdk.vo.RaffleManagePageVo;
import com.biz.crm.member.business.member.sdk.vo.RafflePrizeRecordVo;
import com.biz.crm.member.business.member.sdk.vo.StaticsPrizeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import jodd.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * TODO
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/20 14:07
 **/
@Service
public class RafflePrizeRecordServiceImpl implements RafflePrizeRecordService {

    @Autowired
    private RafflePrizeRecordRepository rafflePrizeRecordRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Autowired
    private RedisMutexService redisMutexService;

    /**
     * 中奖记录编码redis key
     * 参数：租户
     */
    public static final String MMS_PRIZE_RECORD_REDIS_KEY = "mms:prize:record:index:%s";

    /**
     * 中奖记录编码前缀
     */
    public static final String MMS_PRIZE_RECORD_PREFIX = "ZJ";

    /**
     * 生成编码
     */
    private String generateCode(String tenantCode) {
        String redisKey = String.format(MMS_PRIZE_RECORD_REDIS_KEY, tenantCode);
        String index = redisMutexService.getAndIncrement(redisKey, 1, 6);
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        return StringUtils.join(MMS_PRIZE_RECORD_PREFIX, format.format(new Date()), index);
    }

    @Override
    public Page<RafflePrizeRecordVo> findByConditions(Pageable pageable, RafflePrizeRecordDto rafflePrizeRecordDto) {

        if (Objects.isNull(rafflePrizeRecordDto)) {
            rafflePrizeRecordDto = new RafflePrizeRecordDto();
        }
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
        Page<RafflePrizeRecordVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.rafflePrizeRecordRepository.findByConditions(page, rafflePrizeRecordDto);
    }

    @Override
    public Page<RafflePrizeRecordVo> findByConditionsByApplet(Pageable pageable, RafflePrizeRecordDto rafflePrizeRecordDto) {
        Validate.isTrue(StringUtils.isNotEmpty(rafflePrizeRecordDto.getMemberCode()),"小程序查询中奖记录时,中奖人编码不能为空！");
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
        Page<RafflePrizeRecordVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        Page<RafflePrizeRecordVo> recordVoPage = this.rafflePrizeRecordRepository.findByConditionsByApplet(page, rafflePrizeRecordDto);
        //小程序领奖时间提醒
        int threeDaysMilliseconds = 3 * 24 * 60 * 60 * 1000;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        for (RafflePrizeRecordVo vo:recordVoPage.getRecords()) {
                Date endDate = vo.getEndDate();
                long leftTime = endDate.getTime() - new Date().getTime();
                if (leftTime>=threeDaysMilliseconds) continue;
                if (leftTime<=0){
                    vo.setHint("活动已结束");
                }else {
                    vo.setHint("最迟领奖时间为:"+simpleDateFormat.format(vo.getEndDate()));
                }
        }
        return recordVoPage;
    }

    @Override
    public RafflePrizeRecordVo findDetailById(String id,String code) {
        if(StringUtil.isBlank(id) && StringUtil.isBlank(code)) {
            return null;
        }
        RafflePrizeRecord rafflePrizeRecord = null;
        if(!StringUtil.isBlank(id)) {
            rafflePrizeRecord = this.rafflePrizeRecordRepository.getById(id);
        }else {
            rafflePrizeRecord = this.rafflePrizeRecordRepository.lambdaQuery().eq(RafflePrizeRecord::getCode,code)
                    .eq(RafflePrizeRecord::getDelFlag,DelFlagStatusEnum.NORMAL.getCode()).one();
        }
        Validate.notNull(rafflePrizeRecord,"中奖信息不存在");

        return this.nebulaToolkitService.copyObjectByWhiteList(rafflePrizeRecord,RafflePrizeRecordVo.class, HashSet.class, LinkedList.class);
    }

    @Override
    public RafflePrizeRecordVo create(RafflePrizeRecordDto rafflePrizeRecordDto) {
        this.validateCreate(rafflePrizeRecordDto);

        rafflePrizeRecordDto.setCode(this.generateCode(TenantUtils.getTenantCode()));
        rafflePrizeRecordDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        rafflePrizeRecordDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        rafflePrizeRecordDto.setTenantCode(TenantUtils.getTenantCode());
        RafflePrizeRecord rafflePrizeRecord = this.nebulaToolkitService.copyObjectByWhiteList(rafflePrizeRecordDto, RafflePrizeRecord.class, HashSet.class, LinkedList.class);
        this.rafflePrizeRecordRepository.saveOrUpdate(rafflePrizeRecord);
        return this.nebulaToolkitService.copyObjectByWhiteList(rafflePrizeRecord,RafflePrizeRecordVo.class,HashSet.class,LinkedList.class);
    }

    private void validateCreate(RafflePrizeRecordDto rafflePrizeRecordDto) {


    }

    @Override
    public RafflePrizeRecordVo update(RafflePrizeRecordDto recordDto) {
//        Validate.isTrue(StringUtils.isNoneEmpty(recordDto.getCode()),"中奖记录编码不能为空！");
//        RafflePrizeRecord record = this.rafflePrizeRecordRepository.lambdaQuery().eq(RafflePrizeRecord::getCode, recordDto.getCode()).one();
//        Validate.isTrue("0".equals(record.getClaimStatus()),"请勿重复领取！");
//        //积分在抽中时已发放
//        if (PrizeTypeEnum.INTEGRAL.getCode().equals(record.getPrizeCode())) return;
//        //todo 其余奖品发放
//        if (PrizeTypeEnum.REAL.getCode().equals(record.getPrizeCode())){
//
//        }
        return null;
    }

    @Override
    public void enableBatch(List<String> ids) {

    }

    @Override
    public void disableBatch(List<String> ids) {

    }

    @Override
    public void deleteBatch(List<String> ids) {

    }


    @Override
    public PrizeVo statisticsPrize(String prizeCode) {

//        //奖品配置
//        List<RafflePrizeDetails> details = this.rafflePrizeDetailsRepository.lambdaQuery().eq(RafflePrizeDetails::getPrizeCode, prizeCode)
//                .eq(RafflePrizeDetails::getDelFlag, DelFlagStatusEnum.NORMAL.getCode()).list();
//
//        if(CollectionUtils.isEmpty(details)) {
//            return new PrizeVo();
//        }
//        //中奖记录
//        List<RafflePrizeRecord> records = this.rafflePrizeRecordRepository.lambdaQuery().eq(RafflePrizeRecord::getPrizeCode, prizeCode)
//                .eq(RafflePrizeRecord::getDelFlag, DelFlagStatusEnum.NORMAL.getCode()).list();
        //TODO:待实现
        StaticsPrizeVo staticsPrizeVo = this.rafflePrizeRecordRepository.staticsByStatus(prizeCode);

        PrizeVo prizeVo = new PrizeVo();
        //总数量 = 奖品库存 + 投放数量
//        prizeVo.setTotalNum(staticsPrizeVo.getTotalNum());
        //投放数量 = 投放库存数量 + 中奖数量
        BigDecimal putNum = staticsPrizeVo.getPutNumHit().add(staticsPrizeVo.getPutInventoryNum());
        //投放已中奖
        BigDecimal putNumHit = staticsPrizeVo.getPutNumHit();
        //中奖已领取
        BigDecimal claimed = staticsPrizeVo.getClaimed();
        //中奖未过期
        BigDecimal waitClaimed = staticsPrizeVo.getWaitClaimed();
        //中奖已过期
        BigDecimal expired = staticsPrizeVo.getExpired();
        //领取已使用
        BigDecimal useClaimed = staticsPrizeVo.getUseClaimed();
        //领取未使用
        BigDecimal unUseClaimed = staticsPrizeVo.getUnUseClaimed();
        //领取已过期
        BigDecimal expiredClaimed = staticsPrizeVo.getExpiredClaimed();


        return null;
    }

    @Override
    public void updateClaimStatus(String code, String claimStatus) {
        if(StringUtils.isAnyBlank(code,claimStatus)) {
            return;
        }
        this.rafflePrizeRecordRepository.lambdaUpdate().set(RafflePrizeRecord::getClaimStatus,claimStatus)
                .set(RafflePrizeRecord::getClaimTime,new Date()).eq(RafflePrizeRecord::getCode,code)
                .update();
    }
}
