package com.biz.crm.member.business.member.local.service.internal;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.local.entity.PrizeEntity;
import com.biz.crm.member.business.member.local.entity.RewardActivityUserCountEntity;
import com.biz.crm.member.business.member.local.helper.UserSearchHelper;
import com.biz.crm.member.business.member.local.repository.RewardActivityUserCountRepository;
import com.biz.crm.member.business.member.local.service.*;
import com.biz.crm.member.business.member.sdk.constants.PrizeRedisKeys;
import com.biz.crm.member.business.member.sdk.dto.LotteryDto;
import com.biz.crm.member.business.member.sdk.dto.RaffleMemberDto;
import com.biz.crm.member.business.member.sdk.dto.RafflePrizeRecordDto;
import com.biz.crm.member.business.member.sdk.enums.*;
import com.biz.crm.member.business.member.sdk.vo.*;
import com.biz.crm.member.business.member.sdk.vo.login.MemberUserDetails;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.security.SecureRandom;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * 小程序大转盘抽奖实现类
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/28 15:10
 **/
@Service
public class RewardActivityLotteryServiceImpl implements RewardActivityLotteryService {


    @Autowired
    private RafflePrizeRecordService rafflePrizeRecordService;
    @Autowired
    private RaffleManageService raffleManageService;
    @Autowired
    private RafflePrizeService rafflePrizeService;
    @Autowired
    private UserSearchHelper userSearchHelper;
    @Autowired
    private RewardActivityUserCountRepository rewardActivityUserCountRepository;
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired
    private RafflePrizeDetailsService rafflePrizeDetailsService;
    @Autowired
    private MemberInfoIntegralRecordService memberInfoIntegralRecordService;
    @Autowired
    private PrizeService prizeService;
    @Autowired
    private MemberInfoAssetsService memberInfoAssetsService;
    @Autowired
    private HolidayIntegralAction holidayIntegralAction;


    @Override
    public Page<RafflePrizeRecordVo> findByConditions(Pageable pageable, RafflePrizeRecordDto rafflePrizeRecordDto) {
        if (Objects.isNull(rafflePrizeRecordDto)) {
            rafflePrizeRecordDto = new RafflePrizeRecordDto();
        }

        String memberCode = userSearchHelper.getMemberLogin().getMemberCode();
        Validate.notBlank(memberCode, "获取当前登录人信息失败！");

        rafflePrizeRecordDto.setMemberCode(memberCode);
        Page<RafflePrizeRecordVo> recordVoPage = rafflePrizeRecordService.findByConditions(pageable, rafflePrizeRecordDto);
        return recordVoPage;
    }

    @Override
    public String getRuleDes(String activityCode) {

        RaffleManageVo raffleManageVo = this.raffleManageService.findByActivityCode(activityCode);
        Validate.notNull(raffleManageVo, "活动不存在!");
        return raffleManageVo.getRuleDes();
    }

    @Override
    public LotteryVo rewardInfo(String activityCode) {

        LotteryVo lotteryVo = new LotteryVo();
//        MemberUserDetails memberLogin = userSearchHelper.getMemberLogin();
//        String memberCode = memberLogin.getMemberCode();
        //TODO:写死会员等级
        String memberLevel = "VIP2023063000000041";
        String memberCode = "mm11233444";

//        Validate.notBlank(memberCode, "获取当前登录人信息失败！");

        //查询活动配置
        RaffleManageVo raffleManageVo = raffleManageService.findDetailById(null, activityCode);
        List<RafflePrizeVo> rafflePrizes = raffleManageVo.getRafflePrizes();
        if (CollectionUtils.isEmpty(rafflePrizes)) {
            throw new RuntimeException("活动未配置奖品");
        }

        //奖项配置
        RafflePrizeVo rafflePrizeVo = rafflePrizes.stream().filter(e -> e.getMemberLevels().stream().map(RaffleMemberDto::getMemberLevelCode).collect(Collectors.toList()).contains(memberLevel)).findFirst().orElse(null);
        Validate.notNull(rafflePrizeVo, "对应会员等级未配置奖品");
        lotteryVo.setPrizeVo(rafflePrizeVo);
        //消耗积分配置
        List<RaffleBaseConfigVo> baseConfigs = raffleManageVo.getBaseConfigs();
        if (CollectionUtils.isEmpty(baseConfigs)) {
            throw new RuntimeException("活动未配置抽奖次数");
        }
        RaffleBaseConfigVo raffleBaseConfigVo = baseConfigs.stream().filter(e -> e.getMemberLevels().stream().map(RaffleMemberDto::getMemberLevelCode).collect(Collectors.toList()).contains(memberLevel)).findFirst().orElse(null);
        Validate.notNull(raffleBaseConfigVo, "对应会员等级为配置抽奖次数");
        //每日抽奖剩余次数
        RewardActivityUserCountEntity countEntity = rewardActivityUserCountRepository.lambdaQuery().eq(RewardActivityUserCountEntity::getMemberCode, memberCode).one();
        //如果当前会员抽奖使用次数不存在，则新建
        if (Objects.isNull(countEntity)) {
            RewardActivityUserCountEntity count = new RewardActivityUserCountEntity();
            count.setUseTimes(0);
            count.setMemberCode(memberCode);
            count.setTenantCode(TenantUtils.getTenantCode());
            rewardActivityUserCountRepository.save(count);
            countEntity = count;
        }
        //计算剩余抽奖次数
        Integer remainLotteryNum = raffleBaseConfigVo.getOneRaffleNum() + raffleBaseConfigVo.getTwoRaffleNum() - countEntity.getUseTimes();
        lotteryVo.setRemainLotteryNum(remainLotteryNum);

        //每次抽奖所用积分
        Integer oneRaffleUseIntegral = raffleBaseConfigVo.getOneRaffleUseIntegral();
        Integer twoRaffleUseIntegral = raffleBaseConfigVo.getTwoRaffleUseIntegral();

        //使用抽奖次数 >= 第一阶段配置次数
        if (countEntity.getUseTimes() > raffleBaseConfigVo.getOneRaffleNum()) {
            lotteryVo.setUseIntegral(twoRaffleUseIntegral);
        } else {
            lotteryVo.setUseIntegral(oneRaffleUseIntegral);
        }
        return lotteryVo;
    }

    /**
     * 大转盘抽奖
     *
     * @param lotteryDto
     * @return
     */
    @Transactional
    @Override
    public RafflePrizeDetailsVo lottery(LotteryDto lotteryDto) {
        Validate.notNull(lotteryDto, "实体不能为空");
        Validate.notBlank(lotteryDto.getMemberCode(), "会员编码不能为空");
        Validate.notBlank(lotteryDto.getRafflePrizeCode(), "抽奖大转盘编码不能为空");

        //加会员锁
        String redisKey = String.format(PrizeRedisKeys.TENANT_LOTTERY_MEMBER_LOCK_PREFIX, TenantUtils.getTenantCode() + lotteryDto.getMemberCode() + lotteryDto.getRafflePrizeCode());
        boolean locked = false;
        try {
            locked = redisMutexService.tryLock(redisKey, TimeUnit.SECONDS, 5);
            //TODO:查询会员信息
//            MemberUserDetails memberLogin = userSearchHelper.getMemberLogin();
            String level = "VIP2023063000000041";
            String memberCode = lotteryDto.getMemberCode();

            //查询大转盘奖品配置信息
            RafflePrizeVo rafflePrizeVo = rafflePrizeService.findByCodeAndLevel(lotteryDto.getRafflePrizeCode(), TenantUtils.getTenantCode(), level);

            //校验会员剩余积分，剩余抽奖次数
//            this.validateIntegral(lotteryDto, rafflePrizeVo);
            //用户使用次数增加
            this.rewardActivityUserCountRepository.updateUseTimes(lotteryDto.getMemberCode());
            //扣减积分
            MemberInfoIntegralRecordVo recordVo = new MemberInfoIntegralRecordVo();
            recordVo.setIntegral(lotteryDto.getIntegral());
            recordVo.setMemberCode(memberCode);
            recordVo.setSource(IntegralSourceEnum.BIG_TURNTABLE_PAY.getValue());
            recordVo.setType(IntegralSourceEnum.BIG_TURNTABLE_PAY.getType());
            memberInfoIntegralRecordService.commonInternal(recordVo);
            //获取奖池
            String prizePool = rafflePrizeVo.getPrizePool();
            List<Integer> list = JSONObject.parseArray(prizePool, Integer.class);
            //随机获取奖品
            SecureRandom random = new SecureRandom();
            int num = random.nextInt(list.size());
            //获取奖品等级
            String prizeLevel = String.valueOf(list.get(num));
            //获取奖项
            List<RafflePrizeDetailsVo> details = rafflePrizeVo.getDetails();
            RafflePrizeDetailsVo detailsVo = details.stream().filter(e -> StringUtils.isNotBlank(e.getPrizeLevel()) && e.getPrizeLevel().equals(prizeLevel)).findFirst().orElse(null);

            if (Objects.isNull(detailsVo)) {
                throw new RuntimeException("系统异常,请稍后再试!");
            }

            //有库存
            if (PrizeInventoryEnum.EXITS.getCode().equals(detailsVo.getInventory())) {
                //根据剩余投放库存，判断发放奖品
                detailsVo = getRafflePrizeDetailsVo(rafflePrizeVo, detailsVo);
            }

            //最终发放奖品
            PrizeEntity prizeEntity = prizeService.findByCode(detailsVo.getPrizeCode());
            Validate.notNull(prizeEntity, "未知奖品信息");
            //谢谢参与不记录
            if (PrizeTypeEnum.THANKS.getCode().equals(prizeEntity.getPrizeType())) {
                return detailsVo;
            }
            RafflePrizeRecordDto rafflePrizeRecordDto = new RafflePrizeRecordDto();
            rafflePrizeRecordDto.setClaimStatus(ClaimStatusEnum.NO_CLAIM.getCode());
            //积分，实时发放
            if (PrizeTypeEnum.INTEGRAL.getCode().equals(detailsVo.getPrizeType())) {
                //保存会员积分记录
                MemberInfoIntegralRecordVo vo = new MemberInfoIntegralRecordVo();
                vo.setMemberCode(lotteryDto.getMemberCode());
                vo.setSource(IntegralSourceEnum.BIG_TURNTABLE.getValue());
                vo.setType(IntegralSourceEnum.BIG_TURNTABLE.getType());
                vo.setIntegral(detailsVo.getQuantity().intValue());

                //生日/节日 积分倍数
                //获取当天的节日倍数，生日倍数
                BigDecimal holidayIntegral = this.holidayIntegralAction.getHolidayIntegralByDate(memberCode,detailsVo.getQuantity(),ChannelTypeEnum.RAFFLE.getCode());
                if(!Objects.isNull(holidayIntegral)) {
                    vo.setIntegral(holidayIntegral.intValue());
                }

                memberInfoIntegralRecordService.commonInternal(vo);
                rafflePrizeRecordDto.setClaimStatus(ClaimStatusEnum.CLAIMD.getCode());
            }
            //新增大转盘中奖记录
            RafflePrizeRecordVo rafflePrizeRecordVo = this.buildPrizeRecord(lotteryDto, level, detailsVo, prizeEntity, rafflePrizeRecordDto);
            detailsVo.setRecordCode(rafflePrizeRecordVo.getCode());
            return detailsVo;

        } finally {
            if (locked) {
                redisMutexService.unlock(redisKey);
            }
        }

    }

    /**
     * 组装中奖记录
     *
     * @param lotteryDto
     * @param level
     * @param detailsVo
     * @param prizeEntity
     * @param rafflePrizeRecordDto
     * @return
     */
    private RafflePrizeRecordVo buildPrizeRecord(LotteryDto lotteryDto, String level, RafflePrizeDetailsVo detailsVo, PrizeEntity prizeEntity, RafflePrizeRecordDto rafflePrizeRecordDto) {
        rafflePrizeRecordDto.setActivityCode(lotteryDto.getRaffleActivityCode());
        rafflePrizeRecordDto.setRafflePrizeCode(lotteryDto.getRafflePrizeCode());
        rafflePrizeRecordDto.setRafflePrizeDetailCode(detailsVo.getCode());
        rafflePrizeRecordDto.setMemberCode(lotteryDto.getMemberCode());
        rafflePrizeRecordDto.setEmployStatus(EmployStatusEnum.NO_USE.getCode());
        rafflePrizeRecordDto.setQuantity(detailsVo.getQuantity() == null ? BigDecimal.ZERO : detailsVo.getQuantity());
        //会员等级
        rafflePrizeRecordDto.setMemberLevelCode(level);
        //会员等级名称
        rafflePrizeRecordDto.setMemberLevelName("");
        //奖品编码，名称，等级，类型
        rafflePrizeRecordDto.setPrizeCode(prizeEntity.getCode());
        rafflePrizeRecordDto.setPrizeName(prizeEntity.getPrizeName());
        rafflePrizeRecordDto.setPrizeType(prizeEntity.getPrizeType());
        rafflePrizeRecordDto.setPrizeLevel(detailsVo.getPrizeLevel());
        rafflePrizeRecordDto.setPrizeLevelName(detailsVo.getPrizeLevelName());
        rafflePrizeRecordDto.setUnitPrice(prizeEntity.getUnitPrice());
        rafflePrizeRecordDto.setTotalPrice(ObjectUtil.isNotNull(prizeEntity.getUnitPrice()) ? prizeEntity.getUnitPrice().multiply(detailsVo.getQuantity()) : BigDecimal.ZERO);
        RafflePrizeRecordVo rafflePrizeRecordVo = this.rafflePrizeRecordService.create(rafflePrizeRecordDto);
        return rafflePrizeRecordVo;
    }

    /**
     * 如果奖品
     *
     * @param rafflePrizeVo
     * @param detailsVo
     * @return
     */
    private RafflePrizeDetailsVo getRafflePrizeDetailsVo(RafflePrizeVo rafflePrizeVo, RafflePrizeDetailsVo detailsVo) {
        //判断奖品是否发完
        if (detailsVo.getPutInventoryCopies().compareTo(BigDecimal.ZERO) == 0) {
            //如果发完，根据选择项来发放奖品
            detailsVo = this.forwardBySelect(rafflePrizeVo);
        } else {
            //扣除奖项投放份数，减少投放库存
            //TODO:调整库存份数 -1
            int i = this.rafflePrizeDetailsService.reduceInventory(detailsVo.getCode(), new BigDecimal("-1"));
            //扣除失败
            if (i != 1) {
                //扣除失败，按照奖品发完处理
                detailsVo = this.forwardBySelect(rafflePrizeVo);
            }
        }
        return detailsVo;
    }

    //根据奖品发完之后逻辑发奖
    public RafflePrizeDetailsVo forwardBySelect(RafflePrizeVo rafflePrizeVo) {

        List<RafflePrizeDetailsVo> details = rafflePrizeVo.getDetails();

        String prizeOverSelect = rafflePrizeVo.getPrizeOverSelect();
        if (PrizeOverSelectEnum.NONE.getCode().equals(prizeOverSelect)) {
            //不发奖
            return details.stream().filter(e -> e.getPrizeType().equals(PrizeTypeEnum.THANKS.getCode())).findFirst().orElse(null);
        } else if (PrizeOverSelectEnum.NO_INVENTORY.getCode().equals(prizeOverSelect)) {
            //发无库存奖品
            return details.stream().filter(e -> e.getPrizeFlag()).findFirst().orElse(null);
        } else {
            //一级一级的往下发
            List<RafflePrizeDetailsVo> collect = details.stream().sorted(Comparator.comparing(RafflePrizeDetailsVo::getPrizeLevel, Comparator.reverseOrder())).collect(Collectors.toList());
            for (RafflePrizeDetailsVo detailsVo : collect) {
                if (detailsVo.getPutInventoryCopies().compareTo(BigDecimal.ZERO) != 0) {
                    return detailsVo;
                }
            }
        }

        return null;

    }

    private void validateIntegral(LotteryDto lotteryDto, RafflePrizeVo rafflePrizeVo) {

        MemberInfoAssetsVo detailByMemberCode = memberInfoAssetsService.findDetailByMemberCode(lotteryDto.getMemberCode());
        Integer currentIntegral = detailByMemberCode.getCurrentIntegral();
        if (lotteryDto.getIntegral() > currentIntegral) {
            throw new RuntimeException("积分余额不足");
        }

        RewardActivityUserCountEntity countEntity = this.rewardActivityUserCountRepository.lambdaQuery().eq(RewardActivityUserCountEntity::getMemberCode, lotteryDto.getMemberCode())
                .one();
        if (rafflePrizeVo.getOneRaffleNum() + rafflePrizeVo.getTwoRaffleNum() <= countEntity.getUseTimes()) {
            throw new RuntimeException("抽奖次数已经消耗完了");
        }

    }
}
