package com.biz.crm.member.business.member.local.service.internal;

import cn.hutool.core.collection.CollUtil;
import com.biz.crm.member.business.member.local.service.*;
import com.biz.crm.member.business.member.sdk.dto.RewardInfoDto;
import com.biz.crm.member.business.member.sdk.dto.RewardUserDto;
import com.biz.crm.member.business.member.sdk.enums.ClaimStatusEnum;
import com.biz.crm.member.business.member.sdk.enums.OrderSourceEnum;
import com.biz.crm.member.business.member.sdk.enums.PrizeTypeEnum;
import com.biz.crm.member.business.member.sdk.vo.DummyOrderUserVo;
import com.biz.crm.member.business.member.sdk.vo.DummyOrderVo;
import com.biz.crm.member.business.member.sdk.vo.RafflePrizeRecordVo;
import com.biz.crm.member.business.member.sdk.vo.RealOrderVo;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

/**
 * 奖励信息实现类
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/30 14:44
 **/
@Service
public class RewardInfoServiceImpl implements RewardInfoService {

    @Autowired
    private RafflePrizeRecordService rafflePrizeRecordService;
    @Autowired
    private DummyOrderService dummyOrderService;
    @Autowired
    private RealOrderService realOrderService;
    @Autowired
    private DummyOrderUserService dummyOrderUserService;

    @Transactional
    @Override
    public void claim(RewardInfoDto rewardInfoDto) {

        Validate.notNull(rewardInfoDto, "领取信息不能为空");
        Validate.notBlank(rewardInfoDto.getMemberCode(), "会员编码不能为空");
        Validate.notBlank(rewardInfoDto.getRecordCode(), "中奖编码不能为空");
        //查询中奖记录信息
        RafflePrizeRecordVo rafflePrizeRecordVo = this.rafflePrizeRecordService.findDetailById(null, rewardInfoDto.getRecordCode());

        Date now = new Date();
        if (PrizeTypeEnum.REAL.getCode().equals(rafflePrizeRecordVo.getPrizeType())) {
            //实物
            Validate.notBlank(rewardInfoDto.getReceiptName(), "收货人不能为空");
            Validate.notBlank(rewardInfoDto.getReceiptAddress(), "收货地址不能为空");
            Validate.notBlank(rewardInfoDto.getReceiptPhone(), "收获人手机号码不能为空");

            RealOrderVo realOrderVo = new RealOrderVo();
            //订单来源
            realOrderVo.setOrderSource(OrderSourceEnum.INTERACT_ACTIVITY.getValue());
            realOrderVo.setOrderTime(now);
//            dummyOrderVo.setOrderName();
            realOrderVo.setProductCode(rafflePrizeRecordVo.getPrizeCode());
            realOrderVo.setProductName(rafflePrizeRecordVo.getPrizeName());
            realOrderVo.setRelationCode(rewardInfoDto.getRecordCode());
            this.realOrderService.create(realOrderVo);
        } else {
            //虚拟
            List<RewardUserDto> users = rewardInfoDto.getUsers();
            if (CollUtil.isEmpty(users)) {
                throw new RuntimeException("虚拟物品，领取时请录入人员");
            }
            //保存订单
            DummyOrderVo dummyOrderVo = new DummyOrderVo();
            dummyOrderVo.setOrderSource(OrderSourceEnum.INTERACT_ACTIVITY.getValue());
            dummyOrderVo.setOrderTime(now);
//            dummyOrderVo.setOrderName();
            dummyOrderVo.setProductCode(rafflePrizeRecordVo.getPrizeCode());
            dummyOrderVo.setProductName(rafflePrizeRecordVo.getPrizeName());
            dummyOrderVo.setRelationCode(rewardInfoDto.getRecordCode());

            DummyOrderVo orderVo = this.dummyOrderService.create(dummyOrderVo);

            //保存订单用户
            for (RewardUserDto user : users) {
                Validate.notBlank(user.getName(), "姓名不能为空");
                Validate.notBlank(user.getPhone(), "手机号码不能为空");
                DummyOrderUserVo userVo = new DummyOrderUserVo();
                userVo.setName(user.getName());
                userVo.setPhone(user.getPhone());
                userVo.setOrderCode(orderVo.getOrderCode());
                dummyOrderUserService.create(userVo);
            }

        }

        //中奖记录修改为已领取
        this.rafflePrizeRecordService.updateClaimStatus(rafflePrizeRecordVo.getCode(), ClaimStatusEnum.CLAIMD.getCode());

    }
}
