package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.local.entity.ScenicAreaManagement;
import com.biz.crm.member.business.member.local.entity.ScenicImageManagement;
import com.biz.crm.member.business.member.local.repository.ScenicAreaManagementRepository;
import com.biz.crm.member.business.member.local.service.ScenicAreaManagementService;
import com.biz.crm.member.business.member.local.service.ScenicImageManagementService;
import com.biz.crm.member.business.member.sdk.dto.ScenicAreaManagementPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.ScenicAreaManagementVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author hupan
 * @date 2023/6/20 10:52
 */
@Slf4j
@Service("scenicAreaManagementServiceImpl")
public class ScenicAreaManagementServiceImpl implements ScenicAreaManagementService {

  @Autowired(required = false)
  private GenerateCodeService generateCodeService;
  @Autowired
  private ScenicImageManagementService scenicImageManagementService;
  @Autowired
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;
  @Autowired
  private ScenicAreaManagementRepository scenicAreaManagementRepository;

  @Override
  public Page<ScenicAreaManagementVo> findByConditions(Pageable pageable, ScenicAreaManagementPaginationDto dto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    dto = Optional.ofNullable(dto).orElse(new ScenicAreaManagementPaginationDto());
    Page<ScenicAreaManagementVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.scenicAreaManagementRepository.findByConditions(page, dto);
  }

  @Override
  @Transactional
  public ScenicAreaManagementVo create(ScenicAreaManagementVo scenicAreaManagementVo) {
    this.createValidation(scenicAreaManagementVo);
    ScenicAreaManagement scenicAreaManagement = this.nebulaToolkitService.copyObjectByWhiteList(scenicAreaManagementVo, ScenicAreaManagement.class, HashSet.class, LinkedList.class);
    scenicAreaManagement.setId(null);
    scenicAreaManagement.setTenantCode(TenantUtils.getTenantCode());
    scenicAreaManagement.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    scenicAreaManagement.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    scenicAreaManagement.setCode(this.generateCodeService.generateCode("JQ",5).get(0));
    log.info("========================》》》》》{}",scenicAreaManagement);
    log.info("<<<<<<========================");
    this.scenicAreaManagementRepository.saveOrUpdate(scenicAreaManagement);
    //新增图片
    String scenicId = scenicAreaManagement.getId();
    if (StringUtils.isNotEmpty(scenicAreaManagementVo.getScenicIcon())){
      this.setImage(scenicId,"scenicIcon",scenicAreaManagementVo.getScenicIcon());
    }
    if (StringUtils.isNotEmpty(scenicAreaManagementVo.getAnchorIcon())){
      this.setImage(scenicId,"anchorIcon",scenicAreaManagementVo.getAnchorIcon());
    }
    if (StringUtils.isNotEmpty(scenicAreaManagementVo.getBackgroundPicture())){
      this.setImage(scenicId,"backgroundPicture",scenicAreaManagementVo.getBackgroundPicture());
    }
    return scenicAreaManagementVo;
  }

  @Override
  public ScenicAreaManagementVo findDetailById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    ScenicAreaManagement scenicAreaManagement = this.scenicAreaManagementRepository.findById(id);
    Validate.notNull(scenicAreaManagement,"景区未找到");
    ScenicAreaManagementVo scenicAreaManagementVo = this.nebulaToolkitService.copyObjectByWhiteList(scenicAreaManagement, ScenicAreaManagementVo.class, HashSet.class, LinkedList.class);
    scenicAreaManagementVo.setScenicIcon(this.getImage(id,"scenicIcon").getUrl());
    scenicAreaManagementVo.setBackgroundPicture(this.getImage(id,"backgroundPicture").getUrl());
    scenicAreaManagementVo.setAnchorIcon(this.getImage(id,"anchorIcon").getUrl());
    return scenicAreaManagementVo;
  }

  @Override
  @Transactional
  public ScenicAreaManagementVo update(ScenicAreaManagementVo scenicAreaManagementVo) {
    this.updateValidation(scenicAreaManagementVo);
    String currentId = scenicAreaManagementVo.getId();
    ScenicAreaManagement current = scenicAreaManagementRepository.findById(currentId);
    current = Validate.notNull(current, "修改信息不存在");
    current = this.nebulaToolkitService
        .copyObjectByWhiteList(scenicAreaManagementVo, ScenicAreaManagement.class, HashSet.class,
            LinkedList.class);
    this.scenicAreaManagementRepository.saveOrUpdate(current);
    //更新图片
    if (StringUtils.isNotEmpty(scenicAreaManagementVo.getScenicIcon())){
      this.removeImageByScenicIdAndType(scenicAreaManagementVo.getId(),"scenicIcon");
      this.setImage(scenicAreaManagementVo.getId(),"scenicIcon",scenicAreaManagementVo.getScenicIcon());
    }
    if (StringUtils.isNotEmpty(scenicAreaManagementVo.getAnchorIcon())){
      this.removeImageByScenicIdAndType(scenicAreaManagementVo.getId(),"anchorIcon");
      this.setImage(scenicAreaManagementVo.getId(),"anchorIcon",scenicAreaManagementVo.getAnchorIcon());
    }
    if (StringUtils.isNotEmpty(scenicAreaManagementVo.getBackgroundPicture())){
      this.removeImageByScenicIdAndType(scenicAreaManagementVo.getId(),"backgroundPicture");
      this.setImage(scenicAreaManagementVo.getId(),"backgroundPicture",scenicAreaManagementVo.getBackgroundPicture());
    }
    return scenicAreaManagementVo;
  }

  @Override
  @Transactional
  public void enableBatch(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.scenicAreaManagementRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
  }

  @Override
  @Transactional
  public void disableBatch(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.scenicAreaManagementRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
  }

  @Override
  @Transactional
  public void updateDelFlagByIds(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.scenicAreaManagementRepository.updateDelFlagByIds(ids);
  }

  private void setImage(String scenicId,String type,String url) {
    ScenicImageManagement scenicImageManagement = new ScenicImageManagement();
    scenicImageManagement.setScenicAreaId(scenicId);
    scenicImageManagement.setId(null);
    scenicImageManagement.setType(type);
    scenicImageManagement.setUrl(url);
    scenicImageManagement.setTenantCode(TenantUtils.getTenantCode());
    this.scenicImageManagementService.save(scenicImageManagement);
  }

  private void removeImageByScenicIdAndType(String scenicId,String type) {
    ScenicImageManagement scenicImageManagement = new ScenicImageManagement();
    scenicImageManagement.setScenicAreaId(scenicId);
    scenicImageManagement.setType(type);
    this.scenicImageManagementService.removeImageByScenicIdAndType(scenicImageManagement);
  }

  private ScenicImageManagement getImage(String scenicId,String type) {
    ScenicImageManagement scenicImageManagement = new ScenicImageManagement();
    scenicImageManagement.setScenicAreaId(scenicId);
    scenicImageManagement.setType(type);
    List<ScenicImageManagement> list =  this.scenicImageManagementService.selectByScenicAreaIdAndType(scenicImageManagement);
    for (ScenicImageManagement imageManagement : list) {
      return imageManagement;
    }
    return null;
  }

  private void createValidation(ScenicAreaManagementVo scenicAreaManagementVo) {
    this.validation(scenicAreaManagementVo);
  }

  private void updateValidation(ScenicAreaManagementVo scenicAreaManagementVo) {
    this.validation(scenicAreaManagementVo);
  }

  private void validation(ScenicAreaManagementVo scenicAreaManagementVo) {
    Validate.notBlank(scenicAreaManagementVo.getName(), "景区名称不能为空");
    Validate.notBlank(scenicAreaManagementVo.getScenicIcon(), "景区icon不能为空");
    Validate.notNull(scenicAreaManagementVo.getAnchorIcon(),"锚点icon不能为空");
  }
}
