package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.biz.crm.member.business.member.local.entity.ScenicImageManagement;
import com.biz.crm.member.business.member.local.mapper.ScenicImageManagementMapper;
import com.biz.crm.member.business.member.local.repository.ScenicImageManagementRepository;
import com.biz.crm.member.business.member.local.service.ScenicImageManagementService;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author hupan
 * @date 2023/6/20 10:53
 */
@Slf4j
@Service("scenicImageManagementServiceImpl")
public class ScenicImageManagementServiceImpl implements ScenicImageManagementService {

  @Autowired
  private ScenicImageManagementRepository scenicImageManagementRepository;
  @Autowired
  private ScenicImageManagementMapper scenicImageManagementMapper;

  @Override
  public void save(ScenicImageManagement scenicImageManagement) {
    this.scenicImageManagementRepository.save(scenicImageManagement);
  }

  @Override
  public void removeImageByScenicIdAndType(ScenicImageManagement scenicImageManagement) {
    this.scenicImageManagementRepository
        .lambdaUpdate()
        .set(ScenicImageManagement::getScenicAreaId,scenicImageManagement.getScenicAreaId())
        .set(ScenicImageManagement::getType,scenicImageManagement.getType())
        .remove();
  }

  @Override
  public List<ScenicImageManagement> selectByScenicAreaIdAndType(ScenicImageManagement scenicImageManagement) {
    return this.scenicImageManagementRepository
        .lambdaQuery()
        .eq(ScenicImageManagement::getScenicAreaId,scenicImageManagement.getScenicAreaId())
        .eq(ScenicImageManagement::getType,scenicImageManagement.getType())
        .list();
  }

  @Override
  public List<ScenicImageManagement> selectListByScenicId(String scenicId) {
    return this.scenicImageManagementRepository
        .lambdaQuery()
        .eq(ScenicImageManagement::getScenicAreaId,scenicId)
        .list();
  }

  @Override
  public void removeByIds(List<String> ids) {
    this.scenicImageManagementRepository
        .lambdaUpdate()
        .in(ScenicImageManagement::getId,ids)
        .remove();
  }
}
