package com.biz.crm.member.business.member.local.service.internal;

import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.local.entity.BenefitsManage;
import com.biz.crm.member.business.member.local.entity.ScenicAreaManagement;
import com.biz.crm.member.business.member.local.entity.ScenicImageManagement;
import com.biz.crm.member.business.member.local.entity.ScenicSpotsManagement;
import com.biz.crm.member.business.member.local.repository.ScenicSpotsManagementRepository;
import com.biz.crm.member.business.member.local.service.ScenicImageManagementService;
import com.biz.crm.member.business.member.local.service.ScenicSpotsManagementService;
import com.biz.crm.member.business.member.sdk.vo.BenefitsManageOrgVo;
import com.biz.crm.member.business.member.sdk.vo.BenefitsManageVo;
import com.biz.crm.member.business.member.sdk.vo.ScenicAreaManagementVo;
import com.biz.crm.member.business.member.sdk.vo.ScenicSpotsManagementVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author hupan
 * @date 2023/6/20 10:54
 */
@Slf4j
@Service("scenicSpotsManagementServiceImpl")
public class ScenicSpotsManagementServiceImpl implements ScenicSpotsManagementService {

  @Autowired
  private ScenicSpotsManagementRepository scenicSpotsManagementRepository;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;
  @Autowired
  private ScenicImageManagementService scenicImageManagementService;
  @Autowired
  private GenerateCodeService generateCodeService;

  @Override
  public List<ScenicSpotsManagementVo> findByScenicId(String id) {
    List<ScenicSpotsManagement> list = scenicSpotsManagementRepository
        .lambdaQuery()
        .eq(ScenicSpotsManagement::getScenicAreaId,id)
        .list();
    List<ScenicSpotsManagementVo> result = new ArrayList<>();
    for (ScenicSpotsManagement scenicSpotsManagement : list) {
      ScenicSpotsManagementVo scenicSpotsManagementVo = nebulaToolkitService.copyObjectByWhiteList(scenicSpotsManagement,ScenicSpotsManagementVo.class,
          HashSet.class, LinkedList.class);
      scenicSpotsManagementVo.setScenicPicture(this.getImage(id,"scenicPicture").getUrl());
      scenicSpotsManagementVo.setScenicVRPicture(this.getImage(id,"scenicVRPicture").getUrl());
      scenicSpotsManagementVo.setScenicVRVideo(this.getImage(id,"scenicVRVideo").getUrl());
      scenicSpotsManagementVo.setThumbnailPicture(this.getImage(id,"thumbnailPicture").getUrl());
      result.add(scenicSpotsManagementVo);
    }
    return result;
  }

  @Override
  @Transactional
  public ScenicSpotsManagementVo create(ScenicSpotsManagementVo scenicSpotsManagementVo) {
    this.createValidation(scenicSpotsManagementVo);
    ScenicSpotsManagement spotsManagement = this.nebulaToolkitService.copyObjectByWhiteList(scenicSpotsManagementVo, ScenicSpotsManagement.class, HashSet.class, LinkedList.class);
    spotsManagement.setId(null);
    spotsManagement.setTenantCode(TenantUtils.getTenantCode());
    spotsManagement.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    spotsManagement.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    spotsManagement.setCode(this.generateCodeService.generateCode("JD",5).get(0));
    this.scenicSpotsManagementRepository.saveOrUpdate(spotsManagement);
    //新增图片
    String scenicId = spotsManagement.getScenicAreaId();
    if (StringUtils.isNotEmpty(scenicSpotsManagementVo.getScenicPicture())){
      this.setImage(scenicId,"scenicPicture",scenicSpotsManagementVo.getScenicPicture());
    }
    if (StringUtils.isNotEmpty(scenicSpotsManagementVo.getThumbnailPicture())){
      this.setImage(scenicId,"thumbnailPicture",scenicSpotsManagementVo.getThumbnailPicture());
    }
    if (StringUtils.isNotEmpty(scenicSpotsManagementVo.getScenicVRPicture())){
      this.setImage(scenicId,"scenicVRPicture",scenicSpotsManagementVo.getScenicVRPicture());
    }
    if (StringUtils.isNotEmpty(scenicSpotsManagementVo.getScenicVRVideo())){
      this.setImage(scenicId,"scenicVRVideo",scenicSpotsManagementVo.getScenicVRVideo());
    }
    return scenicSpotsManagementVo;
  }

  @Override
  @Transactional
  public ScenicSpotsManagementVo update(ScenicSpotsManagementVo scenicSpotsManagementVo) {
    this.updateValidation(scenicSpotsManagementVo);
    String currentId = scenicSpotsManagementVo.getId();
    String scenicId = scenicSpotsManagementVo.getScenicAreaId();
    ScenicSpotsManagement current = scenicSpotsManagementRepository.findById(currentId);
    current = Validate.notNull(current, "修改信息不存在");
    current = this.nebulaToolkitService
        .copyObjectByWhiteList(scenicSpotsManagementVo, ScenicSpotsManagement.class, HashSet.class,
            LinkedList.class);
    this.scenicSpotsManagementRepository.saveOrUpdate(current);
    //更新图片
    if (StringUtils.isNotEmpty(scenicSpotsManagementVo.getScenicPicture())){
      this.removeImageByScenicIdAndType(scenicId,"scenicPicture");
      this.setImage(scenicId,"scenicPicture",scenicSpotsManagementVo.getScenicPicture());
    }
    if (StringUtils.isNotEmpty(scenicSpotsManagementVo.getThumbnailPicture())){
      this.removeImageByScenicIdAndType(scenicId,"thumbnailPicture");
      this.setImage(scenicId,"thumbnailPicture",scenicSpotsManagementVo.getThumbnailPicture());
    }
    if (StringUtils.isNotEmpty(scenicSpotsManagementVo.getScenicVRPicture())){
      this.removeImageByScenicIdAndType(scenicId,"scenicVRPicture");
      this.setImage(scenicId,"scenicVRPicture",scenicSpotsManagementVo.getScenicVRPicture());
    }
    if (StringUtils.isNotEmpty(scenicSpotsManagementVo.getScenicVRVideo())){
      this.removeImageByScenicIdAndType(scenicId,"scenicVRVideo");
      this.setImage(scenicId,"scenicVRVideo",scenicSpotsManagementVo.getScenicVRVideo());
    }
    return scenicSpotsManagementVo;
  }

  private void setImage(String scenicId,String type,String url) {
    ScenicImageManagement scenicImageManagement = new ScenicImageManagement();
    scenicImageManagement.setScenicAreaId(scenicId);
    scenicImageManagement.setId(null);
    scenicImageManagement.setType(type);
    scenicImageManagement.setUrl(url);
    scenicImageManagement.setTenantCode(TenantUtils.getTenantCode());
    this.scenicImageManagementService.save(scenicImageManagement);
  }

  private void removeImageByScenicIdAndType(String scenicId,String type) {
    ScenicImageManagement scenicImageManagement = new ScenicImageManagement();
    scenicImageManagement.setScenicAreaId(scenicId);
    scenicImageManagement.setType(type);
    this.scenicImageManagementService.removeImageByScenicIdAndType(scenicImageManagement);
  }

  private ScenicImageManagement getImage(String scenicId,String type) {
    ScenicImageManagement scenicImageManagement = new ScenicImageManagement();
    scenicImageManagement.setScenicAreaId(scenicId);
    scenicImageManagement.setType(type);
    List<ScenicImageManagement> list = this.scenicImageManagementService.selectByScenicAreaIdAndType(scenicImageManagement);
    for (ScenicImageManagement imageManagement : list) {
      return imageManagement;
    }
    return null;
  }

  private void createValidation(ScenicSpotsManagementVo scenicSpotsManagementVo) {
    this.validation(scenicSpotsManagementVo);
  }

  private void updateValidation(ScenicSpotsManagementVo scenicSpotsManagementVo) {
    this.validation(scenicSpotsManagementVo);
  }

  private void validation(ScenicSpotsManagementVo scenicSpotsManagementVo) {
    Validate.notBlank(scenicSpotsManagementVo.getName(), "景点名称不能为空");
  }
}
