package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.local.entity.LevelManageBenefitsDetail;
import com.biz.crm.member.business.member.local.entity.SignInRuleDetail;
import com.biz.crm.member.business.member.local.repository.SignInRuleDetailRepository;
import com.biz.crm.member.business.member.local.service.SignInRuleDetailService;
import com.biz.crm.member.business.member.sdk.dto.SignInRuleDetailPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.LevelManageBenefitsDetailVo;
import com.biz.crm.member.business.member.sdk.vo.SignInRuleDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 签到规则明细(SignInRuleDetail)表服务实现类
 *
 * @author zouhs
 * @date 2023-06-15 16:47:45
 */
@Slf4j
@Service("signInRuleDetailService")
public class SignInRuleDetailServiceImpl implements SignInRuleDetailService {
  
  @Autowired(required = false)
  private SignInRuleDetailRepository signInRuleDetailRepository;

  @Autowired(required = false)
  private GenerateCodeService generateCodeService;

  @Autowired
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public Page<SignInRuleDetailVo> findByConditions(Pageable pageable, SignInRuleDetailPaginationDto dto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    dto = Optional.ofNullable(dto).orElse(new SignInRuleDetailPaginationDto());
    Page<SignInRuleDetailVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.signInRuleDetailRepository.findByConditions(page, dto);
  }

  @Override
  public SignInRuleDetailVo findDetailById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    SignInRuleDetail signInRuleDetail = this.signInRuleDetailRepository.findById(id);
    SignInRuleDetailVo signInRuleDetailVo = this.nebulaToolkitService.copyObjectByWhiteList(signInRuleDetail, SignInRuleDetailVo.class, HashSet.class, LinkedList.class);


    return signInRuleDetailVo;
  }
  
  @Override
  @Transactional
  public SignInRuleDetailVo create(SignInRuleDetailVo signInRuleDetailVo) {
    this.createValidation(signInRuleDetailVo);
    SignInRuleDetail signInRuleDetail = this.nebulaToolkitService.copyObjectByWhiteList(signInRuleDetailVo, SignInRuleDetail.class, HashSet.class, LinkedList.class);
    String tenantCode = TenantUtils.getTenantCode();
    Validate.notBlank(tenantCode,"tenantCode不能为空");
    signInRuleDetail.setTenantCode(tenantCode);
    signInRuleDetail.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    signInRuleDetail.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    this.signInRuleDetailRepository.saveOrUpdate(signInRuleDetail);
    return signInRuleDetailVo;
  }

  @Override
  @Transactional
  public SignInRuleDetailVo update(SignInRuleDetailVo signInRuleDetailVo) {
    this.updateValidation(signInRuleDetailVo);
    String currentId = signInRuleDetailVo.getId();
    SignInRuleDetail current = signInRuleDetailRepository.findById(currentId);
    current = Validate.notNull(current, "修改信息不存在");
    current = this.nebulaToolkitService.copyObjectByWhiteList(signInRuleDetailVo, SignInRuleDetail.class, HashSet.class, LinkedList.class);
    this.signInRuleDetailRepository.saveOrUpdate(current);
    return signInRuleDetailVo;
  }

  @Override
  @Transactional
  public void enableBatch(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.signInRuleDetailRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
  }

  @Override
  @Transactional
  public void disableBatch(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.signInRuleDetailRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
  }
  
  @Override
  @Transactional
  public void updateDelFlagByIds(List<String> ids) {
    Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
    this.signInRuleDetailRepository.updateDelFlagByIds(ids);
  }

  @Override
  public void batchSaveOrUpdate(List<SignInRuleDetailVo> list) {
    List<SignInRuleDetail> oldList = this.signInRuleDetailRepository.lambdaQuery()
        .eq(SignInRuleDetail::getSignInId, list.get(0).getSignInId()).list();
    if(CollectionUtils.isNotEmpty(oldList)){
      Set<String> ids = oldList.stream().map(UuidEntity::getId).collect(Collectors.toSet());
      this.signInRuleDetailRepository.removeByIds(ids);
    }
    for (SignInRuleDetailVo signInRuleDetailVo : list) {
      this.create(signInRuleDetailVo);
    }
  }

  @Override
  public List<SignInRuleDetailVo> findListDetailById(String id) {
    List<SignInRuleDetail> list = this.signInRuleDetailRepository.lambdaQuery()
        .eq(SignInRuleDetail::getSignInId,id).orderByAsc(SignInRuleDetail::getSeq).list();
    if(CollectionUtils.isEmpty(list)){
      return Lists.newArrayList();
    }
    return (List<SignInRuleDetailVo>)this.nebulaToolkitService.copyCollectionByWhiteList(list, SignInRuleDetail.class, SignInRuleDetailVo.class, HashSet.class, ArrayList.class);
  }

  private void createValidation(SignInRuleDetailVo signInRuleDetailVo) {
    this.validation(signInRuleDetailVo);
  }

  private void updateValidation(SignInRuleDetailVo signInRuleDetailVo) {
    this.validation(signInRuleDetailVo);
  }

  private void validation(SignInRuleDetailVo signInRuleDetailVo) {
    Validate.notBlank(signInRuleDetailVo.getSignInId(), "签到规则ID不能为空");
    Validate.notNull(signInRuleDetailVo.getLinkDayNum(), "本月连续签到X天不能为空");
    Validate.notNull(signInRuleDetailVo.getLinkIntegralNum(), "可额外获得x积分");
    Validate.notBlank(signInRuleDetailVo.getIconImage(),"图标不能为空");
  }
}
