package com.biz.crm.member.business.member.local.service.internal;

import com.biz.crm.member.business.member.local.entity.SystemSettingsDetail;
import com.biz.crm.member.business.member.local.repository.SystemSettingsDetailRepository;
import com.biz.crm.member.business.member.local.service.SystemSettingsDetailService;
import com.biz.crm.member.business.member.sdk.enums.SystemSettingsDetailEnum;
import com.biz.crm.member.business.member.sdk.vo.SystemSettingsDetailVo;
import com.biz.crm.member.business.member.sdk.vo.SystemSettingsVo;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletSystemSettingsServiceVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 系统设置明细表服务层
 *
 * @author hupan
 * @date 2023/6/21 11:03
 */
@Slf4j
@Service("systemSettingsDetailServiceImpl")
public class SystemSettingsDetailServiceImpl implements SystemSettingsDetailService {

  @Autowired
  private SystemSettingsDetailRepository systemSettingsDetailRepository;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public List<SystemSettingsDetailVo> update(List<SystemSettingsDetailVo> systemSettingsDetailVos) {
    this.validation(systemSettingsDetailVos);
    for (SystemSettingsDetailVo systemSettingsDetailVo : systemSettingsDetailVos) {
      SystemSettingsDetail systemSettingsDetail = this.nebulaToolkitService
          .copyObjectByWhiteList(systemSettingsDetailVo, SystemSettingsDetail.class,
              HashSet.class, LinkedList.class);
      systemSettingsDetailRepository.saveOrUpdate(systemSettingsDetail);
    }
    return systemSettingsDetailVos;
  }

  @Override
  public SystemSettingsDetail findValueByKey(String key) {
    return systemSettingsDetailRepository.findValueByKey(key);
  }

  @Override
  public AppletSystemSettingsServiceVo findByType(String type) {
    AppletSystemSettingsServiceVo appletSystemSettingsServiceVo = new AppletSystemSettingsServiceVo();
    List<SystemSettingsDetail> list = systemSettingsDetailRepository.lambdaQuery()
        .eq(SystemSettingsDetail::getType, type)
        .list();
    for (SystemSettingsDetail systemSettingsDetail : list) {
      if (SystemSettingsDetailEnum.ONLINE_CUSTOMER_SERVICE_SETTINGS.getValue()
          .equals(systemSettingsDetail.getTypeKey())) {
        appletSystemSettingsServiceVo
            .setOnlineCustomerServiceConfig(systemSettingsDetail.getTypeValue());
      }
      if (SystemSettingsDetailEnum.TELEPHONE_CUSTOMER_SERVICE_SETTINGS.getValue()
          .equals(systemSettingsDetail.getTypeKey())) {
        appletSystemSettingsServiceVo
            .setTelephoneCustomerServiceConfig(systemSettingsDetail.getTypeValue());
      }
      if (SystemSettingsDetailEnum.CUSTOMER_SERVICE_TELEPHONE.getValue()
          .equals(systemSettingsDetail.getTypeKey())) {
        appletSystemSettingsServiceVo.setHotline(systemSettingsDetail.getTypeValue());
      }
    }
    return appletSystemSettingsServiceVo;
  }

  private void validation(List<SystemSettingsDetailVo> systemSettingsDetailVos) {
    for (SystemSettingsDetailVo systemSettingsDetailVo : systemSettingsDetailVos) {
      Validate.notBlank(systemSettingsDetailVo.getType(), "系统类型不能为空");
      Validate.notBlank(systemSettingsDetailVo.getId(), "id不能为空");
      Validate.notBlank(systemSettingsDetailVo.getTypeKey(), "属性key不能为空");
    }
  }
}
